/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.config;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;

public class ServerConfig {
    private String host;
    private int port = -1;
    private String protocol;
    private String path = null;
    private String proxyHost;
    private int proxyPort = -1;
    private boolean unsafe = false;

    public ServerConfig() {
    }

    public ServerConfig(URL url) {
        this.host = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
        this.setPath(url.getFile());
    }

    public ServerConfig(String urlString) throws MalformedURLException {
        this(new URL(urlString));
    }

    public String getUrlString() {
        return this.addUrlString(new StringBuilder(40)).toString();
    }

    private StringBuilder addUrlString(StringBuilder builder) {
        if (this.protocol != null) {
            builder.append(this.protocol).append("://");
        }
        builder.append(this.host);
        if (this.port != -1) {
            builder.append(':').append(this.port);
        }
        if (this.path != null) {
            builder.append(this.path);
        }
        return builder;
    }

    public static String getPaths(List<ServerConfig> configList) {
        StringBuilder builder = new StringBuilder(configList.size() * 40);
        boolean first = true;
        for (ServerConfig server : configList) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            server.addUrlString(builder);
        }
        return builder.toString();
    }

    public URL getUrl() {
        try {
            return new URL(this.protocol, this.host, this.port, this.path == null ? "" : this.path);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Already parsed a URL but it turned out invalid", ex);
        }
    }

    public HttpUrl getHttpUrl() {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(this.protocol).host(this.host);
        if (this.port != -1) {
            urlBuilder.port(this.port);
        }
        if (this.path != null) {
            urlBuilder.encodedPath(this.path);
        }
        return urlBuilder.build();
    }

    public Proxy getHttpProxy() {
        if (this.proxyHost == null) {
            return null;
        }
        if (this.proxyPort == -1) {
            throw new IllegalStateException("proxy_port is not specified for server " + this.getUrlString() + " with proxyHost");
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase("http") && !this.protocol.equalsIgnoreCase("https")) {
            throw new IllegalStateException("Server is not an HTTP(S) server, so it cannot use a HTTP proxyHost.");
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        if (path == null) {
            this.path = "/";
        } else {
            if (path.contains("?")) {
                throw new IllegalArgumentException("Cannot set server path with query string");
            }
            this.path = path.trim();
            if (this.path.isEmpty()) {
                this.path = "/";
            } else {
                if (this.path.charAt(0) != '/') {
                    this.path = '/' + this.path;
                }
                if (this.path.charAt(this.path.length() - 1) != '/') {
                    this.path = this.path + '/';
                }
            }
        }
    }

    public String toString() {
        return this.getUrlString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ServerConfig otherConfig = (ServerConfig)other;
        return Objects.equals(this.host, otherConfig.host) && this.port == otherConfig.port && this.unsafe == otherConfig.unsafe && Objects.equals(this.protocol, otherConfig.protocol) && Objects.equals(this.proxyHost, otherConfig.proxyHost) && this.proxyPort == otherConfig.proxyPort;
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.host, this.port);
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }
}

