/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.radarbase.data.AvroDecoder;

public class AvroDatumDecoder
implements AvroDecoder {
    private final DecoderFactory decoderFactory;
    private final boolean binary;
    private final GenericData genericData;

    public AvroDatumDecoder(GenericData genericData, boolean binary) {
        this.genericData = genericData;
        this.decoderFactory = DecoderFactory.get();
        this.binary = binary;
    }

    @Override
    public <T> AvroDecoder.AvroReader<T> reader(Schema schema, Class<? extends T> clazz) {
        DatumReader reader = this.genericData.createDatumReader(schema);
        return new AvroRecordReader(schema, reader);
    }

    private class AvroRecordReader<T>
    implements AvroDecoder.AvroReader<T> {
        private final DatumReader<T> reader;
        private final Schema schema;
        private Decoder decoder;

        private AvroRecordReader(Schema schema, DatumReader<T> reader) {
            this.reader = reader;
            this.schema = schema;
            this.decoder = null;
        }

        @Override
        public T decode(byte[] record) throws IOException {
            return this.decode(record, 0);
        }

        @Override
        public T decode(byte[] record, int offset) throws IOException {
            this.decoder = AvroDatumDecoder.this.binary ? AvroDatumDecoder.this.decoderFactory.binaryDecoder(record, offset, record.length - offset, (BinaryDecoder)this.decoder) : AvroDatumDecoder.this.decoderFactory.jsonDecoder(this.schema, (InputStream)new ByteArrayInputStream(record, offset, record.length - offset));
            return (T)this.reader.read(null, this.decoder);
        }
    }
}

