/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.radarbase.data.RecordData;
import org.radarbase.topic.AvroTopic;

public class AvroRecordData<K, V>
implements RecordData<K, V> {
    private final AvroTopic<K, V> topic;
    private final K key;
    private final List<V> records;

    public AvroRecordData(AvroTopic<K, V> topic, K key, List<V> values) {
        this.topic = Objects.requireNonNull(topic);
        this.key = Objects.requireNonNull(key);
        this.records = Objects.requireNonNull(values);
        if (this.records.isEmpty()) {
            throw new IllegalArgumentException("Records should not be empty.");
        }
    }

    @Override
    public AvroTopic<K, V> getTopic() {
        return this.topic;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public Iterator<V> iterator() {
        return this.records.iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.records.size();
    }
}

