/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.radarbase.data.AvroEncoder;
import org.radarbase.producer.rest.ParsedSchemaMetadata;

public class AvroRecordWriter<T>
implements AvroEncoder.AvroWriter<T> {
    private final Encoder encoder;
    private final ByteArrayOutputStream out;
    private final DatumWriter<T> writer;
    private ParsedSchemaMetadata serverSchema;

    public AvroRecordWriter(EncoderFactory encoderFactory, Schema schema, DatumWriter<T> writer, boolean binary) throws IOException {
        this.writer = writer;
        this.out = new ByteArrayOutputStream();
        this.encoder = binary ? encoderFactory.binaryEncoder((OutputStream)this.out, null) : encoderFactory.jsonEncoder(schema, (OutputStream)this.out);
    }

    @Override
    public byte[] encode(T record) throws IOException {
        try {
            this.writer.write(record, this.encoder);
            this.encoder.flush();
            byte[] byArray = this.out.toByteArray();
            return byArray;
        }
        finally {
            this.out.reset();
        }
    }

    @Override
    public void setReaderSchema(ParsedSchemaMetadata readerSchema) {
        this.serverSchema = readerSchema;
    }

    @Override
    public ParsedSchemaMetadata getReaderSchema() {
        return this.serverSchema;
    }
}

