/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TimedInt {
    private final AtomicInteger value = new AtomicInteger();
    private final AtomicLong time = new AtomicLong(-1L);

    public int getValue() {
        return this.value.get();
    }

    public long getTime() {
        return this.time.get();
    }

    public void add(int delta) {
        this.value.addAndGet(delta);
        this.time.set(System.currentTimeMillis());
    }

    public void set(int value) {
        this.value.set(value);
        this.time.set(System.currentTimeMillis());
    }

    public synchronized boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        TimedInt timedOther = (TimedInt)other;
        return this.value.equals(timedOther.value) && this.time.equals(timedOther.time);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + this.time.hashCode();
    }
}

