/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.radarbase.producer.rest.AvroDataMapper;
import org.radarbase.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvroDataMapperFactory {
    private static final Logger logger = LoggerFactory.getLogger(AvroDataMapperFactory.class);
    public static final AvroDataMapper IDENTITY_MAPPER = new AvroDataMapper(){

        @Override
        public Object convertAvro(Object obj) {
            return obj;
        }

        public String toString() {
            return "Identity";
        }
    };
    private static final AvroDataMapperFactory INSTANCE = new AvroDataMapperFactory();

    public static AvroDataMapperFactory get() {
        return INSTANCE;
    }

    public AvroDataMapper createMapper(Schema from, Schema to, Object defaultVal) throws SchemaValidationException {
        if (from.equals((Object)to)) {
            logger.debug("Using identity schema mapping from {} to {}", (Object)from, (Object)to);
            return IDENTITY_MAPPER;
        }
        logger.debug("Computing custom mapping from {} to {}", (Object)from, (Object)to);
        try {
            if (to.getType() == Schema.Type.UNION || from.getType() == Schema.Type.UNION) {
                return this.mapUnion(from, to, defaultVal);
            }
            if (to.getType() == Schema.Type.ENUM || to.getType() == Schema.Type.ENUM) {
                return AvroDataMapperFactory.mapEnum(from, to, defaultVal);
            }
            switch (to.getType()) {
                case INT: 
                case LONG: 
                case DOUBLE: 
                case FLOAT: {
                    return AvroDataMapperFactory.mapNumber(from, to, defaultVal);
                }
            }
            switch (from.getType()) {
                case RECORD: {
                    return this.mapRecord(from, to);
                }
                case ARRAY: {
                    return this.mapArray(from, to);
                }
                case MAP: {
                    return this.mapMap(from, to);
                }
                case FIXED: 
                case BYTES: {
                    return this.mapBytes(from, to, defaultVal);
                }
                case INT: 
                case LONG: 
                case DOUBLE: 
                case FLOAT: {
                    return AvroDataMapperFactory.mapNumber(from, to, defaultVal);
                }
            }
            if (from.getType() != to.getType()) {
                throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Schema types of from and to don't match"));
            }
            return IDENTITY_MAPPER;
        }
        catch (SchemaValidationException ex) {
            if (defaultVal != null) {
                if (defaultVal == JsonProperties.NULL_VALUE) {
                    return obj -> null;
                }
                return obj -> defaultVal;
            }
            throw ex;
        }
    }

    private static AvroDataMapper mapEnum(Schema from, Schema to, Object defaultVal) throws SchemaValidationException {
        if (to.getType() == Schema.Type.ENUM) {
            boolean containsAll = true;
            if (from.getType() == Schema.Type.ENUM) {
                for (String s : from.getEnumSymbols()) {
                    if (to.hasEnumSymbol(s)) continue;
                    containsAll = false;
                    break;
                }
            } else if (from.getType() == Schema.Type.STRING) {
                containsAll = false;
            } else {
                throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map enum from non-string or enum type"));
            }
            if (containsAll) {
                return obj -> new GenericData.EnumSymbol(to, obj.toString());
            }
            String defaultString = (String)defaultVal;
            if (defaultString == null && to.hasEnumSymbol("UNKNOWN")) {
                defaultString = "UNKNOWN";
            }
            if (defaultString == null) {
                throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map enum symbols without default value"));
            }
            GenericData.EnumSymbol symbol = new GenericData.EnumSymbol(to, defaultString);
            return arg_0 -> AvroDataMapperFactory.lambda$mapEnum$3(to, (GenericEnumSymbol)symbol, arg_0);
        }
        if (from.getType() == Schema.Type.ENUM && to.getType() == Schema.Type.STRING) {
            return Object::toString;
        }
        throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map unknown type with enum."));
    }

    private static Object getDefaultValue(Object defaultVal, Schema schema) {
        if (defaultVal == null) {
            return null;
        }
        if (schema.getType() == Schema.Type.ENUM) {
            return new GenericData.EnumSymbol(schema, defaultVal);
        }
        return defaultVal;
    }

    private static AvroDataMapper mapNumber(Schema from, Schema to, Object defaultVal) throws SchemaValidationException {
        if (from.getType() == to.getType()) {
            return IDENTITY_MAPPER;
        }
        if (from.getType() == Schema.Type.STRING) {
            if (defaultVal == null) {
                throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map string to number without default value."));
            }
            switch (to.getType()) {
                case INT: {
                    return new StringToNumberMapper(defaultVal){

                        @Override
                        public Number stringToNumber(String obj) {
                            return Integer.valueOf(obj);
                        }
                    };
                }
                case LONG: {
                    return new StringToNumberMapper(defaultVal){

                        @Override
                        public Number stringToNumber(String obj) {
                            return Long.valueOf(obj);
                        }
                    };
                }
                case DOUBLE: {
                    return new StringToNumberMapper(defaultVal){

                        @Override
                        public Number stringToNumber(String obj) {
                            return Double.valueOf(obj);
                        }
                    };
                }
                case FLOAT: {
                    return new StringToNumberMapper(defaultVal){

                        @Override
                        public Number stringToNumber(String obj) {
                            return Float.valueOf(obj);
                        }
                    };
                }
            }
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map numeric type with non-numeric type"));
        }
        switch (to.getType()) {
            case INT: {
                return obj -> ((Number)obj).intValue();
            }
            case LONG: {
                return obj -> ((Number)obj).longValue();
            }
            case DOUBLE: {
                return obj -> Double.valueOf(obj.toString());
            }
            case FLOAT: {
                return obj -> Float.valueOf(((Number)obj).floatValue());
            }
            case STRING: {
                return Object::toString;
            }
        }
        throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map numeric type with non-numeric type"));
    }

    private static Schema nonNullUnionSchema(Schema schema) throws SchemaValidationException {
        List types = schema.getTypes();
        if (types.size() != 2) {
            throw new SchemaValidationException(schema, schema, (Throwable)new IllegalArgumentException("Types must denote optionals"));
        }
        if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
            if (((Schema)types.get(1)).getType() != Schema.Type.NULL) {
                return (Schema)types.get(1);
            }
            throw new SchemaValidationException(schema, schema, (Throwable)new IllegalArgumentException("Types must denote optionals"));
        }
        if (((Schema)types.get(1)).getType() == Schema.Type.NULL) {
            return (Schema)types.get(0);
        }
        throw new SchemaValidationException(schema, schema, (Throwable)new IllegalArgumentException("Types must denote optionals."));
    }

    private AvroDataMapper mapUnion(Schema from, Schema to, Object defaultVal) throws SchemaValidationException {
        Schema resolvedFrom;
        Schema schema = resolvedFrom = from.getType() == Schema.Type.UNION ? AvroDataMapperFactory.nonNullUnionSchema(from) : from;
        if (from.getType() == Schema.Type.UNION && to.getType() != Schema.Type.UNION) {
            if (defaultVal != null) {
                Object actualDefault = AvroDataMapperFactory.getDefaultValue(defaultVal, to);
                AvroDataMapper subMapper = this.createMapper(resolvedFrom, to, defaultVal);
                return obj -> {
                    if (obj == null) {
                        return actualDefault;
                    }
                    return subMapper.convertAvro(obj);
                };
            }
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map union to non-union without a default value"));
        }
        Schema toNonNull = AvroDataMapperFactory.nonNullUnionSchema(to);
        AvroDataMapper unionMapper = this.createMapper(resolvedFrom, toNonNull, defaultVal);
        return obj -> {
            if (obj == null) {
                return null;
            }
            return unionMapper.convertAvro(obj);
        };
    }

    private AvroDataMapper mapArray(Schema from, Schema to) throws SchemaValidationException {
        if (to.getType() != Schema.Type.ARRAY) {
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map array to non-array"));
        }
        AvroDataMapper subMapper = this.createMapper(from.getElementType(), to.getElementType(), null);
        return obj -> {
            List array = (List)obj;
            ArrayList<Object> toArray = new ArrayList<Object>(array.size());
            for (Object val : array) {
                toArray.add(subMapper.convertAvro(val));
            }
            return toArray;
        };
    }

    private AvroDataMapper mapMap(Schema from, Schema to) throws SchemaValidationException {
        if (to.getType() != Schema.Type.MAP) {
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map array to non-array"));
        }
        AvroDataMapper subMapper = this.createMapper(from.getValueType(), to.getValueType(), null);
        return obj -> {
            Map map = (Map)obj;
            HashMap<String, Object> toMap = new HashMap<String, Object>(map.size() * 4 / 3 + 1);
            for (Map.Entry entry : map.entrySet()) {
                toMap.put(((CharSequence)entry.getKey()).toString(), subMapper.convertAvro(entry.getValue()));
            }
            return toMap;
        };
    }

    private AvroDataMapper mapBytes(Schema from, Schema to, Object defaultVal) throws SchemaValidationException {
        if (from.getType() == to.getType() && (from.getType() == Schema.Type.BYTES || from.getType() == Schema.Type.FIXED && from.getFixedSize() == to.getFixedSize())) {
            return IDENTITY_MAPPER;
        }
        if (from.getType() == Schema.Type.FIXED && to.getType() == Schema.Type.BYTES) {
            return object -> ByteBuffer.wrap(((GenericData.Fixed)object).bytes());
        }
        if (from.getType() == Schema.Type.BYTES && to.getType() == Schema.Type.FIXED) {
            if (defaultVal == null) {
                throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map bytes to fixed without default value"));
            }
            return object -> {
                byte[] bytes = ((ByteBuffer)object).array();
                if (bytes.length == to.getFixedSize()) {
                    return GenericData.get().createFixed(null, bytes, to);
                }
                return GenericData.get().createFixed(null, (byte[])defaultVal, to);
            };
        }
        if (to.getType() == Schema.Type.STRING) {
            Base64.Encoder encoder = Base64.getEncoder();
            if (from.getType() == Schema.Type.FIXED) {
                return object -> encoder.encode(((GenericData.Fixed)object).bytes());
            }
            return object -> encoder.encode(((ByteBuffer)object).array());
        }
        throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Fixed type must be mapped to comparable byte size"));
    }

    private AvroDataMapper mapRecord(Schema from, Schema to) throws SchemaValidationException {
        int i;
        if (to.getType() != Schema.Type.RECORD) {
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("From and to schemas must be records."));
        }
        List fromFields = from.getFields();
        Schema.Field[] toFields = new Schema.Field[fromFields.size()];
        AvroDataMapper[] fieldMappers = new AvroDataMapper[fromFields.size()];
        boolean[] filledPositions = new boolean[to.getFields().size()];
        for (i = 0; i < fromFields.size(); ++i) {
            Schema.Field fromField = (Schema.Field)fromFields.get(i);
            Schema.Field toField = to.getField(fromField.name());
            if (toField == null) continue;
            filledPositions[toField.pos()] = true;
            Schema fromSchema = fromField.schema();
            Schema toSchema = toField.schema();
            toFields[i] = toField;
            fieldMappers[i] = this.createMapper(fromSchema, toSchema, toField.defaultVal());
        }
        for (i = 0; i < filledPositions.length; ++i) {
            if (filledPositions[i] || ((Schema.Field)to.getFields().get(i)).defaultVal() != null) continue;
            throw new SchemaValidationException(to, from, (Throwable)new IllegalArgumentException("Cannot map to record without default value for new field " + ((Schema.Field)to.getFields().get(i)).name()));
        }
        return new RecordMapper(to, toFields, fieldMappers);
    }

    private static /* synthetic */ Object lambda$mapEnum$3(Schema to, GenericEnumSymbol symbol, Object obj) {
        String value = obj.toString();
        if (to.hasEnumSymbol(value)) {
            return new GenericData.EnumSymbol(to, value);
        }
        return symbol;
    }

    private static abstract class StringToNumberMapper
    implements AvroDataMapper {
        private final Object defaultVal;

        StringToNumberMapper(Object defaultVal) {
            this.defaultVal = defaultVal;
        }

        @Override
        public Object convertAvro(Object object) {
            try {
                return this.stringToNumber(object.toString());
            }
            catch (NumberFormatException ex) {
                return this.defaultVal;
            }
        }

        abstract Number stringToNumber(String var1);
    }

    private static class RecordMapper
    implements AvroDataMapper {
        private final AvroDataMapper[] fieldMappers;
        private final Schema.Field[] toFields;
        private final Schema toSchema;

        RecordMapper(Schema toSchema, Schema.Field[] toFields, AvroDataMapper[] fieldMappers) {
            this.toSchema = toSchema;
            this.fieldMappers = fieldMappers;
            this.toFields = toFields;
        }

        public GenericRecord convertAvro(Object obj) {
            GenericRecordBuilder builder = new GenericRecordBuilder(this.toSchema);
            IndexedRecord record = (IndexedRecord)obj;
            for (int i = 0; i < this.toFields.length; ++i) {
                Schema.Field field = this.toFields[i];
                if (field == null) continue;
                builder.set(field, this.fieldMappers[i].convertAvro(record.get(i)));
            }
            return builder.build();
        }

        public String toString() {
            return "RecordMapper{fieldMappers=" + Arrays.toString(this.fieldMappers) + ", toFields=" + Arrays.toString(this.toFields) + '}';
        }
    }
}

