/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.avro.SchemaValidationException;
import org.radarbase.data.AvroEncoder;
import org.radarbase.data.RecordData;
import org.radarbase.data.RemoteSchemaEncoder;
import org.radarbase.producer.rest.ParsedSchemaMetadata;
import org.radarbase.producer.rest.RecordRequest;
import org.radarbase.topic.AvroTopic;
import org.radarbase.util.Strings;

public class JsonRecordRequest<K, V>
implements RecordRequest<K, V> {
    public static final byte[] KEY_SCHEMA_ID = Strings.utf8("\"key_schema_id\":");
    public static final byte[] VALUE_SCHEMA_ID = Strings.utf8(",\"value_schema_id\":");
    public static final byte[] RECORDS = Strings.utf8(",\"records\":[");
    public static final byte[] KEY = Strings.utf8("{\"key\":");
    public static final byte[] VALUE = Strings.utf8(",\"value\":");
    public static final byte[] END = Strings.utf8("]}");
    private final AvroEncoder.AvroWriter<K> keyEncoder;
    private final AvroEncoder.AvroWriter<V> valueEncoder;
    private RecordData<K, V> records;

    public JsonRecordRequest(AvroTopic<K, V> topic) {
        RemoteSchemaEncoder schemaEncoder = new RemoteSchemaEncoder(false);
        this.keyEncoder = schemaEncoder.writer(topic.getKeySchema(), topic.getKeyClass());
        this.valueEncoder = schemaEncoder.writer(topic.getValueSchema(), topic.getValueClass());
    }

    @Override
    public void writeToSink(BufferedSink sink) throws IOException {
        this.writeToSink(sink, Integer.MAX_VALUE);
    }

    private void writeToSink(BufferedSink sink, int maxLength) throws IOException {
        sink.writeByte(123);
        sink.write(KEY_SCHEMA_ID);
        sink.write(Strings.utf8(String.valueOf(this.keyEncoder.getReaderSchema().getId())));
        sink.write(VALUE_SCHEMA_ID);
        sink.write(Strings.utf8(String.valueOf(this.valueEncoder.getReaderSchema().getId())));
        sink.write(RECORDS);
        byte[] key = this.keyEncoder.encode(this.records.getKey());
        int curLength = KEY_SCHEMA_ID.length + VALUE_SCHEMA_ID.length + 7;
        boolean first = true;
        for (Object record : this.records) {
            if (curLength >= maxLength) {
                return;
            }
            if (first) {
                first = false;
            } else {
                sink.writeByte(44);
            }
            sink.write(KEY);
            sink.write(key);
            sink.write(VALUE);
            byte[] valueBytes = this.valueEncoder.encode(record);
            sink.write(valueBytes);
            sink.writeByte(125);
            curLength += 2 + key.length + KEY.length + VALUE.length + valueBytes.length;
        }
        sink.write(END);
    }

    @Override
    public void reset() {
        this.records = null;
    }

    @Override
    public void prepare(ParsedSchemaMetadata keySchema, ParsedSchemaMetadata valueSchema, RecordData<K, V> records) throws SchemaValidationException {
        this.keyEncoder.setReaderSchema(keySchema);
        this.valueEncoder.setReaderSchema(valueSchema);
        this.records = records;
    }

    @Override
    public String content(int maxLength) throws IOException {
        Buffer buffer = new Buffer();
        this.writeToSink((BufferedSink)buffer, maxLength);
        return buffer.readString(Math.min(buffer.size(), (long)maxLength), StandardCharsets.UTF_8);
    }
}

