/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.avro.SchemaValidationException;
import org.radarbase.config.ServerConfig;
import org.radarbase.producer.AuthenticationException;
import org.radarbase.producer.KafkaSender;
import org.radarbase.producer.KafkaTopicSender;
import org.radarbase.producer.rest.ConnectionState;
import org.radarbase.producer.rest.RestClient;
import org.radarbase.producer.rest.RestTopicSender;
import org.radarbase.producer.rest.SchemaRetriever;
import org.radarbase.topic.AvroTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSender
implements KafkaSender {
    private static final Logger logger = LoggerFactory.getLogger(RestSender.class);
    public static final String KAFKA_REST_ACCEPT_ENCODING = "application/vnd.kafka.v2+json, application/vnd.kafka+json, application/json";
    public static final String KAFKA_REST_ACCEPT_LEGACY_ENCODING = "application/vnd.kafka.v1+json, application/vnd.kafka+json, application/json";
    public static final MediaType KAFKA_REST_BINARY_ENCODING = MediaType.parse((String)"application/vnd.radarbase.avro.v1+binary");
    public static final MediaType KAFKA_REST_AVRO_ENCODING = MediaType.parse((String)"application/vnd.kafka.avro.v2+json; charset=utf-8");
    public static final MediaType KAFKA_REST_AVRO_LEGACY_ENCODING = MediaType.parse((String)"application/vnd.kafka.avro.v1+json; charset=utf-8");
    private RequestProperties requestProperties;
    private Request.Builder connectionTestRequest;
    private SchemaRetriever schemaRetriever;
    private RestClient httpClient;
    private final ConnectionState state;

    private RestSender(Builder builder) {
        this.schemaRetriever = Objects.requireNonNull(builder.retriever);
        this.requestProperties = new RequestProperties(KAFKA_REST_ACCEPT_ENCODING, builder.binary ? KAFKA_REST_BINARY_ENCODING : KAFKA_REST_AVRO_ENCODING, builder.additionalHeaders.build(), builder.binary);
        this.state = builder.state;
        this.setRestClient(Objects.requireNonNull(builder.client).newBuilder().protocols(Collections.singletonList(Protocol.HTTP_1_1)).build());
    }

    public synchronized void setConnectionTimeout(long connectionTimeout, TimeUnit unit) {
        if (connectionTimeout != this.httpClient.getTimeout()) {
            this.httpClient = this.httpClient.newBuilder().timeout(connectionTimeout, unit).build();
            this.state.setTimeout(connectionTimeout, unit);
        }
    }

    public synchronized void setKafkaConfig(ServerConfig kafkaConfig) {
        Objects.requireNonNull(kafkaConfig);
        if (kafkaConfig.equals(this.httpClient.getServer())) {
            return;
        }
        this.setRestClient(this.httpClient.newBuilder().server(kafkaConfig).build());
    }

    private void setRestClient(RestClient newClient) {
        try {
            this.connectionTestRequest = newClient.requestBuilder("").head();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Schemaless topics do not have a valid URL", ex);
        }
        this.httpClient = newClient;
        this.state.reset();
    }

    public final synchronized void setSchemaRetriever(SchemaRetriever retriever) {
        this.schemaRetriever = retriever;
    }

    public synchronized RestClient getRestClient() {
        return this.httpClient;
    }

    public synchronized SchemaRetriever getSchemaRetriever() {
        return this.schemaRetriever;
    }

    private synchronized Request getConnectionTestRequest() {
        return this.connectionTestRequest.headers(this.requestProperties.headers).build();
    }

    public synchronized void setCompression(boolean useCompression) {
        this.httpClient = this.httpClient.newBuilder().gzipCompression(useCompression).build();
    }

    public synchronized Headers getHeaders() {
        return this.requestProperties.headers;
    }

    public synchronized void setHeaders(Headers additionalHeaders) {
        this.requestProperties = new RequestProperties(this.requestProperties.acceptType, this.requestProperties.contentType, additionalHeaders, this.requestProperties.binary);
        this.state.reset();
    }

    @Override
    public <K, V> KafkaTopicSender<K, V> sender(AvroTopic<K, V> topic) throws SchemaValidationException {
        return new RestTopicSender<K, V>(topic, this, this.state);
    }

    public synchronized RequestProperties getRequestProperties() {
        return this.requestProperties;
    }

    public synchronized RequestContext getRequestContext() {
        return new RequestContext(this.httpClient, this.requestProperties);
    }

    @Override
    public boolean resetConnection() throws AuthenticationException {
        if (this.state.getState() == ConnectionState.State.CONNECTED) {
            return true;
        }
        try (Response response = this.httpClient.request(this.getConnectionTestRequest());){
            if (response.isSuccessful()) {
                this.state.didConnect();
            } else if (response.code() == 401) {
                this.state.wasUnauthorized();
            } else {
                this.state.didDisconnect();
                String bodyString = RestClient.responseBody(response);
                logger.warn("Failed to make heartbeat request to {} (HTTP status code {}): {}", new Object[]{this.httpClient, response.code(), bodyString});
            }
        }
        catch (IOException ex) {
            this.state.didDisconnect();
            logger.warn("Failed to make heartbeat request to {}: {}", (Object)this.httpClient, (Object)ex.toString());
        }
        if (this.state.getState() == ConnectionState.State.UNAUTHORIZED) {
            throw new AuthenticationException("HEAD request unauthorized");
        }
        return this.state.getState() == ConnectionState.State.CONNECTED;
    }

    @Override
    public boolean isConnected() throws AuthenticationException {
        switch (this.state.getState()) {
            case CONNECTED: {
                return true;
            }
            case DISCONNECTED: {
                return false;
            }
            case UNAUTHORIZED: {
                throw new AuthenticationException("Unauthorized");
            }
            case UNKNOWN: {
                return this.resetConnection();
            }
        }
        throw new IllegalStateException("Illegal connection state");
    }

    @Override
    public void close() {
    }

    public synchronized void useLegacyEncoding(String acceptEncoding, MediaType contentEncoding, boolean binary) {
        logger.debug("Reverting to encoding {} -> {} (binary: {})", new Object[]{contentEncoding, acceptEncoding, binary});
        this.requestProperties = new RequestProperties(acceptEncoding, contentEncoding, this.requestProperties.headers, binary);
    }

    static final class RequestProperties {
        final String acceptType;
        final MediaType contentType;
        final Headers headers;
        final boolean binary;

        RequestProperties(String acceptType, MediaType contentType, Headers headers, boolean binary) {
            this.acceptType = acceptType;
            this.contentType = contentType;
            this.headers = headers;
            this.binary = binary;
        }
    }

    static final class RequestContext {
        final RequestProperties properties;
        final RestClient client;

        RequestContext(RestClient client, RequestProperties properties) {
            this.properties = properties;
            this.client = client;
        }
    }

    public static class Builder {
        private SchemaRetriever retriever;
        private ConnectionState state;
        private RestClient client;
        private Headers.Builder additionalHeaders = new Headers.Builder();
        private boolean binary = false;

        public Builder schemaRetriever(SchemaRetriever schemaRetriever) {
            this.retriever = schemaRetriever;
            return this;
        }

        public Builder useBinaryContent(boolean binary) {
            this.binary = binary;
            return this;
        }

        @Deprecated
        public Builder hasBinaryContent(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder connectionState(ConnectionState state) {
            this.state = state;
            return this;
        }

        public Builder httpClient(RestClient client) {
            this.client = client;
            return this;
        }

        public Builder headers(Headers headers) {
            this.additionalHeaders = headers.newBuilder();
            return this;
        }

        public Builder addHeader(String header, String value) {
            this.additionalHeaders.add(header + ": " + value);
            return this;
        }

        public RestSender build() {
            if (this.state == null) {
                this.state = new ConnectionState(30L, TimeUnit.SECONDS);
            }
            return new RestSender(this);
        }
    }
}

