/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.apache.avro.Schema;
import org.json.JSONException;
import org.json.JSONObject;
import org.radarbase.producer.rest.ParsedSchemaMetadata;
import org.radarbase.producer.rest.RestClient;
import org.radarbase.util.Strings;

public class SchemaRestClient {
    private final RestClient client;

    public SchemaRestClient(RestClient client) {
        this.client = client;
    }

    public ParsedSchemaMetadata retrieveSchemaMetadata(String subject, int version) throws JSONException, IOException {
        boolean isLatest = version <= 0;
        StringBuilder pathBuilder = new StringBuilder(50).append("/subjects/").append(subject).append("/versions/");
        if (isLatest) {
            pathBuilder.append("latest");
        } else {
            pathBuilder.append(version);
        }
        JSONObject node = this.requestJson(pathBuilder.toString());
        int newVersion = isLatest ? node.getInt("version") : version;
        int schemaId = node.getInt("id");
        Schema schema = this.parseSchema(node.getString("schema"));
        return new ParsedSchemaMetadata(schemaId, newVersion, schema);
    }

    private JSONObject requestJson(String path) throws IOException {
        Request request = this.client.requestBuilder(path).addHeader("Accept", "application/json").build();
        String response = this.client.requestString(request);
        return new JSONObject(response);
    }

    public Schema parseSchema(String schemaString) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(schemaString);
    }

    public int addSchema(String subject, Schema schema) throws IOException {
        Request request = this.client.requestBuilder("/subjects/" + subject + "/versions").addHeader("Accept", "application/json").post((RequestBody)new SchemaRequestBody(schema)).build();
        String response = this.client.requestString(request);
        JSONObject node = new JSONObject(response);
        return node.getInt("id");
    }

    public ParsedSchemaMetadata requestMetadata(String subject, Schema schema) throws IOException {
        Request request = this.client.requestBuilder("/subjects/" + subject).addHeader("Accept", "application/json").post((RequestBody)new SchemaRequestBody(schema)).build();
        String response = this.client.requestString(request);
        JSONObject node = new JSONObject(response);
        return new ParsedSchemaMetadata(node.getInt("id"), node.getInt("version"), schema);
    }

    public Schema retrieveSchemaById(int id) throws JSONException, IOException {
        JSONObject node = this.requestJson("/schemas/ids/" + id);
        return this.parseSchema(node.getString("schema"));
    }

    private static class SchemaRequestBody
    extends RequestBody {
        private static final byte[] SCHEMA = Strings.utf8("{\"schema\":");
        private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/vnd.schemaregistry.v1+json; charset=utf-8");
        private final Schema schema;

        private SchemaRequestBody(Schema schema) {
            this.schema = schema;
        }

        public MediaType contentType() {
            return CONTENT_TYPE;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(SCHEMA);
            sink.writeUtf8(JSONObject.quote((String)this.schema.toString()));
            sink.writeByte(125);
        }
    }
}

