/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.radarbase.producer.rest.RecordRequest;

class TopicRequestBody
extends RequestBody {
    protected final RecordRequest<?, ?> data;
    private final MediaType mediaType;

    TopicRequestBody(RecordRequest<?, ?> requestData, MediaType mediaType) {
        this.data = requestData;
        this.mediaType = mediaType;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.data.writeToSink(sink);
    }

    static String topicRequestContent(Request request, int maxLength) throws IOException {
        TopicRequestBody body = (TopicRequestBody)request.body();
        if (body == null) {
            return null;
        }
        return body.data.content(maxLength);
    }
}

