/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;
import org.radarbase.producer.rest.RestClient;
import org.radarbase.producer.rest.TopicRequestBody;

public class UncheckedRequestException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final int LOG_CONTENT_LENGTH = 1024;

    public UncheckedRequestException(String message, IOException cause) {
        super(message, cause);
    }

    public void rethrow() throws IOException {
        if (this.getCause() instanceof IOException) {
            throw (IOException)this.getCause();
        }
        throw new IOException(this);
    }

    public static UncheckedRequestException fail(Request request, Response response, IOException cause) throws IOException {
        String content;
        StringBuilder message = new StringBuilder(128);
        message.append("FAILED to transmit message");
        if (response != null) {
            message.append(" (HTTP status code ").append(response.code()).append(')');
            content = RestClient.responseBody(response);
        } else {
            content = null;
        }
        String requestContent = TopicRequestBody.topicRequestContent(request, 1024);
        if (requestContent != null || content != null) {
            message.append(':');
        }
        if (requestContent != null) {
            message.append("\n    ").append(requestContent);
        }
        if (content != null) {
            message.append("\n    ").append(content);
        }
        return new UncheckedRequestException(message.toString(), cause);
    }
}

