/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.topic;

import java.util.regex.Pattern;

public class KafkaTopic
implements Comparable<KafkaTopic> {
    private final String name;
    private static final Pattern TOPIC_NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public KafkaTopic(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Kafka topic name may not be null");
        }
        if (!TOPIC_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Kafka topic " + name + " is not ASCII-alphanumeric with possible underscores.");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTopic topic = (KafkaTopic)o;
        return this.name.equals(topic.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.name + ">";
    }

    @Override
    public int compareTo(KafkaTopic o) {
        return this.name.compareTo(o.name);
    }
}

