/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.OkHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtils {
    private static final Logger logger;
    public static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER;
    public static final HostnameVerifier UNSAFE_HOSTNAME_VERIFIER;
    public static final TrustManager[] UNSAFE_TRUST_MANAGER;
    public static final SSLSocketFactory UNSAFE_SSL_FACTORY;

    private RestUtils() {
    }

    public static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("No System TLS", e);
        }
    }

    public static SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager trustManager) {
        try {
            SSLContext sslContext = Platform.get().newSSLContext();
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("No System TLS", e);
        }
    }

    static {
        SSLSocketFactory factory;
        logger = LoggerFactory.getLogger(RestUtils.class);
        DEFAULT_HOSTNAME_VERIFIER = OkHostnameVerifier.INSTANCE;
        UNSAFE_HOSTNAME_VERIFIER = (hostname, session) -> true;
        UNSAFE_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, UNSAFE_TRUST_MANAGER, new SecureRandom());
            factory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Failed to initialize unsafe SSL factory", (Throwable)e);
            factory = null;
        }
        UNSAFE_SSL_FACTORY = factory;
    }
}

