/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Serialization {
    private Serialization() {
    }

    public static long bytesToLong(byte[] b, int startIndex) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i + startIndex] & 0xFF);
        }
        return result;
    }

    public static void longToBytes(long value, byte[] b, int startIndex) {
        b[startIndex] = (byte)(value >> 56 & 0xFFL);
        b[startIndex + 1] = (byte)(value >> 48 & 0xFFL);
        b[startIndex + 2] = (byte)(value >> 40 & 0xFFL);
        b[startIndex + 3] = (byte)(value >> 32 & 0xFFL);
        b[startIndex + 4] = (byte)(value >> 24 & 0xFFL);
        b[startIndex + 5] = (byte)(value >> 16 & 0xFFL);
        b[startIndex + 6] = (byte)(value >> 8 & 0xFFL);
        b[startIndex + 7] = (byte)(value & 0xFFL);
    }

    public static void intToBytes(int value, byte[] b, int startIndex) {
        b[startIndex] = (byte)(value >> 24 & 0xFF);
        b[startIndex + 1] = (byte)(value >> 16 & 0xFF);
        b[startIndex + 2] = (byte)(value >> 8 & 0xFF);
        b[startIndex + 3] = (byte)(value & 0xFF);
    }

    public static int bytesToInt(byte[] b, int startIndex) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= b[i + startIndex] & 0xFF;
        }
        return result;
    }

    public static short bytesToShort(byte[] b, int startIndex) {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | b[i + startIndex] & 0xFF);
        }
        return result;
    }

    public static byte booleanToByte(Boolean b) {
        if (b == null) {
            return -1;
        }
        if (b.equals(Boolean.TRUE)) {
            return 1;
        }
        return 0;
    }

    public static Boolean byteToBoolean(byte b) {
        if (b == -1) {
            return null;
        }
        if (b == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static double floatToDouble(float value) {
        return Double.parseDouble(Float.toString(value));
    }

    public static void copyStream(byte[] buffer, InputStream in, OutputStream out) throws IOException {
        if (buffer.length == 0) {
            throw new IllegalArgumentException("Cannot copy with empty buffer.");
        }
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }
}

