/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import org.radarbase.util.TimedVariable;

public class TimedInt
implements TimedVariable {
    public final int value;
    private final long expiry;

    public TimedInt(int value, long validity) {
        this.expiry = System.currentTimeMillis() + validity * 1000L;
        this.value = value;
    }

    @Override
    public boolean isExpired() {
        return this.expiry < System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedInt other = (TimedInt)o;
        return this.value == other.value && this.expiry == other.expiry;
    }

    public int hashCode() {
        return this.value;
    }
}

