/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.radarbase.data.AvroEncoder;
import org.radarbase.producer.rest.ParsedSchemaMetadata;

public class StringEncoder
implements AvroEncoder,
AvroEncoder.AvroWriter<String> {
    private static final ObjectWriter JSON_ENCODER = new ObjectMapper().writer();
    private ParsedSchemaMetadata readerSchema;

    @Override
    public <T> AvroEncoder.AvroWriter<T> writer(Schema schema, Class<? extends T> clazz) {
        if (schema.getType() != Schema.Type.STRING || !clazz.equals(String.class)) {
            throw new IllegalArgumentException("Cannot encode String with a different type than STRING.");
        }
        return this;
    }

    @Override
    public byte[] encode(String object) throws IOException {
        return JSON_ENCODER.writeValueAsBytes((Object)object);
    }

    @Override
    public void setReaderSchema(ParsedSchemaMetadata readerSchema) throws SchemaValidationException {
        if (readerSchema.getSchema().getType() != Schema.Type.STRING) {
            throw new SchemaValidationException(Schema.create((Schema.Type)Schema.Type.STRING), readerSchema.getSchema(), (Throwable)new IllegalArgumentException("Cannot convert type to STRING"));
        }
        this.readerSchema = readerSchema;
    }

    @Override
    public ParsedSchemaMetadata getReaderSchema() {
        return this.readerSchema;
    }
}

