/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.radarbase.data.AvroEncoder;
import org.radarbase.data.RecordData;
import org.radarbase.data.RemoteSchemaEncoder;
import org.radarbase.producer.rest.ParsedSchemaMetadata;
import org.radarbase.producer.rest.RecordRequest;
import org.radarbase.topic.AvroTopic;
import org.radarbase.util.Strings;

public class BinaryRecordRequest<K, V>
implements RecordRequest<K, V> {
    private int keyVersion;
    private int valueVersion;
    private RecordData<K, V> records;
    private BinaryEncoder binaryEncoder;
    private final AvroEncoder.AvroWriter<V> valueEncoder;
    private final int sourceIdPos;

    public BinaryRecordRequest(AvroTopic<K, V> topic) throws SchemaValidationException {
        if (topic.getKeySchema() == null || topic.getKeySchema().getType() != Schema.Type.RECORD) {
            Schema keySchema = topic.getKeySchema();
            if (keySchema == null) {
                keySchema = Schema.create((Schema.Type)Schema.Type.NULL);
            }
            throw new SchemaValidationException(keySchema, keySchema, (Throwable)new IllegalArgumentException("Cannot use non-record key schema"));
        }
        Schema.Field sourceIdField = topic.getKeySchema().getField("sourceId");
        if (sourceIdField == null) {
            throw new SchemaValidationException(topic.getKeySchema(), topic.getKeySchema(), (Throwable)new IllegalArgumentException("Cannot use binary encoder without a source ID."));
        }
        this.sourceIdPos = sourceIdField.pos();
        this.valueEncoder = new RemoteSchemaEncoder(true).writer(topic.getValueSchema(), topic.getValueClass());
    }

    @Override
    public void writeToSink(BufferedSink sink) throws IOException {
        this.writeToSink(sink, Integer.MAX_VALUE);
    }

    private void writeToSink(BufferedSink sink, int maxLength) throws IOException {
        this.binaryEncoder = EncoderFactory.get().directBinaryEncoder(sink.outputStream(), this.binaryEncoder);
        this.binaryEncoder.startItem();
        this.binaryEncoder.writeInt(this.keyVersion);
        this.binaryEncoder.writeInt(this.valueVersion);
        this.binaryEncoder.writeIndex(0);
        this.binaryEncoder.writeIndex(0);
        String sourceId = ((IndexedRecord)this.records.getKey()).get(this.sourceIdPos).toString();
        this.binaryEncoder.writeString(sourceId);
        this.binaryEncoder.writeArrayStart();
        this.binaryEncoder.setItemCount((long)this.records.size());
        int curLength = 18 + sourceId.length();
        for (Object record : this.records) {
            if (curLength >= maxLength) {
                return;
            }
            this.binaryEncoder.startItem();
            byte[] valueBytes = this.valueEncoder.encode(record);
            this.binaryEncoder.writeBytes(valueBytes);
            curLength += 4 + valueBytes.length;
        }
        this.binaryEncoder.writeArrayEnd();
        this.binaryEncoder.flush();
    }

    @Override
    public void reset() {
        this.records = null;
    }

    @Override
    public void prepare(ParsedSchemaMetadata keySchema, ParsedSchemaMetadata valueSchema, RecordData<K, V> records) throws SchemaValidationException {
        this.keyVersion = keySchema.getVersion() == null ? 0 : keySchema.getVersion();
        this.valueVersion = valueSchema.getVersion() == null ? 0 : valueSchema.getVersion();
        this.valueEncoder.setReaderSchema(valueSchema);
        this.records = records;
    }

    @Override
    public String content(int maxLength) throws IOException {
        try (Buffer buffer = new Buffer();){
            this.writeToSink((BufferedSink)buffer, maxLength / 2 - 2);
            String string = "0x" + Strings.bytesToHex(buffer.readByteArray(Math.min(buffer.size(), (long)(maxLength - 2))));
            return string;
        }
    }
}

