/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.util.concurrent.TimeUnit;

public final class ConnectionState {
    private long timeout;
    private long lastConnection = -1L;
    private State state = State.UNKNOWN;

    public ConnectionState(long timeout, TimeUnit unit) {
        this.setTimeout(timeout, unit);
    }

    public synchronized State getState() {
        if (this.state == State.CONNECTED && System.currentTimeMillis() - this.lastConnection >= this.timeout) {
            this.state = State.UNKNOWN;
        }
        return this.state;
    }

    public synchronized void didConnect() {
        this.state = State.CONNECTED;
        this.lastConnection = System.currentTimeMillis();
    }

    public synchronized void didDisconnect() {
        this.state = State.DISCONNECTED;
    }

    public synchronized void wasUnauthorized() {
        this.state = State.UNAUTHORIZED;
    }

    public synchronized void reset() {
        this.state = State.UNKNOWN;
    }

    public synchronized void setTimeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be strictly positive");
        }
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        UNKNOWN,
        UNAUTHORIZED;

    }
}

