/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.producer.rest;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.radarbase.config.ServerConfig;
import org.radarbase.producer.rest.GzipRequestInterceptor;
import org.radarbase.producer.rest.RestException;
import org.radarbase.util.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    public static final long DEFAULT_TIMEOUT = 30L;
    private static WeakReference<OkHttpClient> globalHttpClient = new WeakReference<Object>(null);
    private final ServerConfig server;
    private final OkHttpClient httpClient;
    private final Headers headers;

    private RestClient(Builder builder) {
        this.server = Objects.requireNonNull(builder.serverConfig);
        this.httpClient = builder.client.build();
        this.headers = builder.requestHeaders;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public long getTimeout() {
        return this.httpClient.connectTimeoutMillis() / 1000;
    }

    public ServerConfig getServer() {
        return this.server;
    }

    public Response request(Request request) throws IOException {
        Objects.requireNonNull(request);
        return this.httpClient.newCall(request).execute();
    }

    public void request(Request request, Callback callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(callback);
        this.httpClient.newCall(request).enqueue(callback);
    }

    public Response request(String relativePath) throws IOException {
        return this.request(this.requestBuilder(relativePath).build());
    }

    public String requestString(Request request) throws IOException {
        try (Response response = this.request(request);){
            String bodyString = RestClient.responseBody(response);
            if (!response.isSuccessful() || bodyString == null) {
                throw new RestException(response.code(), bodyString);
            }
            String string = bodyString;
            return string;
        }
    }

    public Request.Builder requestBuilder(String relativePath) throws MalformedURLException {
        return new Request.Builder().url(this.getRelativeUrl(relativePath)).headers(this.headers);
    }

    public HttpUrl getRelativeUrl(String path) throws MalformedURLException {
        String strippedPath = path;
        while (!strippedPath.isEmpty() && strippedPath.charAt(0) == '/') {
            strippedPath = strippedPath.substring(1);
        }
        HttpUrl.Builder builder = this.getServer().getHttpUrl().newBuilder(strippedPath);
        if (builder == null) {
            throw new MalformedURLException();
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClient that = (RestClient)o;
        return this.server.equals(that.server) && this.httpClient.equals(that.httpClient);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.httpClient);
    }

    public String toString() {
        return "RestClient{serverConfig=" + this.server + ", httpClient=" + this.httpClient + "}";
    }

    public static String responseBody(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            if (body == null) {
                String string = null;
                return string;
            }
            String string = body.string();
            return string;
        }
    }

    public Builder newBuilder() {
        return new Builder(this.httpClient).server(this.server);
    }

    public static synchronized Builder global() {
        OkHttpClient client = (OkHttpClient)globalHttpClient.get();
        if (client == null) {
            client = RestClient.createDefaultClient().build();
            globalHttpClient = new WeakReference<OkHttpClient>(client);
        }
        return new Builder(client);
    }

    public static synchronized Builder newClient() {
        return new Builder(RestClient.createDefaultClient());
    }

    private static OkHttpClient.Builder createDefaultClient() {
        return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS);
    }

    public static class Builder {
        private ServerConfig serverConfig;
        private final OkHttpClient.Builder client;
        private Headers requestHeaders = Headers.of((String[])new String[0]);

        public Builder(OkHttpClient client) {
            this(client.newBuilder());
        }

        public Builder(OkHttpClient.Builder client) {
            this.client = client;
        }

        public Builder server(ServerConfig config) {
            this.serverConfig = Objects.requireNonNull(config);
            if (config.isUnsafe()) {
                this.client.sslSocketFactory(RestUtils.UNSAFE_SSL_FACTORY, (X509TrustManager)RestUtils.UNSAFE_TRUST_MANAGER[0]);
                this.client.hostnameVerifier(RestUtils.UNSAFE_HOSTNAME_VERIFIER);
            } else {
                X509TrustManager trustManager = RestUtils.systemDefaultTrustManager();
                SSLSocketFactory socketFactory = RestUtils.systemDefaultSslSocketFactory(trustManager);
                this.client.sslSocketFactory(socketFactory, trustManager);
                this.client.hostnameVerifier(RestUtils.DEFAULT_HOSTNAME_VERIFIER);
            }
            return this;
        }

        public Builder protocols(List<Protocol> protocols) {
            this.client.protocols(protocols);
            return this;
        }

        public OkHttpClient.Builder httpClientBuilder() {
            return this.client;
        }

        public Builder headers(Headers headers) {
            this.requestHeaders = headers;
            return this;
        }

        public Builder gzipCompression(boolean compression) {
            GzipRequestInterceptor gzip = null;
            for (Interceptor interceptor : this.client.interceptors()) {
                if (!(interceptor instanceof GzipRequestInterceptor)) continue;
                gzip = (GzipRequestInterceptor)interceptor;
                break;
            }
            if (compression && gzip == null) {
                logger.debug("Enabling GZIP compression");
                this.client.addInterceptor((Interceptor)new GzipRequestInterceptor());
            } else if (!compression && gzip != null) {
                logger.debug("Disabling GZIP compression");
                this.client.interceptors().remove(gzip);
            }
            return this;
        }

        public Builder timeout(long timeout, TimeUnit unit) {
            this.client.connectTimeout(timeout, unit).readTimeout(timeout, unit).writeTimeout(timeout, unit);
            return this;
        }

        public RestClient build() {
            return new RestClient(this);
        }
    }
}

