/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.topic;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.radarbase.topic.KafkaTopic;

public class AvroTopic<K, V>
extends KafkaTopic {
    private final Schema valueSchema;
    private final Schema keySchema;
    private final Schema.Type[] valueFieldTypes;
    private final Class<? extends V> valueClass;
    private final Class<? extends K> keyClass;

    public AvroTopic(String name, Schema keySchema, Schema valueSchema, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        super(name);
        if (keySchema == null || valueSchema == null || keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Topic values may not be null");
        }
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.valueClass = valueClass;
        this.keyClass = keyClass;
        if (valueSchema.getType() == Schema.Type.RECORD) {
            List fields = valueSchema.getFields();
            this.valueFieldTypes = new Schema.Type[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                this.valueFieldTypes[i] = ((Schema.Field)fields.get(i)).schema().getType();
            }
        } else {
            this.valueFieldTypes = null;
        }
    }

    public Schema getKeySchema() {
        return this.keySchema;
    }

    public Schema getValueSchema() {
        return this.valueSchema;
    }

    public Class<? extends K> getKeyClass() {
        return this.keyClass;
    }

    public Class<? extends V> getValueClass() {
        return this.valueClass;
    }

    public V newValueInstance() throws ClassCastException {
        return (V)SpecificData.newInstance(this.valueClass, (Schema)this.valueSchema);
    }

    public Schema.Type[] getValueFieldTypes() {
        return Arrays.copyOf(this.valueFieldTypes, this.valueFieldTypes.length);
    }

    public static <K extends SpecificRecord, V extends SpecificRecord> AvroTopic<K, V> parse(String topic, String keySchema, String valueSchema) {
        Objects.requireNonNull(topic, "topic needs to be specified");
        K key = AvroTopic.parseSpecificRecord(keySchema);
        K value = AvroTopic.parseSpecificRecord(valueSchema);
        return new AvroTopic(topic, key.getSchema(), value.getSchema(), key.getClass(), value.getClass());
    }

    public static <K extends SpecificRecord> K parseSpecificRecord(String schemaClass) {
        try {
            Objects.requireNonNull(schemaClass, "schema needs to be specified");
            Class<?> keyClass = Class.forName(schemaClass);
            Schema keyAvroSchema = (Schema)keyClass.getMethod("getClassSchema", new Class[0]).invoke(null, new Object[0]);
            return (K)((SpecificRecord)SpecificData.newInstance(keyClass, (Schema)keyAvroSchema));
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Schema " + schemaClass + " cannot be instantiated", ex);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvroTopic topic = (AvroTopic)o;
        return this.keyClass == topic.getKeyClass() && this.valueClass == topic.getValueClass();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.keyClass, this.valueClass);
    }
}

