/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.nio.charset.StandardCharsets;

public class Base64 {
    private Base64() {
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static class Encoder {
        private static final byte[] BASE_64_CHAR = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        static final Encoder RFC4648 = new Encoder();

        private Encoder() {
        }

        public String encode(byte[] src) {
            int srcP;
            int srcLen = src.length;
            byte[] dst = new byte[4 * ((srcLen + 2) / 3)];
            int fullDataLen = srcLen / 3 * 3;
            int dstP = 0;
            for (srcP = 0; srcP < fullDataLen; srcP += 3) {
                int bits = (src[srcP] & 0xFF) << 16 | (src[srcP + 1] & 0xFF) << 8 | src[srcP + 2] & 0xFF;
                dst[dstP++] = BASE_64_CHAR[bits >>> 18 & 0x3F];
                dst[dstP++] = BASE_64_CHAR[bits >>> 12 & 0x3F];
                dst[dstP++] = BASE_64_CHAR[bits >>> 6 & 0x3F];
                dst[dstP++] = BASE_64_CHAR[bits & 0x3F];
            }
            if (srcP < srcLen) {
                int b0 = src[srcP++] & 0xFF;
                dst[dstP++] = BASE_64_CHAR[b0 >> 2];
                if (srcP == srcLen) {
                    dst[dstP++] = BASE_64_CHAR[b0 << 4 & 0x3F];
                    dst[dstP++] = 61;
                } else {
                    int b1 = src[srcP] & 0xFF;
                    dst[dstP++] = BASE_64_CHAR[b0 << 4 & 0x3F | b1 >> 4];
                    dst[dstP++] = BASE_64_CHAR[b1 << 2 & 0x3F];
                }
                dst[dstP] = 61;
            }
            return new String(dst, StandardCharsets.UTF_8);
        }
    }
}

