/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.util;

import java.util.Objects;
import org.radarbase.util.TimedVariable;

public class TimedValue<T>
implements TimedVariable {
    public final T value;
    private final long expiry;

    public TimedValue(T value, long validity) {
        this.expiry = System.currentTimeMillis() + validity * 1000L;
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public boolean isExpired() {
        return this.expiry < System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedValue other = (TimedValue)o;
        return this.value.equals(other.value) && this.expiry == other.expiry;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

