/*
 * Decompiled with CFR 0.152.
 */
package org.radarbase.jersey.hibernate;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.sql.Connection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.jersey.hibernate.RadarEntityManagerFactory;
import org.radarbase.jersey.hibernate.RadarEntityManagerFactoryFactory;
import org.radarbase.jersey.hibernate.config.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/radarbase/jersey/hibernate/DatabaseInitialization;", "Lorg/glassfish/jersey/server/monitoring/ApplicationEventListener;", "entityManagerFactory", "Ljakarta/inject/Provider;", "Ljavax/persistence/EntityManagerFactory;", "dbConfig", "Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;", "(Ljakarta/inject/Provider;Lorg/radarbase/jersey/hibernate/config/DatabaseConfig;)V", "initializeLiquibase", "", "connection", "Ljava/sql/Connection;", "onEvent", "event", "Lorg/glassfish/jersey/server/monitoring/ApplicationEvent;", "onRequest", "Lorg/glassfish/jersey/server/monitoring/RequestEventListener;", "requestEvent", "Lorg/glassfish/jersey/server/monitoring/RequestEvent;", "Companion", "radar-jersey-hibernate"})
public final class DatabaseInitialization
implements ApplicationEventListener {
    private final jakarta.inject.Provider<EntityManagerFactory> entityManagerFactory;
    private final DatabaseConfig dbConfig;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@NotNull ApplicationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getType() != ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            return;
        }
        try {
            Object object = this.entityManagerFactory.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityManagerFactory.get()");
            EntityManagerFactory $this$useEntityManager$iv = (EntityManagerFactory)object;
            RadarEntityManagerFactoryFactory.Companion companion = RadarEntityManagerFactoryFactory.Companion;
            boolean $i$f$useEntityManager = false;
            try (EntityManager entityManager$iv = $this$useEntityManager$iv.createEntityManager();){
                EntityManager entityManager = entityManager$iv;
                Intrinsics.checkNotNullExpressionValue((Object)entityManager, (String)"entityManager");
                EntityManager it = entityManager;
                boolean bl = false;
                AutoCloseable autoCloseable = RadarEntityManagerFactory.Companion.connection(it);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Connection connection = (Connection)autoCloseable;
                    boolean bl4 = false;
                    if (this.dbConfig.getLiquibase().getEnable()) {
                        Connection connection2 = connection;
                        Intrinsics.checkNotNullExpressionValue((Object)connection2, (String)"connection");
                        this.initializeLiquibase(connection2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Throwable ex) {
            throw (Throwable)new IllegalStateException("Cannot initialize database.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initializeLiquibase(Connection connection) {
        logger.info("Initializing Liquibase");
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        AutoCloseable autoCloseable = (AutoCloseable)new Liquibase(this.dbConfig.getLiquibase().getChangelogs(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Liquibase it = (Liquibase)autoCloseable;
            boolean bl3 = false;
            it.update((Contexts)null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Nullable
    public RequestEventListener onRequest(@Nullable RequestEvent requestEvent) {
        return null;
    }

    public DatabaseInitialization(@Context @NotNull jakarta.inject.Provider<EntityManagerFactory> entityManagerFactory, @Context @NotNull DatabaseConfig dbConfig) {
        Intrinsics.checkNotNullParameter(entityManagerFactory, (String)"entityManagerFactory");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        this.entityManagerFactory = entityManagerFactory;
        this.dbConfig = dbConfig;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DatabaseInitialization.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/radarbase/jersey/hibernate/DatabaseInitialization$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-jersey-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

