/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.upload.oxford;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.upload.oxford.OxfordCameraAxes;
import org.radarcns.connector.upload.oxford.OxfordCameraRgb;

@AvroGenerated
public class OxfordCameraData
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7897983176288365175L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OxfordCameraData\",\"namespace\":\"org.radarcns.connector.upload.oxford\",\"doc\":\"Entry for an image captured by Oxford's wearable camera.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time since Unix Epoch as reported by the device (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time this record was processed (s).\"},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Image name.\"},{\"name\":\"infraredProximity\",\"type\":\"boolean\",\"doc\":\"True if a the infrared sensor detected an warm object (e.g. part of a human body) closeby when the image was captured.\"},{\"name\":\"acceleration\",\"type\":{\"type\":\"record\",\"name\":\"OxfordCameraAxes\",\"doc\":\"Three-axes reference system.\",\"fields\":[{\"name\":\"x\",\"type\":\"float\",\"doc\":\"X coordinate value.\"},{\"name\":\"y\",\"type\":\"float\",\"doc\":\"Y coordinate value.\"},{\"name\":\"z\",\"type\":\"float\",\"doc\":\"Z coordinate value.\"}]},\"doc\":\"Acceleration of the camera when the image was captured (g).\"},{\"name\":\"magneticField\",\"type\":\"OxfordCameraAxes\",\"doc\":\"Magnetic field of the camera when the image was captured (100 \u00b5T).\"},{\"name\":\"orientation\",\"type\":\"OxfordCameraAxes\",\"doc\":\"Orientation of the camera when the image was captured (unknown unit, unknown interpretation).\"},{\"name\":\"temperature\",\"type\":\"float\",\"doc\":\"Ambient temperature when the image was recorded (celcius).\"},{\"name\":\"colorMean\",\"type\":{\"type\":\"record\",\"name\":\"OxfordCameraRgb\",\"doc\":\"Color in sRGB color space.\",\"fields\":[{\"name\":\"red\",\"type\":\"float\",\"doc\":\"Red value.\"},{\"name\":\"green\",\"type\":\"float\",\"doc\":\"Green value.\"},{\"name\":\"blue\",\"type\":\"float\",\"doc\":\"Blue value.\"}]},\"doc\":\"Mean color saturation over all pixels of the image in the sRGB color space (range 0-1).\"},{\"name\":\"luminanceMean\",\"type\":\"float\",\"doc\":\"Mean luminance over all pixels of the image (0 - 1). Calculation unknown but assumed to match sum of RGB values.\"},{\"name\":\"exposure\",\"type\":\"int\",\"doc\":\"Physical exposure of the captured image (unknown unit, unknown range).\"},{\"name\":\"gain\",\"type\":\"float\",\"doc\":\"Gain applied to raw photo sensor values. Amplification factor of the signal (unknown range).\"},{\"name\":\"colorBalance\",\"type\":\"OxfordCameraRgb\",\"doc\":\"Relative distribution of gain applied in the captured image (uncertain interpretation).\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OxfordCameraData> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OxfordCameraData> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String name;
    @Deprecated
    public boolean infraredProximity;
    @Deprecated
    public OxfordCameraAxes acceleration;
    @Deprecated
    public OxfordCameraAxes magneticField;
    @Deprecated
    public OxfordCameraAxes orientation;
    @Deprecated
    public float temperature;
    @Deprecated
    public OxfordCameraRgb colorMean;
    @Deprecated
    public float luminanceMean;
    @Deprecated
    public int exposure;
    @Deprecated
    public float gain;
    @Deprecated
    public OxfordCameraRgb colorBalance;
    private static final DatumWriter<OxfordCameraData> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OxfordCameraData> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OxfordCameraData> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OxfordCameraData> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OxfordCameraData> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OxfordCameraData fromByteBuffer(ByteBuffer b) throws IOException {
        return (OxfordCameraData)((Object)DECODER.decode(b));
    }

    public OxfordCameraData() {
    }

    public OxfordCameraData(Double time, Double timeReceived, String name, Boolean infraredProximity, OxfordCameraAxes acceleration, OxfordCameraAxes magneticField, OxfordCameraAxes orientation, Float temperature, OxfordCameraRgb colorMean, Float luminanceMean, Integer exposure, Float gain, OxfordCameraRgb colorBalance) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.name = name;
        this.infraredProximity = infraredProximity;
        this.acceleration = acceleration;
        this.magneticField = magneticField;
        this.orientation = orientation;
        this.temperature = temperature.floatValue();
        this.colorMean = colorMean;
        this.luminanceMean = luminanceMean.floatValue();
        this.exposure = exposure;
        this.gain = gain.floatValue();
        this.colorBalance = colorBalance;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.infraredProximity;
            }
            case 4: {
                return this.acceleration;
            }
            case 5: {
                return this.magneticField;
            }
            case 6: {
                return this.orientation;
            }
            case 7: {
                return Float.valueOf(this.temperature);
            }
            case 8: {
                return this.colorMean;
            }
            case 9: {
                return Float.valueOf(this.luminanceMean);
            }
            case 10: {
                return this.exposure;
            }
            case 11: {
                return Float.valueOf(this.gain);
            }
            case 12: {
                return this.colorBalance;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.infraredProximity = (Boolean)value$;
                break;
            }
            case 4: {
                this.acceleration = (OxfordCameraAxes)((Object)value$);
                break;
            }
            case 5: {
                this.magneticField = (OxfordCameraAxes)((Object)value$);
                break;
            }
            case 6: {
                this.orientation = (OxfordCameraAxes)((Object)value$);
                break;
            }
            case 7: {
                this.temperature = ((Float)value$).floatValue();
                break;
            }
            case 8: {
                this.colorMean = (OxfordCameraRgb)((Object)value$);
                break;
            }
            case 9: {
                this.luminanceMean = ((Float)value$).floatValue();
                break;
            }
            case 10: {
                this.exposure = (Integer)value$;
                break;
            }
            case 11: {
                this.gain = ((Float)value$).floatValue();
                break;
            }
            case 12: {
                this.colorBalance = (OxfordCameraRgb)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean getInfraredProximity() {
        return this.infraredProximity;
    }

    public void setInfraredProximity(boolean value) {
        this.infraredProximity = value;
    }

    public OxfordCameraAxes getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(OxfordCameraAxes value) {
        this.acceleration = value;
    }

    public OxfordCameraAxes getMagneticField() {
        return this.magneticField;
    }

    public void setMagneticField(OxfordCameraAxes value) {
        this.magneticField = value;
    }

    public OxfordCameraAxes getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OxfordCameraAxes value) {
        this.orientation = value;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float value) {
        this.temperature = value;
    }

    public OxfordCameraRgb getColorMean() {
        return this.colorMean;
    }

    public void setColorMean(OxfordCameraRgb value) {
        this.colorMean = value;
    }

    public float getLuminanceMean() {
        return this.luminanceMean;
    }

    public void setLuminanceMean(float value) {
        this.luminanceMean = value;
    }

    public int getExposure() {
        return this.exposure;
    }

    public void setExposure(int value) {
        this.exposure = value;
    }

    public float getGain() {
        return this.gain;
    }

    public void setGain(float value) {
        this.gain = value;
    }

    public OxfordCameraRgb getColorBalance() {
        return this.colorBalance;
    }

    public void setColorBalance(OxfordCameraRgb value) {
        this.colorBalance = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OxfordCameraData other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.name);
        out.writeBoolean(this.infraredProximity);
        this.acceleration.customEncode(out);
        this.magneticField.customEncode(out);
        this.orientation.customEncode(out);
        out.writeFloat(this.temperature);
        this.colorMean.customEncode(out);
        out.writeFloat(this.luminanceMean);
        out.writeInt(this.exposure);
        out.writeFloat(this.gain);
        this.colorBalance.customEncode(out);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.name = in.readString();
            this.infraredProximity = in.readBoolean();
            if (this.acceleration == null) {
                this.acceleration = new OxfordCameraAxes();
            }
            this.acceleration.customDecode(in);
            if (this.magneticField == null) {
                this.magneticField = new OxfordCameraAxes();
            }
            this.magneticField.customDecode(in);
            if (this.orientation == null) {
                this.orientation = new OxfordCameraAxes();
            }
            this.orientation.customDecode(in);
            this.temperature = in.readFloat();
            if (this.colorMean == null) {
                this.colorMean = new OxfordCameraRgb();
            }
            this.colorMean.customDecode(in);
            this.luminanceMean = in.readFloat();
            this.exposure = in.readInt();
            this.gain = in.readFloat();
            if (this.colorBalance == null) {
                this.colorBalance = new OxfordCameraRgb();
            }
            this.colorBalance.customDecode(in);
        } else {
            block15: for (int i = 0; i < 13; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block15;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block15;
                    }
                    case 2: {
                        this.name = in.readString();
                        continue block15;
                    }
                    case 3: {
                        this.infraredProximity = in.readBoolean();
                        continue block15;
                    }
                    case 4: {
                        if (this.acceleration == null) {
                            this.acceleration = new OxfordCameraAxes();
                        }
                        this.acceleration.customDecode(in);
                        continue block15;
                    }
                    case 5: {
                        if (this.magneticField == null) {
                            this.magneticField = new OxfordCameraAxes();
                        }
                        this.magneticField.customDecode(in);
                        continue block15;
                    }
                    case 6: {
                        if (this.orientation == null) {
                            this.orientation = new OxfordCameraAxes();
                        }
                        this.orientation.customDecode(in);
                        continue block15;
                    }
                    case 7: {
                        this.temperature = in.readFloat();
                        continue block15;
                    }
                    case 8: {
                        if (this.colorMean == null) {
                            this.colorMean = new OxfordCameraRgb();
                        }
                        this.colorMean.customDecode(in);
                        continue block15;
                    }
                    case 9: {
                        this.luminanceMean = in.readFloat();
                        continue block15;
                    }
                    case 10: {
                        this.exposure = in.readInt();
                        continue block15;
                    }
                    case 11: {
                        this.gain = in.readFloat();
                        continue block15;
                    }
                    case 12: {
                        if (this.colorBalance == null) {
                            this.colorBalance = new OxfordCameraRgb();
                        }
                        this.colorBalance.customDecode(in);
                        continue block15;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OxfordCameraData>
    implements RecordBuilder<OxfordCameraData> {
        private double time;
        private double timeReceived;
        private String name;
        private boolean infraredProximity;
        private OxfordCameraAxes acceleration;
        private OxfordCameraAxes.Builder accelerationBuilder;
        private OxfordCameraAxes magneticField;
        private OxfordCameraAxes.Builder magneticFieldBuilder;
        private OxfordCameraAxes orientation;
        private OxfordCameraAxes.Builder orientationBuilder;
        private float temperature;
        private OxfordCameraRgb colorMean;
        private OxfordCameraRgb.Builder colorMeanBuilder;
        private float luminanceMean;
        private int exposure;
        private float gain;
        private OxfordCameraRgb colorBalance;
        private OxfordCameraRgb.Builder colorBalanceBuilder;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.infraredProximity)) {
                this.infraredProximity = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.infraredProximity);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.acceleration))) {
                this.acceleration = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.acceleration));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (other.hasAccelerationBuilder()) {
                this.accelerationBuilder = OxfordCameraAxes.newBuilder(other.getAccelerationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.magneticField))) {
                this.magneticField = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.magneticField));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (other.hasMagneticFieldBuilder()) {
                this.magneticFieldBuilder = OxfordCameraAxes.newBuilder(other.getMagneticFieldBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.orientation))) {
                this.orientation = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.orientation));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (other.hasOrientationBuilder()) {
                this.orientationBuilder = OxfordCameraAxes.newBuilder(other.getOrientationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)Float.valueOf(other.temperature))) {
                this.temperature = ((Float)this.data().deepCopy(this.fields()[7].schema(), (Object)Float.valueOf(other.temperature))).floatValue();
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.colorMean))) {
                this.colorMean = (OxfordCameraRgb)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.colorMean));
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (other.hasColorMeanBuilder()) {
                this.colorMeanBuilder = OxfordCameraRgb.newBuilder(other.getColorMeanBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)Float.valueOf(other.luminanceMean))) {
                this.luminanceMean = ((Float)this.data().deepCopy(this.fields()[9].schema(), (Object)Float.valueOf(other.luminanceMean))).floatValue();
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.exposure)) {
                this.exposure = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.exposure);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)Float.valueOf(other.gain))) {
                this.gain = ((Float)this.data().deepCopy(this.fields()[11].schema(), (Object)Float.valueOf(other.gain))).floatValue();
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.colorBalance))) {
                this.colorBalance = (OxfordCameraRgb)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.colorBalance));
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (other.hasColorBalanceBuilder()) {
                this.colorBalanceBuilder = OxfordCameraRgb.newBuilder(other.getColorBalanceBuilder());
            }
        }

        private Builder(OxfordCameraData other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.infraredProximity)) {
                this.infraredProximity = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.infraredProximity);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.acceleration))) {
                this.acceleration = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.acceleration));
                this.fieldSetFlags()[4] = true;
            }
            this.accelerationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.magneticField))) {
                this.magneticField = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.magneticField));
                this.fieldSetFlags()[5] = true;
            }
            this.magneticFieldBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.orientation))) {
                this.orientation = (OxfordCameraAxes)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.orientation));
                this.fieldSetFlags()[6] = true;
            }
            this.orientationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)Float.valueOf(other.temperature))) {
                this.temperature = ((Float)this.data().deepCopy(this.fields()[7].schema(), (Object)Float.valueOf(other.temperature))).floatValue();
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.colorMean))) {
                this.colorMean = (OxfordCameraRgb)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.colorMean));
                this.fieldSetFlags()[8] = true;
            }
            this.colorMeanBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)Float.valueOf(other.luminanceMean))) {
                this.luminanceMean = ((Float)this.data().deepCopy(this.fields()[9].schema(), (Object)Float.valueOf(other.luminanceMean))).floatValue();
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.exposure)) {
                this.exposure = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.exposure);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)Float.valueOf(other.gain))) {
                this.gain = ((Float)this.data().deepCopy(this.fields()[11].schema(), (Object)Float.valueOf(other.gain))).floatValue();
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.colorBalance))) {
                this.colorBalance = (OxfordCameraRgb)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.colorBalance));
                this.fieldSetFlags()[12] = true;
            }
            this.colorBalanceBuilder = null;
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[2], value);
            this.name = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getInfraredProximity() {
            return this.infraredProximity;
        }

        public Builder setInfraredProximity(boolean value) {
            this.validate(this.fields()[3], value);
            this.infraredProximity = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasInfraredProximity() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearInfraredProximity() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public OxfordCameraAxes getAcceleration() {
            return this.acceleration;
        }

        public Builder setAcceleration(OxfordCameraAxes value) {
            this.validate(this.fields()[4], (Object)value);
            this.accelerationBuilder = null;
            this.acceleration = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAcceleration() {
            return this.fieldSetFlags()[4];
        }

        public OxfordCameraAxes.Builder getAccelerationBuilder() {
            if (this.accelerationBuilder == null) {
                if (this.hasAcceleration()) {
                    this.setAccelerationBuilder(OxfordCameraAxes.newBuilder(this.acceleration));
                } else {
                    this.setAccelerationBuilder(OxfordCameraAxes.newBuilder());
                }
            }
            return this.accelerationBuilder;
        }

        public Builder setAccelerationBuilder(OxfordCameraAxes.Builder value) {
            this.clearAcceleration();
            this.accelerationBuilder = value;
            return this;
        }

        public boolean hasAccelerationBuilder() {
            return this.accelerationBuilder != null;
        }

        public Builder clearAcceleration() {
            this.acceleration = null;
            this.accelerationBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public OxfordCameraAxes getMagneticField() {
            return this.magneticField;
        }

        public Builder setMagneticField(OxfordCameraAxes value) {
            this.validate(this.fields()[5], (Object)value);
            this.magneticFieldBuilder = null;
            this.magneticField = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMagneticField() {
            return this.fieldSetFlags()[5];
        }

        public OxfordCameraAxes.Builder getMagneticFieldBuilder() {
            if (this.magneticFieldBuilder == null) {
                if (this.hasMagneticField()) {
                    this.setMagneticFieldBuilder(OxfordCameraAxes.newBuilder(this.magneticField));
                } else {
                    this.setMagneticFieldBuilder(OxfordCameraAxes.newBuilder());
                }
            }
            return this.magneticFieldBuilder;
        }

        public Builder setMagneticFieldBuilder(OxfordCameraAxes.Builder value) {
            this.clearMagneticField();
            this.magneticFieldBuilder = value;
            return this;
        }

        public boolean hasMagneticFieldBuilder() {
            return this.magneticFieldBuilder != null;
        }

        public Builder clearMagneticField() {
            this.magneticField = null;
            this.magneticFieldBuilder = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public OxfordCameraAxes getOrientation() {
            return this.orientation;
        }

        public Builder setOrientation(OxfordCameraAxes value) {
            this.validate(this.fields()[6], (Object)value);
            this.orientationBuilder = null;
            this.orientation = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasOrientation() {
            return this.fieldSetFlags()[6];
        }

        public OxfordCameraAxes.Builder getOrientationBuilder() {
            if (this.orientationBuilder == null) {
                if (this.hasOrientation()) {
                    this.setOrientationBuilder(OxfordCameraAxes.newBuilder(this.orientation));
                } else {
                    this.setOrientationBuilder(OxfordCameraAxes.newBuilder());
                }
            }
            return this.orientationBuilder;
        }

        public Builder setOrientationBuilder(OxfordCameraAxes.Builder value) {
            this.clearOrientation();
            this.orientationBuilder = value;
            return this;
        }

        public boolean hasOrientationBuilder() {
            return this.orientationBuilder != null;
        }

        public Builder clearOrientation() {
            this.orientation = null;
            this.orientationBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public float getTemperature() {
            return this.temperature;
        }

        public Builder setTemperature(float value) {
            this.validate(this.fields()[7], Float.valueOf(value));
            this.temperature = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTemperature() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTemperature() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public OxfordCameraRgb getColorMean() {
            return this.colorMean;
        }

        public Builder setColorMean(OxfordCameraRgb value) {
            this.validate(this.fields()[8], (Object)value);
            this.colorMeanBuilder = null;
            this.colorMean = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasColorMean() {
            return this.fieldSetFlags()[8];
        }

        public OxfordCameraRgb.Builder getColorMeanBuilder() {
            if (this.colorMeanBuilder == null) {
                if (this.hasColorMean()) {
                    this.setColorMeanBuilder(OxfordCameraRgb.newBuilder(this.colorMean));
                } else {
                    this.setColorMeanBuilder(OxfordCameraRgb.newBuilder());
                }
            }
            return this.colorMeanBuilder;
        }

        public Builder setColorMeanBuilder(OxfordCameraRgb.Builder value) {
            this.clearColorMean();
            this.colorMeanBuilder = value;
            return this;
        }

        public boolean hasColorMeanBuilder() {
            return this.colorMeanBuilder != null;
        }

        public Builder clearColorMean() {
            this.colorMean = null;
            this.colorMeanBuilder = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public float getLuminanceMean() {
            return this.luminanceMean;
        }

        public Builder setLuminanceMean(float value) {
            this.validate(this.fields()[9], Float.valueOf(value));
            this.luminanceMean = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasLuminanceMean() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearLuminanceMean() {
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public int getExposure() {
            return this.exposure;
        }

        public Builder setExposure(int value) {
            this.validate(this.fields()[10], value);
            this.exposure = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasExposure() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearExposure() {
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public float getGain() {
            return this.gain;
        }

        public Builder setGain(float value) {
            this.validate(this.fields()[11], Float.valueOf(value));
            this.gain = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasGain() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearGain() {
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public OxfordCameraRgb getColorBalance() {
            return this.colorBalance;
        }

        public Builder setColorBalance(OxfordCameraRgb value) {
            this.validate(this.fields()[12], (Object)value);
            this.colorBalanceBuilder = null;
            this.colorBalance = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasColorBalance() {
            return this.fieldSetFlags()[12];
        }

        public OxfordCameraRgb.Builder getColorBalanceBuilder() {
            if (this.colorBalanceBuilder == null) {
                if (this.hasColorBalance()) {
                    this.setColorBalanceBuilder(OxfordCameraRgb.newBuilder(this.colorBalance));
                } else {
                    this.setColorBalanceBuilder(OxfordCameraRgb.newBuilder());
                }
            }
            return this.colorBalanceBuilder;
        }

        public Builder setColorBalanceBuilder(OxfordCameraRgb.Builder value) {
            this.clearColorBalance();
            this.colorBalanceBuilder = value;
            return this;
        }

        public boolean hasColorBalanceBuilder() {
            return this.colorBalanceBuilder != null;
        }

        public Builder clearColorBalance() {
            this.colorBalance = null;
            this.colorBalanceBuilder = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public OxfordCameraData build() {
            try {
                OxfordCameraData record = new OxfordCameraData();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.name = this.fieldSetFlags()[2] ? this.name : (String)this.defaultValue(this.fields()[2]);
                boolean bl = record.infraredProximity = this.fieldSetFlags()[3] ? this.infraredProximity : (Boolean)this.defaultValue(this.fields()[3]);
                if (this.accelerationBuilder != null) {
                    try {
                        record.acceleration = this.accelerationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("acceleration"));
                        throw e;
                    }
                } else {
                    OxfordCameraAxes oxfordCameraAxes = record.acceleration = this.fieldSetFlags()[4] ? this.acceleration : (OxfordCameraAxes)((Object)this.defaultValue(this.fields()[4]));
                }
                if (this.magneticFieldBuilder != null) {
                    try {
                        record.magneticField = this.magneticFieldBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("magneticField"));
                        throw e;
                    }
                } else {
                    OxfordCameraAxes oxfordCameraAxes = record.magneticField = this.fieldSetFlags()[5] ? this.magneticField : (OxfordCameraAxes)((Object)this.defaultValue(this.fields()[5]));
                }
                if (this.orientationBuilder != null) {
                    try {
                        record.orientation = this.orientationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("orientation"));
                        throw e;
                    }
                } else {
                    record.orientation = this.fieldSetFlags()[6] ? this.orientation : (OxfordCameraAxes)((Object)this.defaultValue(this.fields()[6]));
                }
                float f = record.temperature = this.fieldSetFlags()[7] ? this.temperature : ((Float)this.defaultValue(this.fields()[7])).floatValue();
                if (this.colorMeanBuilder != null) {
                    try {
                        record.colorMean = this.colorMeanBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("colorMean"));
                        throw e;
                    }
                } else {
                    record.colorMean = this.fieldSetFlags()[8] ? this.colorMean : (OxfordCameraRgb)((Object)this.defaultValue(this.fields()[8]));
                }
                record.luminanceMean = this.fieldSetFlags()[9] ? this.luminanceMean : ((Float)this.defaultValue(this.fields()[9])).floatValue();
                record.exposure = this.fieldSetFlags()[10] ? this.exposure : (Integer)this.defaultValue(this.fields()[10]);
                float f2 = record.gain = this.fieldSetFlags()[11] ? this.gain : ((Float)this.defaultValue(this.fields()[11])).floatValue();
                if (this.colorBalanceBuilder != null) {
                    try {
                        record.colorBalance = this.colorBalanceBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("colorBalance"));
                        throw e;
                    }
                } else {
                    record.colorBalance = this.fieldSetFlags()[12] ? this.colorBalance : (OxfordCameraRgb)((Object)this.defaultValue(this.fields()[12]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

