/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.monitor.questionnaire;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class QuestionnaireCompletionLog
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 554480947799351119L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"QuestionnaireCompletionLog\",\"namespace\":\"org.radarcns.monitor.questionnaire\",\"doc\":\"Schema for reporting the completion status of a questionnaire. This will help in calculating the compliance.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in UTC (s) when the questionnaire completion log is submitted.\"},{\"name\":\"timeNotification\",\"type\":[\"null\",\"double\"],\"doc\":\"Timestamp in UTC (s) when the notification to complete the questionnaire is sent.\",\"default\":null},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Questionnaire name.\"},{\"name\":\"completionPercentage\",\"type\":[\"null\",\"double\"],\"doc\":\"Percentage of the questionnaire completed. 0 for not at all complete and 100 for full completion. Null if no completion value possible.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<QuestionnaireCompletionLog> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<QuestionnaireCompletionLog> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public Double timeNotification;
    @Deprecated
    public String name;
    @Deprecated
    public Double completionPercentage;
    private static final DatumWriter<QuestionnaireCompletionLog> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<QuestionnaireCompletionLog> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<QuestionnaireCompletionLog> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<QuestionnaireCompletionLog> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<QuestionnaireCompletionLog> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static QuestionnaireCompletionLog fromByteBuffer(ByteBuffer b) throws IOException {
        return (QuestionnaireCompletionLog)((Object)DECODER.decode(b));
    }

    public QuestionnaireCompletionLog() {
    }

    public QuestionnaireCompletionLog(Double time, Double timeNotification, String name, Double completionPercentage) {
        this.time = time;
        this.timeNotification = timeNotification;
        this.name = name;
        this.completionPercentage = completionPercentage;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeNotification;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.completionPercentage;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeNotification = (Double)value$;
                break;
            }
            case 2: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.completionPercentage = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public Double getTimeNotification() {
        return this.timeNotification;
    }

    public void setTimeNotification(Double value) {
        this.timeNotification = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Double getCompletionPercentage() {
        return this.completionPercentage;
    }

    public void setCompletionPercentage(Double value) {
        this.completionPercentage = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(QuestionnaireCompletionLog other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        if (this.timeNotification == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.timeNotification.doubleValue());
        }
        out.writeString(this.name);
        if (this.completionPercentage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.completionPercentage.doubleValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.timeNotification = null;
            } else {
                this.timeNotification = in.readDouble();
            }
            this.name = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.completionPercentage = null;
            } else {
                this.completionPercentage = in.readDouble();
            }
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timeNotification = null;
                            continue block6;
                        }
                        this.timeNotification = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.name = in.readString();
                        continue block6;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.completionPercentage = null;
                            continue block6;
                        }
                        this.completionPercentage = in.readDouble();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<QuestionnaireCompletionLog>
    implements RecordBuilder<QuestionnaireCompletionLog> {
        private double time;
        private Double timeNotification;
        private String name;
        private Double completionPercentage;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeNotification)) {
                this.timeNotification = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeNotification);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.completionPercentage)) {
                this.completionPercentage = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.completionPercentage);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(QuestionnaireCompletionLog other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeNotification)) {
                this.timeNotification = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeNotification);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.completionPercentage)) {
                this.completionPercentage = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.completionPercentage);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Double getTimeNotification() {
            return this.timeNotification;
        }

        public Builder setTimeNotification(Double value) {
            this.validate(this.fields()[1], value);
            this.timeNotification = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeNotification() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeNotification() {
            this.timeNotification = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[2], value);
            this.name = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Double getCompletionPercentage() {
            return this.completionPercentage;
        }

        public Builder setCompletionPercentage(Double value) {
            this.validate(this.fields()[3], value);
            this.completionPercentage = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCompletionPercentage() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCompletionPercentage() {
            this.completionPercentage = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public QuestionnaireCompletionLog build() {
            try {
                QuestionnaireCompletionLog record = new QuestionnaireCompletionLog();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeNotification = this.fieldSetFlags()[1] ? this.timeNotification : (Double)this.defaultValue(this.fields()[1]);
                record.name = this.fieldSetFlags()[2] ? this.name : (String)this.defaultValue(this.fields()[2]);
                record.completionPercentage = this.fieldSetFlags()[3] ? this.completionPercentage : (Double)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

