/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.bittium;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class BittiumFarosEcg
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 458842333166210780L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BittiumFarosEcg\",\"namespace\":\"org.radarcns.passive.bittium\",\"doc\":\"Data from Bittium Faros' multi-channel electrocardiography electrodes. Not all Faros models possess the same number of channels, so the second and third channels are optional.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"ecgChannel1\",\"type\":\"float\",\"doc\":\"ECG signal from the first channel (\u00b5V).\"},{\"name\":\"ecgChannel2\",\"type\":[\"null\",\"float\"],\"doc\":\"ECG signal from the second channel (\u00b5V). Null if the device does not have at least two channels.\",\"default\":null},{\"name\":\"ecgChannel3\",\"type\":[\"null\",\"float\"],\"doc\":\"ECG signal from the first channel (\u00b5V). Null if the device does not have at least two three channels.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BittiumFarosEcg> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BittiumFarosEcg> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public float ecgChannel1;
    @Deprecated
    public Float ecgChannel2;
    @Deprecated
    public Float ecgChannel3;
    private static final DatumWriter<BittiumFarosEcg> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BittiumFarosEcg> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BittiumFarosEcg> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BittiumFarosEcg> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BittiumFarosEcg> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BittiumFarosEcg fromByteBuffer(ByteBuffer b) throws IOException {
        return (BittiumFarosEcg)((Object)DECODER.decode(b));
    }

    public BittiumFarosEcg() {
    }

    public BittiumFarosEcg(Double time, Double timeReceived, Float ecgChannel1, Float ecgChannel2, Float ecgChannel3) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.ecgChannel1 = ecgChannel1.floatValue();
        this.ecgChannel2 = ecgChannel2;
        this.ecgChannel3 = ecgChannel3;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.ecgChannel1);
            }
            case 3: {
                return this.ecgChannel2;
            }
            case 4: {
                return this.ecgChannel3;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.ecgChannel1 = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.ecgChannel2 = (Float)value$;
                break;
            }
            case 4: {
                this.ecgChannel3 = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getEcgChannel1() {
        return this.ecgChannel1;
    }

    public void setEcgChannel1(float value) {
        this.ecgChannel1 = value;
    }

    public Float getEcgChannel2() {
        return this.ecgChannel2;
    }

    public void setEcgChannel2(Float value) {
        this.ecgChannel2 = value;
    }

    public Float getEcgChannel3() {
        return this.ecgChannel3;
    }

    public void setEcgChannel3(Float value) {
        this.ecgChannel3 = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BittiumFarosEcg other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.ecgChannel1);
        if (this.ecgChannel2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.ecgChannel2.floatValue());
        }
        if (this.ecgChannel3 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.ecgChannel3.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.ecgChannel1 = in.readFloat();
            if (in.readIndex() != 1) {
                in.readNull();
                this.ecgChannel2 = null;
            } else {
                this.ecgChannel2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.ecgChannel3 = null;
            } else {
                this.ecgChannel3 = Float.valueOf(in.readFloat());
            }
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.ecgChannel1 = in.readFloat();
                        continue block7;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ecgChannel2 = null;
                            continue block7;
                        }
                        this.ecgChannel2 = Float.valueOf(in.readFloat());
                        continue block7;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ecgChannel3 = null;
                            continue block7;
                        }
                        this.ecgChannel3 = Float.valueOf(in.readFloat());
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BittiumFarosEcg>
    implements RecordBuilder<BittiumFarosEcg> {
        private double time;
        private double timeReceived;
        private float ecgChannel1;
        private Float ecgChannel2;
        private Float ecgChannel3;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.ecgChannel1))) {
                this.ecgChannel1 = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.ecgChannel1))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.ecgChannel2)) {
                this.ecgChannel2 = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.ecgChannel2);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.ecgChannel3)) {
                this.ecgChannel3 = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.ecgChannel3);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(BittiumFarosEcg other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.ecgChannel1))) {
                this.ecgChannel1 = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.ecgChannel1))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.ecgChannel2)) {
                this.ecgChannel2 = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.ecgChannel2);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.ecgChannel3)) {
                this.ecgChannel3 = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.ecgChannel3);
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getEcgChannel1() {
            return this.ecgChannel1;
        }

        public Builder setEcgChannel1(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.ecgChannel1 = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEcgChannel1() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEcgChannel1() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Float getEcgChannel2() {
            return this.ecgChannel2;
        }

        public Builder setEcgChannel2(Float value) {
            this.validate(this.fields()[3], value);
            this.ecgChannel2 = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasEcgChannel2() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearEcgChannel2() {
            this.ecgChannel2 = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getEcgChannel3() {
            return this.ecgChannel3;
        }

        public Builder setEcgChannel3(Float value) {
            this.validate(this.fields()[4], value);
            this.ecgChannel3 = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasEcgChannel3() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearEcgChannel3() {
            this.ecgChannel3 = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public BittiumFarosEcg build() {
            try {
                BittiumFarosEcg record = new BittiumFarosEcg();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.ecgChannel1 = this.fieldSetFlags()[2] ? this.ecgChannel1 : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.ecgChannel2 = this.fieldSetFlags()[3] ? this.ecgChannel2 : (Float)this.defaultValue(this.fields()[3]);
                record.ecgChannel3 = this.fieldSetFlags()[4] ? this.ecgChannel3 : (Float)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

