/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.dreem;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class DreemMetric
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5726352589649448852L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DreemMetric\",\"namespace\":\"org.radarcns.passive.dreem\",\"doc\":\"Single computed Dreem endpoint Metric.\",\"fields\":[{\"name\":\"value\",\"type\":[\"null\",\"float\"],\"doc\":\"Value associated with the endpoint. Format: XX.XX .\",\"default\":null},{\"name\":\"confidenceIndex\",\"type\":[\"null\",\"float\"],\"doc\":\"Confidence index associated to the endpoint value (only for TST, SE, SOL, WASO, N1, N2, N3, REM, NREM, p_N1, p_N2, p_N3, p_REM). If not computed \u2018NA\u2019 but for schema purposes it is set to null.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<DreemMetric> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<DreemMetric> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public Float value;
    @Deprecated
    public Float confidenceIndex;
    private static final DatumWriter<DreemMetric> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<DreemMetric> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<DreemMetric> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<DreemMetric> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<DreemMetric> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static DreemMetric fromByteBuffer(ByteBuffer b) throws IOException {
        return (DreemMetric)((Object)DECODER.decode(b));
    }

    public DreemMetric() {
    }

    public DreemMetric(Float value, Float confidenceIndex) {
        this.value = value;
        this.confidenceIndex = confidenceIndex;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.confidenceIndex;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (Float)value$;
                break;
            }
            case 1: {
                this.confidenceIndex = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public Float getConfidenceIndex() {
        return this.confidenceIndex;
    }

    public void setConfidenceIndex(Float value) {
        this.confidenceIndex = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(DreemMetric other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.value == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.value.floatValue());
        }
        if (this.confidenceIndex == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.confidenceIndex.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.value = null;
            } else {
                this.value = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.confidenceIndex = null;
            } else {
                this.confidenceIndex = Float.valueOf(in.readFloat());
            }
        } else {
            block4: for (int i = 0; i < 2; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.value = null;
                            continue block4;
                        }
                        this.value = Float.valueOf(in.readFloat());
                        continue block4;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.confidenceIndex = null;
                            continue block4;
                        }
                        this.confidenceIndex = Float.valueOf(in.readFloat());
                        continue block4;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<DreemMetric>
    implements RecordBuilder<DreemMetric> {
        private Float value;
        private Float confidenceIndex;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Float)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.confidenceIndex)) {
                this.confidenceIndex = (Float)this.data().deepCopy(this.fields()[1].schema(), (Object)other.confidenceIndex);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
        }

        private Builder(DreemMetric other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (Float)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.confidenceIndex)) {
                this.confidenceIndex = (Float)this.data().deepCopy(this.fields()[1].schema(), (Object)other.confidenceIndex);
                this.fieldSetFlags()[1] = true;
            }
        }

        public Float getValue() {
            return this.value;
        }

        public Builder setValue(Float value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Float getConfidenceIndex() {
            return this.confidenceIndex;
        }

        public Builder setConfidenceIndex(Float value) {
            this.validate(this.fields()[1], value);
            this.confidenceIndex = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasConfidenceIndex() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearConfidenceIndex() {
            this.confidenceIndex = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public DreemMetric build() {
            try {
                DreemMetric record = new DreemMetric();
                record.value = this.fieldSetFlags()[0] ? this.value : (Float)this.defaultValue(this.fields()[0]);
                record.confidenceIndex = this.fieldSetFlags()[1] ? this.confidenceIndex : (Float)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

