/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.garmin.State;

@AvroGenerated
public class GarminGenericDeviceInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1168134906784562782L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminGenericDeviceInfo\",\"namespace\":\"org.radarcns.passive.garmin\",\"doc\":\"Device information for Garmin devices.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Last updated time.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"connectionState\",\"type\":{\"type\":\"enum\",\"name\":\"State\",\"doc\":\"Possible connection state values - UNKNOWN, DISCONNECTED, CONNECTING, CONNECTED.\",\"symbols\":[\"DISCONNECTED\",\"CONNECTING\",\"CONNECTED\",\"UNKNOWN\"]},\"doc\":\"Garmin device connection state.\",\"default\":\"UNKNOWN\"},{\"name\":\"deviceModel\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Device model. Supported model are listed on Garmin site - https://developer.garmin.com/health-sdk/overview/.\"},{\"name\":\"firmwareVersion\",\"type\":\"int\",\"doc\":\"Firmware version of Garmin device.\"},{\"name\":\"friendlyName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Friendly name of the device.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminGenericDeviceInfo> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminGenericDeviceInfo> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public State connectionState;
    @Deprecated
    public String deviceModel;
    @Deprecated
    public int firmwareVersion;
    @Deprecated
    public String friendlyName;
    private static final DatumWriter<GarminGenericDeviceInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminGenericDeviceInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminGenericDeviceInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminGenericDeviceInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminGenericDeviceInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminGenericDeviceInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminGenericDeviceInfo)((Object)DECODER.decode(b));
    }

    public GarminGenericDeviceInfo() {
    }

    public GarminGenericDeviceInfo(Double time, Double timeReceived, State connectionState, String deviceModel, Integer firmwareVersion, String friendlyName) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.connectionState = connectionState;
        this.deviceModel = deviceModel;
        this.firmwareVersion = firmwareVersion;
        this.friendlyName = friendlyName;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.connectionState;
            }
            case 3: {
                return this.deviceModel;
            }
            case 4: {
                return this.firmwareVersion;
            }
            case 5: {
                return this.friendlyName;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.connectionState = (State)((Object)value$);
                break;
            }
            case 3: {
                this.deviceModel = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.firmwareVersion = (Integer)value$;
                break;
            }
            case 5: {
                this.friendlyName = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public State getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(State value) {
        this.connectionState = value;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String value) {
        this.deviceModel = value;
    }

    public int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(int value) {
        this.firmwareVersion = value;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String value) {
        this.friendlyName = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminGenericDeviceInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeEnum(this.connectionState.ordinal());
        out.writeString(this.deviceModel);
        out.writeInt(this.firmwareVersion);
        out.writeString(this.friendlyName);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.connectionState = State.values()[in.readEnum()];
            this.deviceModel = in.readString();
            this.firmwareVersion = in.readInt();
            this.friendlyName = in.readString();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.connectionState = State.values()[in.readEnum()];
                        continue block8;
                    }
                    case 3: {
                        this.deviceModel = in.readString();
                        continue block8;
                    }
                    case 4: {
                        this.firmwareVersion = in.readInt();
                        continue block8;
                    }
                    case 5: {
                        this.friendlyName = in.readString();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminGenericDeviceInfo>
    implements RecordBuilder<GarminGenericDeviceInfo> {
        private double time;
        private double timeReceived;
        private State connectionState;
        private String deviceModel;
        private int firmwareVersion;
        private String friendlyName;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.connectionState))) {
                this.connectionState = (State)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.connectionState));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.deviceModel)) {
                this.deviceModel = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.deviceModel);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.firmwareVersion)) {
                this.firmwareVersion = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.firmwareVersion);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.friendlyName)) {
                this.friendlyName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.friendlyName);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(GarminGenericDeviceInfo other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.connectionState))) {
                this.connectionState = (State)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.connectionState));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.deviceModel)) {
                this.deviceModel = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.deviceModel);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.firmwareVersion)) {
                this.firmwareVersion = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.firmwareVersion);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.friendlyName)) {
                this.friendlyName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.friendlyName);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public State getConnectionState() {
            return this.connectionState;
        }

        public Builder setConnectionState(State value) {
            this.validate(this.fields()[2], (Object)value);
            this.connectionState = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasConnectionState() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearConnectionState() {
            this.connectionState = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDeviceModel() {
            return this.deviceModel;
        }

        public Builder setDeviceModel(String value) {
            this.validate(this.fields()[3], value);
            this.deviceModel = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDeviceModel() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDeviceModel() {
            this.deviceModel = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getFirmwareVersion() {
            return this.firmwareVersion;
        }

        public Builder setFirmwareVersion(int value) {
            this.validate(this.fields()[4], value);
            this.firmwareVersion = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFirmwareVersion() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFirmwareVersion() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public Builder setFriendlyName(String value) {
            this.validate(this.fields()[5], value);
            this.friendlyName = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFriendlyName() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFriendlyName() {
            this.friendlyName = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public GarminGenericDeviceInfo build() {
            try {
                GarminGenericDeviceInfo record = new GarminGenericDeviceInfo();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.connectionState = this.fieldSetFlags()[2] ? this.connectionState : (State)((Object)this.defaultValue(this.fields()[2]));
                record.deviceModel = this.fieldSetFlags()[3] ? this.deviceModel : (String)this.defaultValue(this.fields()[3]);
                record.firmwareVersion = this.fieldSetFlags()[4] ? this.firmwareVersion : (Integer)this.defaultValue(this.fields()[4]);
                record.friendlyName = this.fieldSetFlags()[5] ? this.friendlyName : (String)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

