/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminGenericIntensity
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1024058356544046347L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminGenericIntensity\",\"namespace\":\"org.radarcns.passive.garmin\",\"doc\":\"Intensity data from Garmin device. Garmin devices compare your heartrate data to determine intensity level. It compares resting heartrate with current heartrate to determine Vigorous or Moderate intensity level. No specific ranges or algorithm specified.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Last updated time.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"totalDailyMinutes\",\"type\":\"int\",\"doc\":\"Total Daily Minutes. Garmin devices accumulate intensity minutes throughout the day. This is what is available for current total daily minutes. This value indicates intensity minutes accumulated till that point of the day.\"},{\"name\":\"dailyModerateMinutes\",\"type\":\"int\",\"doc\":\"Daily Moderate Minutes. Garmin devices accumulate intensity minutes throughout the day. This is what is available for current total daily minutes. This value indicates intensity minutes accumulated till that point of the day.\"},{\"name\":\"dailyVigorousMinutes\",\"type\":\"int\",\"doc\":\"Daily Vigorous Minutes. Garmin devices accumulate intensity minutes throughout the day. This is what is available for current total daily minutes. This value indicates intensity minutes accumulated till that point of the day.\"},{\"name\":\"totalWeeklyMinutes\",\"type\":\"int\",\"doc\":\"Total Weekly Minutes.\"},{\"name\":\"weeklyGoal\",\"type\":\"int\",\"doc\":\"Weekly Goal.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminGenericIntensity> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminGenericIntensity> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public int totalDailyMinutes;
    @Deprecated
    public int dailyModerateMinutes;
    @Deprecated
    public int dailyVigorousMinutes;
    @Deprecated
    public int totalWeeklyMinutes;
    @Deprecated
    public int weeklyGoal;
    private static final DatumWriter<GarminGenericIntensity> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminGenericIntensity> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminGenericIntensity> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminGenericIntensity> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminGenericIntensity> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminGenericIntensity fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminGenericIntensity)((Object)DECODER.decode(b));
    }

    public GarminGenericIntensity() {
    }

    public GarminGenericIntensity(Double time, Double timeReceived, Integer totalDailyMinutes, Integer dailyModerateMinutes, Integer dailyVigorousMinutes, Integer totalWeeklyMinutes, Integer weeklyGoal) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.totalDailyMinutes = totalDailyMinutes;
        this.dailyModerateMinutes = dailyModerateMinutes;
        this.dailyVigorousMinutes = dailyVigorousMinutes;
        this.totalWeeklyMinutes = totalWeeklyMinutes;
        this.weeklyGoal = weeklyGoal;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.totalDailyMinutes;
            }
            case 3: {
                return this.dailyModerateMinutes;
            }
            case 4: {
                return this.dailyVigorousMinutes;
            }
            case 5: {
                return this.totalWeeklyMinutes;
            }
            case 6: {
                return this.weeklyGoal;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.totalDailyMinutes = (Integer)value$;
                break;
            }
            case 3: {
                this.dailyModerateMinutes = (Integer)value$;
                break;
            }
            case 4: {
                this.dailyVigorousMinutes = (Integer)value$;
                break;
            }
            case 5: {
                this.totalWeeklyMinutes = (Integer)value$;
                break;
            }
            case 6: {
                this.weeklyGoal = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getTotalDailyMinutes() {
        return this.totalDailyMinutes;
    }

    public void setTotalDailyMinutes(int value) {
        this.totalDailyMinutes = value;
    }

    public int getDailyModerateMinutes() {
        return this.dailyModerateMinutes;
    }

    public void setDailyModerateMinutes(int value) {
        this.dailyModerateMinutes = value;
    }

    public int getDailyVigorousMinutes() {
        return this.dailyVigorousMinutes;
    }

    public void setDailyVigorousMinutes(int value) {
        this.dailyVigorousMinutes = value;
    }

    public int getTotalWeeklyMinutes() {
        return this.totalWeeklyMinutes;
    }

    public void setTotalWeeklyMinutes(int value) {
        this.totalWeeklyMinutes = value;
    }

    public int getWeeklyGoal() {
        return this.weeklyGoal;
    }

    public void setWeeklyGoal(int value) {
        this.weeklyGoal = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminGenericIntensity other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.totalDailyMinutes);
        out.writeInt(this.dailyModerateMinutes);
        out.writeInt(this.dailyVigorousMinutes);
        out.writeInt(this.totalWeeklyMinutes);
        out.writeInt(this.weeklyGoal);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.totalDailyMinutes = in.readInt();
            this.dailyModerateMinutes = in.readInt();
            this.dailyVigorousMinutes = in.readInt();
            this.totalWeeklyMinutes = in.readInt();
            this.weeklyGoal = in.readInt();
        } else {
            block9: for (int i = 0; i < 7; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block9;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block9;
                    }
                    case 2: {
                        this.totalDailyMinutes = in.readInt();
                        continue block9;
                    }
                    case 3: {
                        this.dailyModerateMinutes = in.readInt();
                        continue block9;
                    }
                    case 4: {
                        this.dailyVigorousMinutes = in.readInt();
                        continue block9;
                    }
                    case 5: {
                        this.totalWeeklyMinutes = in.readInt();
                        continue block9;
                    }
                    case 6: {
                        this.weeklyGoal = in.readInt();
                        continue block9;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminGenericIntensity>
    implements RecordBuilder<GarminGenericIntensity> {
        private double time;
        private double timeReceived;
        private int totalDailyMinutes;
        private int dailyModerateMinutes;
        private int dailyVigorousMinutes;
        private int totalWeeklyMinutes;
        private int weeklyGoal;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.totalDailyMinutes)) {
                this.totalDailyMinutes = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.totalDailyMinutes);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.dailyModerateMinutes)) {
                this.dailyModerateMinutes = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.dailyModerateMinutes);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dailyVigorousMinutes)) {
                this.dailyVigorousMinutes = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dailyVigorousMinutes);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.totalWeeklyMinutes)) {
                this.totalWeeklyMinutes = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.totalWeeklyMinutes);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.weeklyGoal)) {
                this.weeklyGoal = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.weeklyGoal);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
        }

        private Builder(GarminGenericIntensity other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.totalDailyMinutes)) {
                this.totalDailyMinutes = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.totalDailyMinutes);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.dailyModerateMinutes)) {
                this.dailyModerateMinutes = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.dailyModerateMinutes);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dailyVigorousMinutes)) {
                this.dailyVigorousMinutes = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dailyVigorousMinutes);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.totalWeeklyMinutes)) {
                this.totalWeeklyMinutes = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.totalWeeklyMinutes);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.weeklyGoal)) {
                this.weeklyGoal = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.weeklyGoal);
                this.fieldSetFlags()[6] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getTotalDailyMinutes() {
            return this.totalDailyMinutes;
        }

        public Builder setTotalDailyMinutes(int value) {
            this.validate(this.fields()[2], value);
            this.totalDailyMinutes = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTotalDailyMinutes() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTotalDailyMinutes() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getDailyModerateMinutes() {
            return this.dailyModerateMinutes;
        }

        public Builder setDailyModerateMinutes(int value) {
            this.validate(this.fields()[3], value);
            this.dailyModerateMinutes = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDailyModerateMinutes() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDailyModerateMinutes() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getDailyVigorousMinutes() {
            return this.dailyVigorousMinutes;
        }

        public Builder setDailyVigorousMinutes(int value) {
            this.validate(this.fields()[4], value);
            this.dailyVigorousMinutes = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDailyVigorousMinutes() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDailyVigorousMinutes() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public int getTotalWeeklyMinutes() {
            return this.totalWeeklyMinutes;
        }

        public Builder setTotalWeeklyMinutes(int value) {
            this.validate(this.fields()[5], value);
            this.totalWeeklyMinutes = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTotalWeeklyMinutes() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTotalWeeklyMinutes() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public int getWeeklyGoal() {
            return this.weeklyGoal;
        }

        public Builder setWeeklyGoal(int value) {
            this.validate(this.fields()[6], value);
            this.weeklyGoal = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasWeeklyGoal() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearWeeklyGoal() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public GarminGenericIntensity build() {
            try {
                GarminGenericIntensity record = new GarminGenericIntensity();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.totalDailyMinutes = this.fieldSetFlags()[2] ? this.totalDailyMinutes : (Integer)this.defaultValue(this.fields()[2]);
                record.dailyModerateMinutes = this.fieldSetFlags()[3] ? this.dailyModerateMinutes : (Integer)this.defaultValue(this.fields()[3]);
                record.dailyVigorousMinutes = this.fieldSetFlags()[4] ? this.dailyVigorousMinutes : (Integer)this.defaultValue(this.fields()[4]);
                record.totalWeeklyMinutes = this.fieldSetFlags()[5] ? this.totalWeeklyMinutes : (Integer)this.defaultValue(this.fields()[5]);
                record.weeklyGoal = this.fieldSetFlags()[6] ? this.weeklyGoal : (Integer)this.defaultValue(this.fields()[6]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

