/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminHeartRateSample
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6290030765816141491L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminHeartRateSample\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Mapping between time (in seconds) to a heart rate value recorded for the time, in beats per minute. Each entry is a representative sample of the previous 15 seconds from the given time. Lack of entry for a given time should be interpreted as no data available. These are accompanied with the Dailies data and can be associated using the summaryId.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sample in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time this sample was recieved by the push service in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary that this sample is associated with.\"},{\"name\":\"heartRate\",\"type\":[\"null\",\"float\"],\"doc\":\"Heart rate in beats per minute.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminHeartRateSample> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminHeartRateSample> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String summaryId;
    @Deprecated
    public Float heartRate;
    private static final DatumWriter<GarminHeartRateSample> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminHeartRateSample> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminHeartRateSample> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminHeartRateSample> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminHeartRateSample> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminHeartRateSample fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminHeartRateSample)((Object)DECODER.decode(b));
    }

    public GarminHeartRateSample() {
    }

    public GarminHeartRateSample(Double time, Double timeReceived, String summaryId, Float heartRate) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.heartRate = heartRate;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.heartRate;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.heartRate = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Float getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(Float value) {
        this.heartRate = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminHeartRateSample other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.heartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.heartRate.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRate = null;
            } else {
                this.heartRate = Float.valueOf(in.readFloat());
            }
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block6;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRate = null;
                            continue block6;
                        }
                        this.heartRate = Float.valueOf(in.readFloat());
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminHeartRateSample>
    implements RecordBuilder<GarminHeartRateSample> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Float heartRate;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.heartRate)) {
                this.heartRate = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(GarminHeartRateSample other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.heartRate)) {
                this.heartRate = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Float getHeartRate() {
            return this.heartRate;
        }

        public Builder setHeartRate(Float value) {
            this.validate(this.fields()[3], value);
            this.heartRate = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasHeartRate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearHeartRate() {
            this.heartRate = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public GarminHeartRateSample build() {
            try {
                GarminHeartRateSample record = new GarminHeartRateSample();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.heartRate = this.fieldSetFlags()[3] ? this.heartRate : (Float)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

