/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminMoveIQSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -4050173736315250695L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminMoveIQSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Move IQ Event summaries are a feed of activities which have been automatically detected by the device based on movement patterns, like running or biking. These are not activities initiated by the user. Please note that wellness data, like steps and distance, from Move IQ events are already included in the Daily and Epoch summaries. Due to their automatically-detected nature, Move IQ events are not considered a fitness activity, do not contain the same details as activities, and cannot be edited by the user with Garmin Connect. These events should be considered a labeled-timespan on top of normal Daily or Epoch summary details, matching their representation within Garmin Connect. For more feature-level information on Move IQ events, please see: https://support.garmin.com/faqSearch/en- US/faq/content/zgFpy8MShkArqAxCug5wC6 . Move IQ activities are also known as Automatic Activity Detection in older devices or documentation.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"offset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"activityType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The activity type that has been identified for this timespan. e.g - SEDENTARY, SLEEP, RUNNING, CYCLING, WALKING, etc.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"The duration of the measurement period in seconds.\",\"default\":null},{\"name\":\"activitySubType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The activity subtype that has been identified for this timespan.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminMoveIQSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminMoveIQSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public double time;
    @Deprecated
    public double timeReceived;
    @Deprecated
    public String summaryId;
    @Deprecated
    public String date;
    @Deprecated
    public Integer offset;
    @Deprecated
    public String activityType;
    @Deprecated
    public Integer duration;
    @Deprecated
    public String activitySubType;
    private static final DatumWriter<GarminMoveIQSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminMoveIQSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminMoveIQSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminMoveIQSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminMoveIQSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminMoveIQSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminMoveIQSummary)((Object)DECODER.decode(b));
    }

    public GarminMoveIQSummary() {
    }

    public GarminMoveIQSummary(Double time, Double timeReceived, String summaryId, String date, Integer offset, String activityType, Integer duration, String activitySubType) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.offset = offset;
        this.activityType = activityType;
        this.duration = duration;
        this.activitySubType = activitySubType;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.offset;
            }
            case 5: {
                return this.activityType;
            }
            case 6: {
                return this.duration;
            }
            case 7: {
                return this.activitySubType;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.offset = (Integer)value$;
                break;
            }
            case 5: {
                this.activityType = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.duration = (Integer)value$;
                break;
            }
            case 7: {
                this.activitySubType = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer value) {
        this.offset = value;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String value) {
        this.activityType = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public String getActivitySubType() {
        return this.activitySubType;
    }

    public void setActivitySubType(String value) {
        this.activitySubType = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminMoveIQSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.offset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.offset.intValue());
        }
        if (this.activityType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activityType);
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
        if (this.activitySubType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activitySubType);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.offset = null;
            } else {
                this.offset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activityType = null;
            } else {
                this.activityType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activitySubType = null;
            } else {
                this.activitySubType = in.readString();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block10;
                        }
                        this.date = in.readString();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.offset = null;
                            continue block10;
                        }
                        this.offset = in.readInt();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activityType = null;
                            continue block10;
                        }
                        this.activityType = in.readString();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block10;
                        }
                        this.duration = in.readInt();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activitySubType = null;
                            continue block10;
                        }
                        this.activitySubType = in.readString();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminMoveIQSummary>
    implements RecordBuilder<GarminMoveIQSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer offset;
        private String activityType;
        private Integer duration;
        private String activitySubType;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.offset)) {
                this.offset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.offset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.activityType);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.duration);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.activitySubType)) {
                this.activitySubType = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.activitySubType);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(GarminMoveIQSummary other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.offset)) {
                this.offset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.offset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.activityType);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.duration);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.activitySubType)) {
                this.activitySubType = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.activitySubType);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getOffset() {
            return this.offset;
        }

        public Builder setOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.offset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearOffset() {
            this.offset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getActivityType() {
            return this.activityType;
        }

        public Builder setActivityType(String value) {
            this.validate(this.fields()[5], value);
            this.activityType = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasActivityType() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearActivityType() {
            this.activityType = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[6], value);
            this.duration = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getActivitySubType() {
            return this.activitySubType;
        }

        public Builder setActivitySubType(String value) {
            this.validate(this.fields()[7], value);
            this.activitySubType = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasActivitySubType() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearActivitySubType() {
            this.activitySubType = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public GarminMoveIQSummary build() {
            try {
                GarminMoveIQSummary record = new GarminMoveIQSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.offset = this.fieldSetFlags()[4] ? this.offset : (Integer)this.defaultValue(this.fields()[4]);
                record.activityType = this.fieldSetFlags()[5] ? this.activityType : (String)this.defaultValue(this.fields()[5]);
                record.duration = this.fieldSetFlags()[6] ? this.duration : (Integer)this.defaultValue(this.fields()[6]);
                record.activitySubType = this.fieldSetFlags()[7] ? this.activitySubType : (String)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

