/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.stream.aggregator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.stream.aggregator.NumericAggregate;

@AvroGenerated
public class AggregateList
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4479369399645933568L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AggregateList\",\"namespace\":\"org.radarcns.stream.aggregator\",\"doc\":\"A list of aggregated data, each item aggregating over a single field.\",\"fields\":[{\"name\":\"fields\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"NumericAggregate\",\"doc\":\"Basic statistics on a numeric value type.\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Name of the field that has been aggregated over.\"},{\"name\":\"min\",\"type\":\"double\",\"doc\":\"State the minimum between accumulated values.\"},{\"name\":\"max\",\"type\":\"double\",\"doc\":\"State the maximum between accumulated values.\"},{\"name\":\"sum\",\"type\":\"double\",\"doc\":\"State the sum of accumulated values.\"},{\"name\":\"count\",\"type\":\"int\",\"doc\":\"Count the accumulated values.\"},{\"name\":\"mean\",\"type\":[\"null\",\"double\"],\"doc\":\"State the arithmetic mean between accumulated values.\",\"default\":null},{\"name\":\"quartile\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"double\"}],\"doc\":\"Quartile of accumulated values.\",\"default\":null}]}},\"doc\":\"Aggregates of each of the underlying elements.\"}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<AggregateList> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<AggregateList> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public List<NumericAggregate> fields;
    private static final DatumWriter<AggregateList> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<AggregateList> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<AggregateList> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<AggregateList> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<AggregateList> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static AggregateList fromByteBuffer(ByteBuffer b) throws IOException {
        return (AggregateList)((Object)DECODER.decode(b));
    }

    public AggregateList() {
    }

    public AggregateList(List<NumericAggregate> fields) {
        this.fields = fields;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.fields;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.fields = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public List<NumericAggregate> getFields() {
        return this.fields;
    }

    public void setFields(List<NumericAggregate> value) {
        this.fields = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(AggregateList other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        long size0 = this.fields.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (NumericAggregate e0 : this.fields) {
            ++actualSize0;
            out.startItem();
            e0.customEncode(out);
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga0;
            long size0 = in.readArrayStart();
            GenericData.Array a0 = this.fields;
            if (a0 == null) {
                this.fields = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("fields").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    NumericAggregate e0;
                    NumericAggregate numericAggregate = e0 = ga0 != null ? (NumericAggregate)((Object)ga0.peek()) : null;
                    if (e0 == null) {
                        e0 = new NumericAggregate();
                    }
                    e0.customDecode(in);
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
        } else {
            block5: for (int i = 0; i < 1; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.fields;
                        if (a0 == null) {
                            this.fields = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("fields").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                NumericAggregate e0;
                                NumericAggregate numericAggregate = e0 = ga0 != null ? (NumericAggregate)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new NumericAggregate();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<AggregateList>
    implements RecordBuilder<AggregateList> {
        private List<NumericAggregate> fields;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], other.fields)) {
                this.fields = (List)this.data().deepCopy(this.fields()[0].schema(), other.fields);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(AggregateList other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], other.fields)) {
                this.fields = (List)this.data().deepCopy(this.fields()[0].schema(), other.fields);
                this.fieldSetFlags()[0] = true;
            }
        }

        public List<NumericAggregate> getFields() {
            return this.fields;
        }

        public Builder setFields(List<NumericAggregate> value) {
            this.validate(this.fields()[0], value);
            this.fields = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFields() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFields() {
            this.fields = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public AggregateList build() {
            try {
                AggregateList record = new AggregateList();
                record.fields = this.fieldSetFlags()[0] ? this.fields : (List)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

