/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.stream.aggregator;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class NumericAggregate
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2879065902397784179L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"NumericAggregate\",\"namespace\":\"org.radarcns.stream.aggregator\",\"doc\":\"Basic statistics on a numeric value type.\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Name of the field that has been aggregated over.\"},{\"name\":\"min\",\"type\":\"double\",\"doc\":\"State the minimum between accumulated values.\"},{\"name\":\"max\",\"type\":\"double\",\"doc\":\"State the maximum between accumulated values.\"},{\"name\":\"sum\",\"type\":\"double\",\"doc\":\"State the sum of accumulated values.\"},{\"name\":\"count\",\"type\":\"int\",\"doc\":\"Count the accumulated values.\"},{\"name\":\"mean\",\"type\":[\"null\",\"double\"],\"doc\":\"State the arithmetic mean between accumulated values.\",\"default\":null},{\"name\":\"quartile\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"double\"}],\"doc\":\"Quartile of accumulated values.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<NumericAggregate> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<NumericAggregate> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String name;
    @Deprecated
    public double min;
    @Deprecated
    public double max;
    @Deprecated
    public double sum;
    @Deprecated
    public int count;
    @Deprecated
    public Double mean;
    @Deprecated
    public List<Double> quartile;
    private static final DatumWriter<NumericAggregate> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<NumericAggregate> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<NumericAggregate> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<NumericAggregate> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<NumericAggregate> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static NumericAggregate fromByteBuffer(ByteBuffer b) throws IOException {
        return (NumericAggregate)((Object)DECODER.decode(b));
    }

    public NumericAggregate() {
    }

    public NumericAggregate(String name, Double min, Double max, Double sum, Integer count, Double mean, List<Double> quartile) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
        this.mean = mean;
        this.quartile = quartile;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.min;
            }
            case 2: {
                return this.max;
            }
            case 3: {
                return this.sum;
            }
            case 4: {
                return this.count;
            }
            case 5: {
                return this.mean;
            }
            case 6: {
                return this.quartile;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.min = (Double)value$;
                break;
            }
            case 2: {
                this.max = (Double)value$;
                break;
            }
            case 3: {
                this.sum = (Double)value$;
                break;
            }
            case 4: {
                this.count = (Integer)value$;
                break;
            }
            case 5: {
                this.mean = (Double)value$;
                break;
            }
            case 6: {
                this.quartile = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double value) {
        this.min = value;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double value) {
        this.max = value;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double value) {
        this.sum = value;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int value) {
        this.count = value;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double value) {
        this.mean = value;
    }

    public List<Double> getQuartile() {
        return this.quartile;
    }

    public void setQuartile(List<Double> value) {
        this.quartile = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(NumericAggregate other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.name);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sum);
        out.writeInt(this.count);
        if (this.mean == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.mean.doubleValue());
        }
        if (this.quartile == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.quartile.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (Double e0 : this.quartile) {
                ++actualSize0;
                out.startItem();
                out.writeDouble(e0.doubleValue());
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.name = in.readString();
            this.min = in.readDouble();
            this.max = in.readDouble();
            this.sum = in.readDouble();
            this.count = in.readInt();
            if (in.readIndex() != 1) {
                in.readNull();
                this.mean = null;
            } else {
                this.mean = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.quartile = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                GenericData.Array a0 = this.quartile;
                if (a0 == null) {
                    this.quartile = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("quartile").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        Double e0 = ga0 != null ? (Double)ga0.peek() : null;
                        e0 = in.readDouble();
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
        } else {
            block11: for (int i = 0; i < 7; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.name = in.readString();
                        continue block11;
                    }
                    case 1: {
                        this.min = in.readDouble();
                        continue block11;
                    }
                    case 2: {
                        this.max = in.readDouble();
                        continue block11;
                    }
                    case 3: {
                        this.sum = in.readDouble();
                        continue block11;
                    }
                    case 4: {
                        this.count = in.readInt();
                        continue block11;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mean = null;
                            continue block11;
                        }
                        this.mean = in.readDouble();
                        continue block11;
                    }
                    case 6: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.quartile = null;
                            continue block11;
                        }
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.quartile;
                        if (a0 == null) {
                            this.quartile = a0 = new GenericData.Array((int)size0, (Schema)SCHEMA$.getField("quartile").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                Double e0 = ga0 != null ? (Double)ga0.peek() : null;
                                e0 = in.readDouble();
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<NumericAggregate>
    implements RecordBuilder<NumericAggregate> {
        private String name;
        private double min;
        private double max;
        private double sum;
        private int count;
        private Double mean;
        private List<Double> quartile;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.min)) {
                this.min = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.min);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.max)) {
                this.max = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.max);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sum)) {
                this.sum = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sum);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.count)) {
                this.count = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.count);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.mean)) {
                this.mean = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mean);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], other.quartile)) {
                this.quartile = (List)this.data().deepCopy(this.fields()[6].schema(), other.quartile);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
        }

        private Builder(NumericAggregate other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.min)) {
                this.min = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.min);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.max)) {
                this.max = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.max);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sum)) {
                this.sum = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sum);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.count)) {
                this.count = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.count);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.mean)) {
                this.mean = (Double)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mean);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], other.quartile)) {
                this.quartile = (List)this.data().deepCopy(this.fields()[6].schema(), other.quartile);
                this.fieldSetFlags()[6] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getMin() {
            return this.min;
        }

        public Builder setMin(double value) {
            this.validate(this.fields()[1], value);
            this.min = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasMin() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearMin() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getMax() {
            return this.max;
        }

        public Builder setMax(double value) {
            this.validate(this.fields()[2], value);
            this.max = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasMax() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearMax() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public double getSum() {
            return this.sum;
        }

        public Builder setSum(double value) {
            this.validate(this.fields()[3], value);
            this.sum = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSum() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSum() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getCount() {
            return this.count;
        }

        public Builder setCount(int value) {
            this.validate(this.fields()[4], value);
            this.count = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasCount() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearCount() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Double getMean() {
            return this.mean;
        }

        public Builder setMean(Double value) {
            this.validate(this.fields()[5], value);
            this.mean = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMean() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMean() {
            this.mean = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public List<Double> getQuartile() {
            return this.quartile;
        }

        public Builder setQuartile(List<Double> value) {
            this.validate(this.fields()[6], value);
            this.quartile = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasQuartile() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearQuartile() {
            this.quartile = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public NumericAggregate build() {
            try {
                NumericAggregate record = new NumericAggregate();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.min = this.fieldSetFlags()[1] ? this.min : (Double)this.defaultValue(this.fields()[1]);
                record.max = this.fieldSetFlags()[2] ? this.max : (Double)this.defaultValue(this.fields()[2]);
                record.sum = this.fieldSetFlags()[3] ? this.sum : (Double)this.defaultValue(this.fields()[3]);
                record.count = this.fieldSetFlags()[4] ? this.count : (Integer)this.defaultValue(this.fields()[4]);
                record.mean = this.fieldSetFlags()[5] ? this.mean : (Double)this.defaultValue(this.fields()[5]);
                record.quartile = this.fieldSetFlags()[6] ? this.quartile : (List)this.defaultValue(this.fields()[6]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

