/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.active.banking;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.active.banking.EventType;

@AvroGenerated
public class BankingEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6051961016824514992L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BankingEvent\",\"namespace\":\"org.radarcns.active.banking\",\"doc\":\"A Banking App Event, which is either a correct or wrong submission of a PIN number, an amount to withdraw, a cancelled or confirmed transaction. Notably, this allows us to distinguish between a wrong confirmed transaction or a correct cancelled transaction etc.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), time stores the time an event has started.\"},{\"name\":\"timeCompleted\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), time stores the time an event has been completed.\"},{\"name\":\"duration\",\"type\":\"double\",\"doc\":\"Duration of the event (seconds), duration is essentially timeCompleted - time.\"},{\"name\":\"transactionId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The uid of Transaction record that the event is related to.\"},{\"name\":\"isCorrect\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Describes if the input Pin or Amount is correct. Null if this event is a confirmation or cancellation.\",\"default\":null},{\"name\":\"eventType\",\"type\":{\"type\":\"enum\",\"name\":\"EventType\",\"doc\":\"PIN: PIN input, AMOUNT: Amount input, TRANSACTION_CANCELLED: the Transaction is canceled, TRANSACTION_CONFIRMED: the Transaction is confirmed, UNKNOWN: for any other input type.\",\"symbols\":[\"PIN\",\"AMOUNT\",\"TRANSACTION_CANCELLED\",\"TRANSACTION_CONFIRMED\",\"UNKNOWN\"]},\"doc\":\"The type of submitted input: PIN or Amount.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BankingEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BankingEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeCompleted;
    private double duration;
    private String transactionId;
    private Boolean isCorrect;
    private EventType eventType;
    private static final DatumWriter<BankingEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BankingEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BankingEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BankingEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BankingEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BankingEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (BankingEvent)((Object)DECODER.decode(b));
    }

    public BankingEvent() {
    }

    public BankingEvent(Double time, Double timeCompleted, Double duration, String transactionId, Boolean isCorrect, EventType eventType) {
        this.time = time;
        this.timeCompleted = timeCompleted;
        this.duration = duration;
        this.transactionId = transactionId;
        this.isCorrect = isCorrect;
        this.eventType = eventType;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeCompleted;
            }
            case 2: {
                return this.duration;
            }
            case 3: {
                return this.transactionId;
            }
            case 4: {
                return this.isCorrect;
            }
            case 5: {
                return this.eventType;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeCompleted = (Double)value$;
                break;
            }
            case 2: {
                this.duration = (Double)value$;
                break;
            }
            case 3: {
                this.transactionId = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.isCorrect = (Boolean)value$;
                break;
            }
            case 5: {
                this.eventType = (EventType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(double value) {
        this.timeCompleted = value;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double value) {
        this.duration = value;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String value) {
        this.transactionId = value;
    }

    public Boolean getIsCorrect() {
        return this.isCorrect;
    }

    public void setIsCorrect(Boolean value) {
        this.isCorrect = value;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType value) {
        this.eventType = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BankingEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeCompleted);
        out.writeDouble(this.duration);
        out.writeString(this.transactionId);
        if (this.isCorrect == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.isCorrect.booleanValue());
        }
        out.writeEnum(this.eventType.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeCompleted = in.readDouble();
            this.duration = in.readDouble();
            this.transactionId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.isCorrect = null;
            } else {
                this.isCorrect = in.readBoolean();
            }
            this.eventType = EventType.values()[in.readEnum()];
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeCompleted = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.duration = in.readDouble();
                        continue block8;
                    }
                    case 3: {
                        this.transactionId = in.readString();
                        continue block8;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isCorrect = null;
                            continue block8;
                        }
                        this.isCorrect = in.readBoolean();
                        continue block8;
                    }
                    case 5: {
                        this.eventType = EventType.values()[in.readEnum()];
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BankingEvent>
    implements RecordBuilder<BankingEvent> {
        private double time;
        private double timeCompleted;
        private double duration;
        private String transactionId;
        private Boolean isCorrect;
        private EventType eventType;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.transactionId)) {
                this.transactionId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.transactionId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isCorrect)) {
                this.isCorrect = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isCorrect);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.eventType))) {
                this.eventType = (EventType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.eventType));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(BankingEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.transactionId)) {
                this.transactionId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.transactionId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isCorrect)) {
                this.isCorrect = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isCorrect);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.eventType))) {
                this.eventType = (EventType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.eventType));
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeCompleted() {
            return this.timeCompleted;
        }

        public Builder setTimeCompleted(double value) {
            this.validate(this.fields()[1], value);
            this.timeCompleted = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeCompleted() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeCompleted() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getDuration() {
            return this.duration;
        }

        public Builder setDuration(double value) {
            this.validate(this.fields()[2], value);
            this.duration = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearDuration() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public Builder setTransactionId(String value) {
            this.validate(this.fields()[3], value);
            this.transactionId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTransactionId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTransactionId() {
            this.transactionId = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getIsCorrect() {
            return this.isCorrect;
        }

        public Builder setIsCorrect(Boolean value) {
            this.validate(this.fields()[4], value);
            this.isCorrect = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasIsCorrect() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearIsCorrect() {
            this.isCorrect = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Builder setEventType(EventType value) {
            this.validate(this.fields()[5], (Object)value);
            this.eventType = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasEventType() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearEventType() {
            this.eventType = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public BankingEvent build() {
            try {
                BankingEvent record = new BankingEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeCompleted = this.fieldSetFlags()[1] ? this.timeCompleted : (Double)this.defaultValue(this.fields()[1]);
                record.duration = this.fieldSetFlags()[2] ? this.duration : (Double)this.defaultValue(this.fields()[2]);
                record.transactionId = this.fieldSetFlags()[3] ? this.transactionId : (String)this.defaultValue(this.fields()[3]);
                record.isCorrect = this.fieldSetFlags()[4] ? this.isCorrect : (Boolean)this.defaultValue(this.fields()[4]);
                record.eventType = this.fieldSetFlags()[5] ? this.eventType : (EventType)((Object)this.defaultValue(this.fields()[5]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

