/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.kafka;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class ObservationKey
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8600894260405902847L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ObservationKey\",\"namespace\":\"org.radarcns.kafka\",\"doc\":\"Key of an observation.\",\"fields\":[{\"name\":\"projectId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Project identifier. Null if unknown or the user is not enrolled in a project.\",\"default\":null},{\"name\":\"userId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"User Identifier created during the enrolment.\"},{\"name\":\"sourceId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier associated with the source.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ObservationKey> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<ObservationKey> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String projectId;
    private String userId;
    private String sourceId;
    private static final DatumWriter<ObservationKey> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<ObservationKey> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ObservationKey> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ObservationKey> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ObservationKey> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ObservationKey fromByteBuffer(ByteBuffer b) throws IOException {
        return (ObservationKey)((Object)DECODER.decode(b));
    }

    public ObservationKey() {
    }

    public ObservationKey(String projectId, String userId, String sourceId) {
        this.projectId = projectId;
        this.userId = userId;
        this.sourceId = sourceId;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.projectId;
            }
            case 1: {
                return this.userId;
            }
            case 2: {
                return this.sourceId;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.projectId = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.userId = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.sourceId = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String value) {
        this.projectId = value;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String value) {
        this.userId = value;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String value) {
        this.sourceId = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ObservationKey other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        if (this.projectId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.projectId);
        }
        out.writeString(this.userId);
        out.writeString(this.sourceId);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.projectId = null;
            } else {
                this.projectId = in.readString();
            }
            this.userId = in.readString();
            this.sourceId = in.readString();
        } else {
            block5: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.projectId = null;
                            continue block5;
                        }
                        this.projectId = in.readString();
                        continue block5;
                    }
                    case 1: {
                        this.userId = in.readString();
                        continue block5;
                    }
                    case 2: {
                        this.sourceId = in.readString();
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ObservationKey>
    implements RecordBuilder<ObservationKey> {
        private String projectId;
        private String userId;
        private String sourceId;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.projectId)) {
                this.projectId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.projectId);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.userId)) {
                this.userId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.userId);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(ObservationKey other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.projectId)) {
                this.projectId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.projectId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.userId)) {
                this.userId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.userId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[2] = true;
            }
        }

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setProjectId(String value) {
            this.validate(this.fields()[0], value);
            this.projectId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasProjectId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearProjectId() {
            this.projectId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getUserId() {
            return this.userId;
        }

        public Builder setUserId(String value) {
            this.validate(this.fields()[1], value);
            this.userId = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearUserId() {
            this.userId = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public Builder setSourceId(String value) {
            this.validate(this.fields()[2], value);
            this.sourceId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSourceId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSourceId() {
            this.sourceId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ObservationKey build() {
            try {
                ObservationKey record = new ObservationKey();
                record.projectId = this.fieldSetFlags()[0] ? this.projectId : (String)this.defaultValue(this.fields()[0]);
                record.userId = this.fieldSetFlags()[1] ? this.userId : (String)this.defaultValue(this.fields()[1]);
                record.sourceId = this.fieldSetFlags()[2] ? this.sourceId : (String)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

