/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.phone;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.phone.BatteryStatus;

@AvroGenerated
public class PhoneBatteryLevel
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6237800493324270608L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PhoneBatteryLevel\",\"namespace\":\"org.radarcns.passive.phone\",\"doc\":\"Phone battery level.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"batteryLevel\",\"type\":\"float\",\"doc\":\"Battery level from 0 to 1.\"},{\"name\":\"isPlugged\",\"type\":\"boolean\",\"doc\":\"Whether the phone is connected to a power source.\"},{\"name\":\"status\",\"type\":{\"type\":\"enum\",\"name\":\"BatteryStatus\",\"doc\":\"Android device battery states.\",\"symbols\":[\"CHARGING\",\"DISCHARGING\",\"NOT_CHARGING\",\"FULL\",\"UNKNOWN\"]},\"doc\":\"Android battery states.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<PhoneBatteryLevel> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<PhoneBatteryLevel> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float batteryLevel;
    private boolean isPlugged;
    private BatteryStatus status;
    private static final DatumWriter<PhoneBatteryLevel> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<PhoneBatteryLevel> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<PhoneBatteryLevel> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<PhoneBatteryLevel> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<PhoneBatteryLevel> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static PhoneBatteryLevel fromByteBuffer(ByteBuffer b) throws IOException {
        return (PhoneBatteryLevel)((Object)DECODER.decode(b));
    }

    public PhoneBatteryLevel() {
    }

    public PhoneBatteryLevel(Double time, Double timeReceived, Float batteryLevel, Boolean isPlugged, BatteryStatus status) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.batteryLevel = batteryLevel.floatValue();
        this.isPlugged = isPlugged;
        this.status = status;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.batteryLevel);
            }
            case 3: {
                return this.isPlugged;
            }
            case 4: {
                return this.status;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.batteryLevel = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.isPlugged = (Boolean)value$;
                break;
            }
            case 4: {
                this.status = (BatteryStatus)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(float value) {
        this.batteryLevel = value;
    }

    public boolean getIsPlugged() {
        return this.isPlugged;
    }

    public void setIsPlugged(boolean value) {
        this.isPlugged = value;
    }

    public BatteryStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatteryStatus value) {
        this.status = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(PhoneBatteryLevel other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.batteryLevel);
        out.writeBoolean(this.isPlugged);
        out.writeEnum(this.status.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.batteryLevel = in.readFloat();
            this.isPlugged = in.readBoolean();
            this.status = BatteryStatus.values()[in.readEnum()];
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.batteryLevel = in.readFloat();
                        continue block7;
                    }
                    case 3: {
                        this.isPlugged = in.readBoolean();
                        continue block7;
                    }
                    case 4: {
                        this.status = BatteryStatus.values()[in.readEnum()];
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<PhoneBatteryLevel>
    implements RecordBuilder<PhoneBatteryLevel> {
        private double time;
        private double timeReceived;
        private float batteryLevel;
        private boolean isPlugged;
        private BatteryStatus status;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.isPlugged)) {
                this.isPlugged = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.isPlugged);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.status))) {
                this.status = (BatteryStatus)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.status));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(PhoneBatteryLevel other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.isPlugged)) {
                this.isPlugged = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.isPlugged);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.status))) {
                this.status = (BatteryStatus)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.status));
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getBatteryLevel() {
            return this.batteryLevel;
        }

        public Builder setBatteryLevel(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.batteryLevel = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasBatteryLevel() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearBatteryLevel() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getIsPlugged() {
            return this.isPlugged;
        }

        public Builder setIsPlugged(boolean value) {
            this.validate(this.fields()[3], value);
            this.isPlugged = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasIsPlugged() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearIsPlugged() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public BatteryStatus getStatus() {
            return this.status;
        }

        public Builder setStatus(BatteryStatus value) {
            this.validate(this.fields()[4], (Object)value);
            this.status = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStatus() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStatus() {
            this.status = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public PhoneBatteryLevel build() {
            try {
                PhoneBatteryLevel record = new PhoneBatteryLevel();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.batteryLevel = this.fieldSetFlags()[2] ? this.batteryLevel : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.isPlugged = this.fieldSetFlags()[3] ? this.isPlugged : (Boolean)this.defaultValue(this.fields()[3]);
                record.status = this.fieldSetFlags()[4] ? this.status : (BatteryStatus)((Object)this.defaultValue(this.fields()[4]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

