/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminActivitySummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 7891999707642493186L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminActivitySummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Fitness activity summaries represent high-level information from discrete fitness activities, such as running or swimming, that are specifically and intentionally started by the user on their device. All wellness data, like steps and distance, contained in the Activity are already represented in the Daily summary and in the corresponding Epoch summaries, so Activity summaries should only be used for programs that wish to treat specific activity types in different ways, such as giving the user extra credit for going swimming three times in the same week.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"activityType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Text description of the activity type.  e.g - SEDENTARY, SLEEP, RUNNING, CYCLING, WALKING, etc.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the monitoring period in seconds. 86400 once a full day is complete, but less if a user syncs mid-day.\",\"default\":null},{\"name\":\"averageBikeCadence\",\"type\":[\"null\",\"float\"],\"doc\":\"Average Bike Cadence in rounds per minute.\",\"default\":null},{\"name\":\"maxBikeCadence\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum Bike Cadence in rounds per minute.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled in meters.\",\"default\":null},{\"name\":\"averageRunCadence\",\"type\":[\"null\",\"float\"],\"doc\":\"Average Run Cadence in Steps per minute.\",\"default\":null},{\"name\":\"maxRunCadence\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum Run Cadence in Steps per minute.\",\"default\":null},{\"name\":\"activeKilocalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Active kilocalories (dietary calories) burned through actual movement and activity during the monitoring period.\",\"default\":null},{\"name\":\"averageSpeed\",\"type\":[\"null\",\"float\"],\"doc\":\"Average Speed in meters per second.\",\"default\":null},{\"name\":\"maxSpeed\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum Speed in meters per second.\",\"default\":null},{\"name\":\"averageSwimCadence\",\"type\":[\"null\",\"float\"],\"doc\":\"Average Swim Cadence in strokes per minute.\",\"default\":null},{\"name\":\"averagePace\",\"type\":[\"null\",\"float\"],\"doc\":\"Average Pace in minutes per kilometer.\",\"default\":null},{\"name\":\"maxPace\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum Pace in minutes per kilometer.\",\"default\":null},{\"name\":\"numberOfActiveLengths\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of Active Lengths.\",\"default\":null},{\"name\":\"averageHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Average of heart rate values captured during the last 7 days, in beats per minute. The average heart rate value for the monitoring period can be calculated based on the data from timeOffsetHeartRateSamples.\",\"default\":null},{\"name\":\"maxHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Maximum of heart rate values captured during the monitoring period, in beats per minute.\",\"default\":null},{\"name\":\"startingLatitude\",\"type\":[\"null\",\"float\"],\"doc\":\"Starting Latitude in Degree.\",\"default\":null},{\"name\":\"startingLongitude\",\"type\":[\"null\",\"float\"],\"doc\":\"Starting Longitude in Degree.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"int\"],\"doc\":\"Count of steps recorded during the monitoring period.\",\"default\":null},{\"name\":\"totalElevationGain\",\"type\":[\"null\",\"float\"],\"doc\":\"Total Elevation Gain in meters.\",\"default\":null},{\"name\":\"totalElevationLoss\",\"type\":[\"null\",\"float\"],\"doc\":\"Total Elevation Loss in meters.\",\"default\":null},{\"name\":\"isParent\",\"type\":[\"null\",\"boolean\"],\"doc\":\"If present and set to true, this activity is the parent activity of one or more child activities that should also be made available in the data feed to the partner. An activity of type MULTI_SPORT is an example of a parent activity.\",\"default\":null},{\"name\":\"parentSummaryId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"If present, this is the summaryId of the related parent activity. An activity of type CYCLING with a parent activity of type MULTI_SPORT is an example of this type of relationship.\",\"default\":null},{\"name\":\"manual\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Indicates that the activity was manually entered directly on the Connect site. This property will only exist for manual activities.\",\"default\":null},{\"name\":\"deviceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Only Fitness Activities are associated with a specific Garmin device rather than the user\u2019s overall account. If a user wears two devices at once during the same time and starts a Fitness Activity on each then both will generate separate Activity summaries with two different deviceNames. Always \u2018unknown\u2019 for manually created activities.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminActivitySummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminActivitySummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private Integer startTimeOffset;
    private String activityType;
    private Integer duration;
    private Float averageBikeCadence;
    private Float maxBikeCadence;
    private Float distance;
    private Float averageRunCadence;
    private Float maxRunCadence;
    private Integer activeKilocalories;
    private Float averageSpeed;
    private Float maxSpeed;
    private Float averageSwimCadence;
    private Float averagePace;
    private Float maxPace;
    private Integer numberOfActiveLengths;
    private Integer averageHeartRate;
    private Integer maxHeartRate;
    private Float startingLatitude;
    private Float startingLongitude;
    private Integer steps;
    private Float totalElevationGain;
    private Float totalElevationLoss;
    private Boolean isParent;
    private String parentSummaryId;
    private Boolean manual;
    private String deviceName;
    private static final DatumWriter<GarminActivitySummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminActivitySummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminActivitySummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminActivitySummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminActivitySummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminActivitySummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminActivitySummary)((Object)DECODER.decode(b));
    }

    public GarminActivitySummary() {
    }

    public GarminActivitySummary(Double time, Double timeReceived, String summaryId, Integer startTimeOffset, String activityType, Integer duration, Float averageBikeCadence, Float maxBikeCadence, Float distance, Float averageRunCadence, Float maxRunCadence, Integer activeKilocalories, Float averageSpeed, Float maxSpeed, Float averageSwimCadence, Float averagePace, Float maxPace, Integer numberOfActiveLengths, Integer averageHeartRate, Integer maxHeartRate, Float startingLatitude, Float startingLongitude, Integer steps, Float totalElevationGain, Float totalElevationLoss, Boolean isParent, String parentSummaryId, Boolean manual, String deviceName) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.startTimeOffset = startTimeOffset;
        this.activityType = activityType;
        this.duration = duration;
        this.averageBikeCadence = averageBikeCadence;
        this.maxBikeCadence = maxBikeCadence;
        this.distance = distance;
        this.averageRunCadence = averageRunCadence;
        this.maxRunCadence = maxRunCadence;
        this.activeKilocalories = activeKilocalories;
        this.averageSpeed = averageSpeed;
        this.maxSpeed = maxSpeed;
        this.averageSwimCadence = averageSwimCadence;
        this.averagePace = averagePace;
        this.maxPace = maxPace;
        this.numberOfActiveLengths = numberOfActiveLengths;
        this.averageHeartRate = averageHeartRate;
        this.maxHeartRate = maxHeartRate;
        this.startingLatitude = startingLatitude;
        this.startingLongitude = startingLongitude;
        this.steps = steps;
        this.totalElevationGain = totalElevationGain;
        this.totalElevationLoss = totalElevationLoss;
        this.isParent = isParent;
        this.parentSummaryId = parentSummaryId;
        this.manual = manual;
        this.deviceName = deviceName;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.startTimeOffset;
            }
            case 4: {
                return this.activityType;
            }
            case 5: {
                return this.duration;
            }
            case 6: {
                return this.averageBikeCadence;
            }
            case 7: {
                return this.maxBikeCadence;
            }
            case 8: {
                return this.distance;
            }
            case 9: {
                return this.averageRunCadence;
            }
            case 10: {
                return this.maxRunCadence;
            }
            case 11: {
                return this.activeKilocalories;
            }
            case 12: {
                return this.averageSpeed;
            }
            case 13: {
                return this.maxSpeed;
            }
            case 14: {
                return this.averageSwimCadence;
            }
            case 15: {
                return this.averagePace;
            }
            case 16: {
                return this.maxPace;
            }
            case 17: {
                return this.numberOfActiveLengths;
            }
            case 18: {
                return this.averageHeartRate;
            }
            case 19: {
                return this.maxHeartRate;
            }
            case 20: {
                return this.startingLatitude;
            }
            case 21: {
                return this.startingLongitude;
            }
            case 22: {
                return this.steps;
            }
            case 23: {
                return this.totalElevationGain;
            }
            case 24: {
                return this.totalElevationLoss;
            }
            case 25: {
                return this.isParent;
            }
            case 26: {
                return this.parentSummaryId;
            }
            case 27: {
                return this.manual;
            }
            case 28: {
                return this.deviceName;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 4: {
                this.activityType = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.duration = (Integer)value$;
                break;
            }
            case 6: {
                this.averageBikeCadence = (Float)value$;
                break;
            }
            case 7: {
                this.maxBikeCadence = (Float)value$;
                break;
            }
            case 8: {
                this.distance = (Float)value$;
                break;
            }
            case 9: {
                this.averageRunCadence = (Float)value$;
                break;
            }
            case 10: {
                this.maxRunCadence = (Float)value$;
                break;
            }
            case 11: {
                this.activeKilocalories = (Integer)value$;
                break;
            }
            case 12: {
                this.averageSpeed = (Float)value$;
                break;
            }
            case 13: {
                this.maxSpeed = (Float)value$;
                break;
            }
            case 14: {
                this.averageSwimCadence = (Float)value$;
                break;
            }
            case 15: {
                this.averagePace = (Float)value$;
                break;
            }
            case 16: {
                this.maxPace = (Float)value$;
                break;
            }
            case 17: {
                this.numberOfActiveLengths = (Integer)value$;
                break;
            }
            case 18: {
                this.averageHeartRate = (Integer)value$;
                break;
            }
            case 19: {
                this.maxHeartRate = (Integer)value$;
                break;
            }
            case 20: {
                this.startingLatitude = (Float)value$;
                break;
            }
            case 21: {
                this.startingLongitude = (Float)value$;
                break;
            }
            case 22: {
                this.steps = (Integer)value$;
                break;
            }
            case 23: {
                this.totalElevationGain = (Float)value$;
                break;
            }
            case 24: {
                this.totalElevationLoss = (Float)value$;
                break;
            }
            case 25: {
                this.isParent = (Boolean)value$;
                break;
            }
            case 26: {
                this.parentSummaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 27: {
                this.manual = (Boolean)value$;
                break;
            }
            case 28: {
                this.deviceName = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String value) {
        this.activityType = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public Float getAverageBikeCadence() {
        return this.averageBikeCadence;
    }

    public void setAverageBikeCadence(Float value) {
        this.averageBikeCadence = value;
    }

    public Float getMaxBikeCadence() {
        return this.maxBikeCadence;
    }

    public void setMaxBikeCadence(Float value) {
        this.maxBikeCadence = value;
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(Float value) {
        this.distance = value;
    }

    public Float getAverageRunCadence() {
        return this.averageRunCadence;
    }

    public void setAverageRunCadence(Float value) {
        this.averageRunCadence = value;
    }

    public Float getMaxRunCadence() {
        return this.maxRunCadence;
    }

    public void setMaxRunCadence(Float value) {
        this.maxRunCadence = value;
    }

    public Integer getActiveKilocalories() {
        return this.activeKilocalories;
    }

    public void setActiveKilocalories(Integer value) {
        this.activeKilocalories = value;
    }

    public Float getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(Float value) {
        this.averageSpeed = value;
    }

    public Float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(Float value) {
        this.maxSpeed = value;
    }

    public Float getAverageSwimCadence() {
        return this.averageSwimCadence;
    }

    public void setAverageSwimCadence(Float value) {
        this.averageSwimCadence = value;
    }

    public Float getAveragePace() {
        return this.averagePace;
    }

    public void setAveragePace(Float value) {
        this.averagePace = value;
    }

    public Float getMaxPace() {
        return this.maxPace;
    }

    public void setMaxPace(Float value) {
        this.maxPace = value;
    }

    public Integer getNumberOfActiveLengths() {
        return this.numberOfActiveLengths;
    }

    public void setNumberOfActiveLengths(Integer value) {
        this.numberOfActiveLengths = value;
    }

    public Integer getAverageHeartRate() {
        return this.averageHeartRate;
    }

    public void setAverageHeartRate(Integer value) {
        this.averageHeartRate = value;
    }

    public Integer getMaxHeartRate() {
        return this.maxHeartRate;
    }

    public void setMaxHeartRate(Integer value) {
        this.maxHeartRate = value;
    }

    public Float getStartingLatitude() {
        return this.startingLatitude;
    }

    public void setStartingLatitude(Float value) {
        this.startingLatitude = value;
    }

    public Float getStartingLongitude() {
        return this.startingLongitude;
    }

    public void setStartingLongitude(Float value) {
        this.startingLongitude = value;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer value) {
        this.steps = value;
    }

    public Float getTotalElevationGain() {
        return this.totalElevationGain;
    }

    public void setTotalElevationGain(Float value) {
        this.totalElevationGain = value;
    }

    public Float getTotalElevationLoss() {
        return this.totalElevationLoss;
    }

    public void setTotalElevationLoss(Float value) {
        this.totalElevationLoss = value;
    }

    public Boolean getIsParent() {
        return this.isParent;
    }

    public void setIsParent(Boolean value) {
        this.isParent = value;
    }

    public String getParentSummaryId() {
        return this.parentSummaryId;
    }

    public void setParentSummaryId(String value) {
        this.parentSummaryId = value;
    }

    public Boolean getManual() {
        return this.manual;
    }

    public void setManual(Boolean value) {
        this.manual = value;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String value) {
        this.deviceName = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminActivitySummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.activityType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activityType);
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
        if (this.averageBikeCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageBikeCadence.floatValue());
        }
        if (this.maxBikeCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxBikeCadence.floatValue());
        }
        if (this.distance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distance.floatValue());
        }
        if (this.averageRunCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageRunCadence.floatValue());
        }
        if (this.maxRunCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxRunCadence.floatValue());
        }
        if (this.activeKilocalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeKilocalories.intValue());
        }
        if (this.averageSpeed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageSpeed.floatValue());
        }
        if (this.maxSpeed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxSpeed.floatValue());
        }
        if (this.averageSwimCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageSwimCadence.floatValue());
        }
        if (this.averagePace == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averagePace.floatValue());
        }
        if (this.maxPace == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxPace.floatValue());
        }
        if (this.numberOfActiveLengths == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.numberOfActiveLengths.intValue());
        }
        if (this.averageHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.averageHeartRate.intValue());
        }
        if (this.maxHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.maxHeartRate.intValue());
        }
        if (this.startingLatitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.startingLatitude.floatValue());
        }
        if (this.startingLongitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.startingLongitude.floatValue());
        }
        if (this.steps == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.steps.intValue());
        }
        if (this.totalElevationGain == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.totalElevationGain.floatValue());
        }
        if (this.totalElevationLoss == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.totalElevationLoss.floatValue());
        }
        if (this.isParent == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.isParent.booleanValue());
        }
        if (this.parentSummaryId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.parentSummaryId);
        }
        if (this.manual == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.manual.booleanValue());
        }
        if (this.deviceName == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.deviceName);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activityType = null;
            } else {
                this.activityType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageBikeCadence = null;
            } else {
                this.averageBikeCadence = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxBikeCadence = null;
            } else {
                this.maxBikeCadence = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distance = null;
            } else {
                this.distance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageRunCadence = null;
            } else {
                this.averageRunCadence = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxRunCadence = null;
            } else {
                this.maxRunCadence = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeKilocalories = null;
            } else {
                this.activeKilocalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageSpeed = null;
            } else {
                this.averageSpeed = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxSpeed = null;
            } else {
                this.maxSpeed = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageSwimCadence = null;
            } else {
                this.averageSwimCadence = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averagePace = null;
            } else {
                this.averagePace = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxPace = null;
            } else {
                this.maxPace = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.numberOfActiveLengths = null;
            } else {
                this.numberOfActiveLengths = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageHeartRate = null;
            } else {
                this.averageHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxHeartRate = null;
            } else {
                this.maxHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startingLatitude = null;
            } else {
                this.startingLatitude = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startingLongitude = null;
            } else {
                this.startingLongitude = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.steps = null;
            } else {
                this.steps = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalElevationGain = null;
            } else {
                this.totalElevationGain = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalElevationLoss = null;
            } else {
                this.totalElevationLoss = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.isParent = null;
            } else {
                this.isParent = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.parentSummaryId = null;
            } else {
                this.parentSummaryId = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.manual = null;
            } else {
                this.manual = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.deviceName = null;
            } else {
                this.deviceName = in.readString();
            }
        } else {
            block31: for (int i = 0; i < 29; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block31;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block31;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block31;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block31;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block31;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activityType = null;
                            continue block31;
                        }
                        this.activityType = in.readString();
                        continue block31;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block31;
                        }
                        this.duration = in.readInt();
                        continue block31;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageBikeCadence = null;
                            continue block31;
                        }
                        this.averageBikeCadence = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxBikeCadence = null;
                            continue block31;
                        }
                        this.maxBikeCadence = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distance = null;
                            continue block31;
                        }
                        this.distance = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageRunCadence = null;
                            continue block31;
                        }
                        this.averageRunCadence = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxRunCadence = null;
                            continue block31;
                        }
                        this.maxRunCadence = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeKilocalories = null;
                            continue block31;
                        }
                        this.activeKilocalories = in.readInt();
                        continue block31;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageSpeed = null;
                            continue block31;
                        }
                        this.averageSpeed = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxSpeed = null;
                            continue block31;
                        }
                        this.maxSpeed = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageSwimCadence = null;
                            continue block31;
                        }
                        this.averageSwimCadence = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averagePace = null;
                            continue block31;
                        }
                        this.averagePace = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxPace = null;
                            continue block31;
                        }
                        this.maxPace = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.numberOfActiveLengths = null;
                            continue block31;
                        }
                        this.numberOfActiveLengths = in.readInt();
                        continue block31;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageHeartRate = null;
                            continue block31;
                        }
                        this.averageHeartRate = in.readInt();
                        continue block31;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxHeartRate = null;
                            continue block31;
                        }
                        this.maxHeartRate = in.readInt();
                        continue block31;
                    }
                    case 20: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startingLatitude = null;
                            continue block31;
                        }
                        this.startingLatitude = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startingLongitude = null;
                            continue block31;
                        }
                        this.startingLongitude = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 22: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.steps = null;
                            continue block31;
                        }
                        this.steps = in.readInt();
                        continue block31;
                    }
                    case 23: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalElevationGain = null;
                            continue block31;
                        }
                        this.totalElevationGain = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 24: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalElevationLoss = null;
                            continue block31;
                        }
                        this.totalElevationLoss = Float.valueOf(in.readFloat());
                        continue block31;
                    }
                    case 25: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isParent = null;
                            continue block31;
                        }
                        this.isParent = in.readBoolean();
                        continue block31;
                    }
                    case 26: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.parentSummaryId = null;
                            continue block31;
                        }
                        this.parentSummaryId = in.readString();
                        continue block31;
                    }
                    case 27: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.manual = null;
                            continue block31;
                        }
                        this.manual = in.readBoolean();
                        continue block31;
                    }
                    case 28: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deviceName = null;
                            continue block31;
                        }
                        this.deviceName = in.readString();
                        continue block31;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminActivitySummary>
    implements RecordBuilder<GarminActivitySummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Integer startTimeOffset;
        private String activityType;
        private Integer duration;
        private Float averageBikeCadence;
        private Float maxBikeCadence;
        private Float distance;
        private Float averageRunCadence;
        private Float maxRunCadence;
        private Integer activeKilocalories;
        private Float averageSpeed;
        private Float maxSpeed;
        private Float averageSwimCadence;
        private Float averagePace;
        private Float maxPace;
        private Integer numberOfActiveLengths;
        private Integer averageHeartRate;
        private Integer maxHeartRate;
        private Float startingLatitude;
        private Float startingLongitude;
        private Integer steps;
        private Float totalElevationGain;
        private Float totalElevationLoss;
        private Boolean isParent;
        private String parentSummaryId;
        private Boolean manual;
        private String deviceName;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activityType);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.averageBikeCadence)) {
                this.averageBikeCadence = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.averageBikeCadence);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.maxBikeCadence)) {
                this.maxBikeCadence = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.maxBikeCadence);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.distance);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.averageRunCadence)) {
                this.averageRunCadence = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.averageRunCadence);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.maxRunCadence)) {
                this.maxRunCadence = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.maxRunCadence);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.averageSpeed)) {
                this.averageSpeed = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.averageSpeed);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.maxSpeed)) {
                this.maxSpeed = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.maxSpeed);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.averageSwimCadence)) {
                this.averageSwimCadence = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.averageSwimCadence);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.averagePace)) {
                this.averagePace = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.averagePace);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.maxPace)) {
                this.maxPace = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.maxPace);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.numberOfActiveLengths)) {
                this.numberOfActiveLengths = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.numberOfActiveLengths);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.maxHeartRate)) {
                this.maxHeartRate = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.maxHeartRate);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.startingLatitude)) {
                this.startingLatitude = (Float)this.data().deepCopy(this.fields()[20].schema(), (Object)other.startingLatitude);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.startingLongitude)) {
                this.startingLongitude = (Float)this.data().deepCopy(this.fields()[21].schema(), (Object)other.startingLongitude);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.steps);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.totalElevationGain)) {
                this.totalElevationGain = (Float)this.data().deepCopy(this.fields()[23].schema(), (Object)other.totalElevationGain);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.totalElevationLoss)) {
                this.totalElevationLoss = (Float)this.data().deepCopy(this.fields()[24].schema(), (Object)other.totalElevationLoss);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.isParent)) {
                this.isParent = (Boolean)this.data().deepCopy(this.fields()[25].schema(), (Object)other.isParent);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.parentSummaryId)) {
                this.parentSummaryId = (String)this.data().deepCopy(this.fields()[26].schema(), (Object)other.parentSummaryId);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.manual)) {
                this.manual = (Boolean)this.data().deepCopy(this.fields()[27].schema(), (Object)other.manual);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.deviceName)) {
                this.deviceName = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.deviceName);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
        }

        private Builder(GarminActivitySummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activityType);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.averageBikeCadence)) {
                this.averageBikeCadence = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.averageBikeCadence);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.maxBikeCadence)) {
                this.maxBikeCadence = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.maxBikeCadence);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.distance);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.averageRunCadence)) {
                this.averageRunCadence = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.averageRunCadence);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.maxRunCadence)) {
                this.maxRunCadence = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.maxRunCadence);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.averageSpeed)) {
                this.averageSpeed = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.averageSpeed);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.maxSpeed)) {
                this.maxSpeed = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.maxSpeed);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.averageSwimCadence)) {
                this.averageSwimCadence = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.averageSwimCadence);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.averagePace)) {
                this.averagePace = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.averagePace);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.maxPace)) {
                this.maxPace = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.maxPace);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.numberOfActiveLengths)) {
                this.numberOfActiveLengths = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.numberOfActiveLengths);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.maxHeartRate)) {
                this.maxHeartRate = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.maxHeartRate);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.startingLatitude)) {
                this.startingLatitude = (Float)this.data().deepCopy(this.fields()[20].schema(), (Object)other.startingLatitude);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.startingLongitude)) {
                this.startingLongitude = (Float)this.data().deepCopy(this.fields()[21].schema(), (Object)other.startingLongitude);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.steps);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.totalElevationGain)) {
                this.totalElevationGain = (Float)this.data().deepCopy(this.fields()[23].schema(), (Object)other.totalElevationGain);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.totalElevationLoss)) {
                this.totalElevationLoss = (Float)this.data().deepCopy(this.fields()[24].schema(), (Object)other.totalElevationLoss);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.isParent)) {
                this.isParent = (Boolean)this.data().deepCopy(this.fields()[25].schema(), (Object)other.isParent);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.parentSummaryId)) {
                this.parentSummaryId = (String)this.data().deepCopy(this.fields()[26].schema(), (Object)other.parentSummaryId);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.manual)) {
                this.manual = (Boolean)this.data().deepCopy(this.fields()[27].schema(), (Object)other.manual);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.deviceName)) {
                this.deviceName = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.deviceName);
                this.fieldSetFlags()[28] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[3], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getActivityType() {
            return this.activityType;
        }

        public Builder setActivityType(String value) {
            this.validate(this.fields()[4], value);
            this.activityType = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasActivityType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearActivityType() {
            this.activityType = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[5], value);
            this.duration = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getAverageBikeCadence() {
            return this.averageBikeCadence;
        }

        public Builder setAverageBikeCadence(Float value) {
            this.validate(this.fields()[6], value);
            this.averageBikeCadence = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAverageBikeCadence() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAverageBikeCadence() {
            this.averageBikeCadence = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getMaxBikeCadence() {
            return this.maxBikeCadence;
        }

        public Builder setMaxBikeCadence(Float value) {
            this.validate(this.fields()[7], value);
            this.maxBikeCadence = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasMaxBikeCadence() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearMaxBikeCadence() {
            this.maxBikeCadence = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getDistance() {
            return this.distance;
        }

        public Builder setDistance(Float value) {
            this.validate(this.fields()[8], value);
            this.distance = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getAverageRunCadence() {
            return this.averageRunCadence;
        }

        public Builder setAverageRunCadence(Float value) {
            this.validate(this.fields()[9], value);
            this.averageRunCadence = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasAverageRunCadence() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearAverageRunCadence() {
            this.averageRunCadence = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Float getMaxRunCadence() {
            return this.maxRunCadence;
        }

        public Builder setMaxRunCadence(Float value) {
            this.validate(this.fields()[10], value);
            this.maxRunCadence = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasMaxRunCadence() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearMaxRunCadence() {
            this.maxRunCadence = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getActiveKilocalories() {
            return this.activeKilocalories;
        }

        public Builder setActiveKilocalories(Integer value) {
            this.validate(this.fields()[11], value);
            this.activeKilocalories = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasActiveKilocalories() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearActiveKilocalories() {
            this.activeKilocalories = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getAverageSpeed() {
            return this.averageSpeed;
        }

        public Builder setAverageSpeed(Float value) {
            this.validate(this.fields()[12], value);
            this.averageSpeed = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasAverageSpeed() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearAverageSpeed() {
            this.averageSpeed = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Float getMaxSpeed() {
            return this.maxSpeed;
        }

        public Builder setMaxSpeed(Float value) {
            this.validate(this.fields()[13], value);
            this.maxSpeed = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasMaxSpeed() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearMaxSpeed() {
            this.maxSpeed = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Float getAverageSwimCadence() {
            return this.averageSwimCadence;
        }

        public Builder setAverageSwimCadence(Float value) {
            this.validate(this.fields()[14], value);
            this.averageSwimCadence = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasAverageSwimCadence() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearAverageSwimCadence() {
            this.averageSwimCadence = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Float getAveragePace() {
            return this.averagePace;
        }

        public Builder setAveragePace(Float value) {
            this.validate(this.fields()[15], value);
            this.averagePace = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasAveragePace() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearAveragePace() {
            this.averagePace = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getMaxPace() {
            return this.maxPace;
        }

        public Builder setMaxPace(Float value) {
            this.validate(this.fields()[16], value);
            this.maxPace = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasMaxPace() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearMaxPace() {
            this.maxPace = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getNumberOfActiveLengths() {
            return this.numberOfActiveLengths;
        }

        public Builder setNumberOfActiveLengths(Integer value) {
            this.validate(this.fields()[17], value);
            this.numberOfActiveLengths = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasNumberOfActiveLengths() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearNumberOfActiveLengths() {
            this.numberOfActiveLengths = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Integer getAverageHeartRate() {
            return this.averageHeartRate;
        }

        public Builder setAverageHeartRate(Integer value) {
            this.validate(this.fields()[18], value);
            this.averageHeartRate = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasAverageHeartRate() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearAverageHeartRate() {
            this.averageHeartRate = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Integer getMaxHeartRate() {
            return this.maxHeartRate;
        }

        public Builder setMaxHeartRate(Integer value) {
            this.validate(this.fields()[19], value);
            this.maxHeartRate = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasMaxHeartRate() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearMaxHeartRate() {
            this.maxHeartRate = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Float getStartingLatitude() {
            return this.startingLatitude;
        }

        public Builder setStartingLatitude(Float value) {
            this.validate(this.fields()[20], value);
            this.startingLatitude = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasStartingLatitude() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearStartingLatitude() {
            this.startingLatitude = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Float getStartingLongitude() {
            return this.startingLongitude;
        }

        public Builder setStartingLongitude(Float value) {
            this.validate(this.fields()[21], value);
            this.startingLongitude = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasStartingLongitude() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearStartingLongitude() {
            this.startingLongitude = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Integer getSteps() {
            return this.steps;
        }

        public Builder setSteps(Integer value) {
            this.validate(this.fields()[22], value);
            this.steps = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasSteps() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearSteps() {
            this.steps = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Float getTotalElevationGain() {
            return this.totalElevationGain;
        }

        public Builder setTotalElevationGain(Float value) {
            this.validate(this.fields()[23], value);
            this.totalElevationGain = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasTotalElevationGain() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearTotalElevationGain() {
            this.totalElevationGain = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Float getTotalElevationLoss() {
            return this.totalElevationLoss;
        }

        public Builder setTotalElevationLoss(Float value) {
            this.validate(this.fields()[24], value);
            this.totalElevationLoss = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasTotalElevationLoss() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearTotalElevationLoss() {
            this.totalElevationLoss = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Boolean getIsParent() {
            return this.isParent;
        }

        public Builder setIsParent(Boolean value) {
            this.validate(this.fields()[25], value);
            this.isParent = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasIsParent() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearIsParent() {
            this.isParent = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public String getParentSummaryId() {
            return this.parentSummaryId;
        }

        public Builder setParentSummaryId(String value) {
            this.validate(this.fields()[26], value);
            this.parentSummaryId = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasParentSummaryId() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearParentSummaryId() {
            this.parentSummaryId = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Boolean getManual() {
            return this.manual;
        }

        public Builder setManual(Boolean value) {
            this.validate(this.fields()[27], value);
            this.manual = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasManual() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearManual() {
            this.manual = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public Builder setDeviceName(String value) {
            this.validate(this.fields()[28], value);
            this.deviceName = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasDeviceName() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearDeviceName() {
            this.deviceName = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public GarminActivitySummary build() {
            try {
                GarminActivitySummary record = new GarminActivitySummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.startTimeOffset = this.fieldSetFlags()[3] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[3]);
                record.activityType = this.fieldSetFlags()[4] ? this.activityType : (String)this.defaultValue(this.fields()[4]);
                record.duration = this.fieldSetFlags()[5] ? this.duration : (Integer)this.defaultValue(this.fields()[5]);
                record.averageBikeCadence = this.fieldSetFlags()[6] ? this.averageBikeCadence : (Float)this.defaultValue(this.fields()[6]);
                record.maxBikeCadence = this.fieldSetFlags()[7] ? this.maxBikeCadence : (Float)this.defaultValue(this.fields()[7]);
                record.distance = this.fieldSetFlags()[8] ? this.distance : (Float)this.defaultValue(this.fields()[8]);
                record.averageRunCadence = this.fieldSetFlags()[9] ? this.averageRunCadence : (Float)this.defaultValue(this.fields()[9]);
                record.maxRunCadence = this.fieldSetFlags()[10] ? this.maxRunCadence : (Float)this.defaultValue(this.fields()[10]);
                record.activeKilocalories = this.fieldSetFlags()[11] ? this.activeKilocalories : (Integer)this.defaultValue(this.fields()[11]);
                record.averageSpeed = this.fieldSetFlags()[12] ? this.averageSpeed : (Float)this.defaultValue(this.fields()[12]);
                record.maxSpeed = this.fieldSetFlags()[13] ? this.maxSpeed : (Float)this.defaultValue(this.fields()[13]);
                record.averageSwimCadence = this.fieldSetFlags()[14] ? this.averageSwimCadence : (Float)this.defaultValue(this.fields()[14]);
                record.averagePace = this.fieldSetFlags()[15] ? this.averagePace : (Float)this.defaultValue(this.fields()[15]);
                record.maxPace = this.fieldSetFlags()[16] ? this.maxPace : (Float)this.defaultValue(this.fields()[16]);
                record.numberOfActiveLengths = this.fieldSetFlags()[17] ? this.numberOfActiveLengths : (Integer)this.defaultValue(this.fields()[17]);
                record.averageHeartRate = this.fieldSetFlags()[18] ? this.averageHeartRate : (Integer)this.defaultValue(this.fields()[18]);
                record.maxHeartRate = this.fieldSetFlags()[19] ? this.maxHeartRate : (Integer)this.defaultValue(this.fields()[19]);
                record.startingLatitude = this.fieldSetFlags()[20] ? this.startingLatitude : (Float)this.defaultValue(this.fields()[20]);
                record.startingLongitude = this.fieldSetFlags()[21] ? this.startingLongitude : (Float)this.defaultValue(this.fields()[21]);
                record.steps = this.fieldSetFlags()[22] ? this.steps : (Integer)this.defaultValue(this.fields()[22]);
                record.totalElevationGain = this.fieldSetFlags()[23] ? this.totalElevationGain : (Float)this.defaultValue(this.fields()[23]);
                record.totalElevationLoss = this.fieldSetFlags()[24] ? this.totalElevationLoss : (Float)this.defaultValue(this.fields()[24]);
                record.isParent = this.fieldSetFlags()[25] ? this.isParent : (Boolean)this.defaultValue(this.fields()[25]);
                record.parentSummaryId = this.fieldSetFlags()[26] ? this.parentSummaryId : (String)this.defaultValue(this.fields()[26]);
                record.manual = this.fieldSetFlags()[27] ? this.manual : (Boolean)this.defaultValue(this.fields()[27]);
                record.deviceName = this.fieldSetFlags()[28] ? this.deviceName : (String)this.defaultValue(this.fields()[28]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

