/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminUserMetrics
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4674764843396713801L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminUserMetrics\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"User Metrics are per-user calculations performed by Garmin based on the underlying data uploaded from the user\u2019s device. This data can be specific to a single device and field availability is dependent on device model support. Unlike other summaries, User Metrics are associated only with a calendar date, not a specific time frame, and only the most recent value for any fields is presented to the user. Each metric directly corresponds to the similarly named field found in Garmin Connect.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"vo2Max\",\"type\":[\"null\",\"float\"],\"doc\":\"An estimate of the maximum volume of oxygen (in milliliters) the user can consume per minute per kilogram of body weight at maximum performance.\",\"default\":null},{\"name\":\"fitnessAge\",\"type\":[\"null\",\"int\"],\"doc\":\"An estimation of the \u2018age\u2019 of the user\u2019s fitness level, calculated by comparing internal fitness metrics with the average readings of biometrically similar users by age. For instance, a fitness age of 48 indicates that the user\u2019s physical fitness is similar to that of an average 48- year-old person of the same gender.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminUserMetrics> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminUserMetrics> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Float vo2Max;
    private Integer fitnessAge;
    private static final DatumWriter<GarminUserMetrics> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminUserMetrics> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminUserMetrics> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminUserMetrics> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminUserMetrics> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminUserMetrics fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminUserMetrics)((Object)DECODER.decode(b));
    }

    public GarminUserMetrics() {
    }

    public GarminUserMetrics(Double time, Double timeReceived, String summaryId, String date, Float vo2Max, Integer fitnessAge) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.vo2Max = vo2Max;
        this.fitnessAge = fitnessAge;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.vo2Max;
            }
            case 5: {
                return this.fitnessAge;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.vo2Max = (Float)value$;
                break;
            }
            case 5: {
                this.fitnessAge = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Float getVo2Max() {
        return this.vo2Max;
    }

    public void setVo2Max(Float value) {
        this.vo2Max = value;
    }

    public Integer getFitnessAge() {
        return this.fitnessAge;
    }

    public void setFitnessAge(Integer value) {
        this.fitnessAge = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminUserMetrics other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.vo2Max == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.vo2Max.floatValue());
        }
        if (this.fitnessAge == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.fitnessAge.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.vo2Max = null;
            } else {
                this.vo2Max = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fitnessAge = null;
            } else {
                this.fitnessAge = in.readInt();
            }
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block8;
                        }
                        this.date = in.readString();
                        continue block8;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.vo2Max = null;
                            continue block8;
                        }
                        this.vo2Max = Float.valueOf(in.readFloat());
                        continue block8;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fitnessAge = null;
                            continue block8;
                        }
                        this.fitnessAge = in.readInt();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminUserMetrics>
    implements RecordBuilder<GarminUserMetrics> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Float vo2Max;
        private Integer fitnessAge;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.vo2Max)) {
                this.vo2Max = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.vo2Max);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.fitnessAge)) {
                this.fitnessAge = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.fitnessAge);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(GarminUserMetrics other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.vo2Max)) {
                this.vo2Max = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.vo2Max);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.fitnessAge)) {
                this.fitnessAge = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.fitnessAge);
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getVo2Max() {
            return this.vo2Max;
        }

        public Builder setVo2Max(Float value) {
            this.validate(this.fields()[4], value);
            this.vo2Max = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasVo2Max() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearVo2Max() {
            this.vo2Max = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getFitnessAge() {
            return this.fitnessAge;
        }

        public Builder setFitnessAge(Integer value) {
            this.validate(this.fields()[5], value);
            this.fitnessAge = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFitnessAge() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFitnessAge() {
            this.fitnessAge = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public GarminUserMetrics build() {
            try {
                GarminUserMetrics record = new GarminUserMetrics();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.vo2Max = this.fieldSetFlags()[4] ? this.vo2Max : (Float)this.defaultValue(this.fields()[4]);
                record.fitnessAge = this.fieldSetFlags()[5] ? this.fitnessAge : (Integer)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

