/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.active.banking;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.active.banking.TransactionResult;

@AvroGenerated
public class BankingTransaction
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6488688125886118340L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BankingTransaction\",\"namespace\":\"org.radarcns.active.banking\",\"doc\":\"Transaction in Banking App. This captures a full transaction: inputting a PIN number, then an amount and then a confirmation or cancellation. A transaction may also time out or end prematurely.\",\"fields\":[{\"name\":\"transactionId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique ID for an Transaction.\"},{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), time stores the time a transaction has started.\"},{\"name\":\"timeCompleted\",\"type\":\"double\",\"doc\":\"Time stores the time a transaction has been completed.\"},{\"name\":\"duration\",\"type\":\"double\",\"doc\":\"Duration of the transaction (seconds), duration is essentially timeCompleted - time.\"},{\"name\":\"isComplete\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if the result is CORRECT_CONFIRMED, WRONG_CONFIRMED, CORRECT_CANCELLED or WRONG_CANCELLED. False if TIME_OUT or EXIT.\",\"default\":null},{\"name\":\"transactionResult\",\"type\":{\"type\":\"enum\",\"name\":\"TransactionResult\",\"doc\":\"CORRECT_CONFIRMED: both inputs Correct- Confirmed Transaction, CORRECT_CANCELLED: Correct inputs - Cancelled Transaction, WRONG_CONFIRMED:   (at least one of two inputs Wrong) - Confirmed Transaction, WRONG_CANCELLED: Wrong input Cancelled Transaction, TIME_OUT: Transaction timed Out, EXIT: Transaction Ended prematurely.\",\"symbols\":[\"CORRECT_CONFIRMED\",\"CORRECT_CANCELLED\",\"WRONG_CONFIRMED\",\"WRONG_CANCELLED\",\"TIME_OUT\",\"EXIT\",\"UNKNOWN\"]},\"doc\":\"Shows the result of the Transaction which can be Correct Cancelled, Correct Cancelled, Wrong Confirmed, Wrong Cancelled, Timed Out, Ended.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BankingTransaction> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BankingTransaction> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String transactionId;
    private double time;
    private double timeCompleted;
    private double duration;
    private Boolean isComplete;
    private TransactionResult transactionResult;
    private static final DatumWriter<BankingTransaction> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BankingTransaction> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BankingTransaction> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BankingTransaction> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BankingTransaction> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BankingTransaction fromByteBuffer(ByteBuffer b) throws IOException {
        return (BankingTransaction)((Object)DECODER.decode(b));
    }

    public BankingTransaction() {
    }

    public BankingTransaction(String transactionId, Double time, Double timeCompleted, Double duration, Boolean isComplete, TransactionResult transactionResult) {
        this.transactionId = transactionId;
        this.time = time;
        this.timeCompleted = timeCompleted;
        this.duration = duration;
        this.isComplete = isComplete;
        this.transactionResult = transactionResult;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.transactionId;
            }
            case 1: {
                return this.time;
            }
            case 2: {
                return this.timeCompleted;
            }
            case 3: {
                return this.duration;
            }
            case 4: {
                return this.isComplete;
            }
            case 5: {
                return this.transactionResult;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.transactionId = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.time = (Double)value$;
                break;
            }
            case 2: {
                this.timeCompleted = (Double)value$;
                break;
            }
            case 3: {
                this.duration = (Double)value$;
                break;
            }
            case 4: {
                this.isComplete = (Boolean)value$;
                break;
            }
            case 5: {
                this.transactionResult = (TransactionResult)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String value) {
        this.transactionId = value;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(double value) {
        this.timeCompleted = value;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double value) {
        this.duration = value;
    }

    public Boolean getIsComplete() {
        return this.isComplete;
    }

    public void setIsComplete(Boolean value) {
        this.isComplete = value;
    }

    public TransactionResult getTransactionResult() {
        return this.transactionResult;
    }

    public void setTransactionResult(TransactionResult value) {
        this.transactionResult = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BankingTransaction other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.transactionId);
        out.writeDouble(this.time);
        out.writeDouble(this.timeCompleted);
        out.writeDouble(this.duration);
        if (this.isComplete == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.isComplete.booleanValue());
        }
        out.writeEnum(this.transactionResult.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.transactionId = in.readString();
            this.time = in.readDouble();
            this.timeCompleted = in.readDouble();
            this.duration = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.isComplete = null;
            } else {
                this.isComplete = in.readBoolean();
            }
            this.transactionResult = TransactionResult.values()[in.readEnum()];
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.transactionId = in.readString();
                        continue block8;
                    }
                    case 1: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.timeCompleted = in.readDouble();
                        continue block8;
                    }
                    case 3: {
                        this.duration = in.readDouble();
                        continue block8;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isComplete = null;
                            continue block8;
                        }
                        this.isComplete = in.readBoolean();
                        continue block8;
                    }
                    case 5: {
                        this.transactionResult = TransactionResult.values()[in.readEnum()];
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BankingTransaction>
    implements RecordBuilder<BankingTransaction> {
        private String transactionId;
        private double time;
        private double timeCompleted;
        private double duration;
        private Boolean isComplete;
        private TransactionResult transactionResult;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.transactionId)) {
                this.transactionId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.transactionId);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.time);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.duration)) {
                this.duration = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.duration);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isComplete)) {
                this.isComplete = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isComplete);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.transactionResult))) {
                this.transactionResult = (TransactionResult)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.transactionResult));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(BankingTransaction other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.transactionId)) {
                this.transactionId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.transactionId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.time);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeCompleted)) {
                this.timeCompleted = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeCompleted);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.duration)) {
                this.duration = (Double)this.data().deepCopy(this.fields()[3].schema(), (Object)other.duration);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isComplete)) {
                this.isComplete = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isComplete);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.transactionResult))) {
                this.transactionResult = (TransactionResult)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.transactionResult));
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public Builder setTransactionId(String value) {
            this.validate(this.fields()[0], value);
            this.transactionId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTransactionId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTransactionId() {
            this.transactionId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[1], value);
            this.time = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getTimeCompleted() {
            return this.timeCompleted;
        }

        public Builder setTimeCompleted(double value) {
            this.validate(this.fields()[2], value);
            this.timeCompleted = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeCompleted() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeCompleted() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public double getDuration() {
            return this.duration;
        }

        public Builder setDuration(double value) {
            this.validate(this.fields()[3], value);
            this.duration = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDuration() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getIsComplete() {
            return this.isComplete;
        }

        public Builder setIsComplete(Boolean value) {
            this.validate(this.fields()[4], value);
            this.isComplete = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasIsComplete() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearIsComplete() {
            this.isComplete = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public TransactionResult getTransactionResult() {
            return this.transactionResult;
        }

        public Builder setTransactionResult(TransactionResult value) {
            this.validate(this.fields()[5], (Object)value);
            this.transactionResult = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTransactionResult() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTransactionResult() {
            this.transactionResult = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public BankingTransaction build() {
            try {
                BankingTransaction record = new BankingTransaction();
                record.transactionId = this.fieldSetFlags()[0] ? this.transactionId : (String)this.defaultValue(this.fields()[0]);
                record.time = this.fieldSetFlags()[1] ? this.time : (Double)this.defaultValue(this.fields()[1]);
                record.timeCompleted = this.fieldSetFlags()[2] ? this.timeCompleted : (Double)this.defaultValue(this.fields()[2]);
                record.duration = this.fieldSetFlags()[3] ? this.duration : (Double)this.defaultValue(this.fields()[3]);
                record.isComplete = this.fieldSetFlags()[4] ? this.isComplete : (Boolean)this.defaultValue(this.fields()[4]);
                record.transactionResult = this.fieldSetFlags()[5] ? this.transactionResult : (TransactionResult)((Object)this.defaultValue(this.fields()[5]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

