/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.active.healthkit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HealthKitTypedData
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 8526058182966396303L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HealthKitTypedData\",\"namespace\":\"org.radarcns.active.healthkit\",\"doc\":\"HealthKit generic typed data schema.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of this activity period in UTC (s).\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"End time of this activity period in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Apple Healthkit .\"},{\"name\":\"sourceId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identifier of the app that produced the data.\"},{\"name\":\"sourceName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the app that produced the data (as it appears to the user).\"},{\"name\":\"unit\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The unit of the measurement.\"},{\"name\":\"key\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Type of data retrived e.g. weight, height, etc.\"},{\"name\":\"intValue\",\"type\":[\"null\",\"int\"],\"doc\":\"Value of the int data retrieved.\",\"default\":null},{\"name\":\"floatValue\",\"type\":[\"null\",\"float\"],\"doc\":\"Value of the float data retrieved.\",\"default\":null},{\"name\":\"doubleValue\",\"type\":[\"null\",\"double\"],\"doc\":\"Value of the double data retrieved.\",\"default\":null},{\"name\":\"stringValue\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Value of the string data retrieved.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HealthKitTypedData> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HealthKitTypedData> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double endTime;
    private double timeReceived;
    private String sourceId;
    private String sourceName;
    private String unit;
    private String key;
    private Integer intValue;
    private Float floatValue;
    private Double doubleValue;
    private String stringValue;
    private static final DatumWriter<HealthKitTypedData> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HealthKitTypedData> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HealthKitTypedData> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HealthKitTypedData> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HealthKitTypedData> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HealthKitTypedData fromByteBuffer(ByteBuffer b) throws IOException {
        return (HealthKitTypedData)((Object)DECODER.decode(b));
    }

    public HealthKitTypedData() {
    }

    public HealthKitTypedData(Double time, Double endTime, Double timeReceived, String sourceId, String sourceName, String unit, String key, Integer intValue, Float floatValue, Double doubleValue, String stringValue) {
        this.time = time;
        this.endTime = endTime;
        this.timeReceived = timeReceived;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.unit = unit;
        this.key = key;
        this.intValue = intValue;
        this.floatValue = floatValue;
        this.doubleValue = doubleValue;
        this.stringValue = stringValue;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.endTime;
            }
            case 2: {
                return this.timeReceived;
            }
            case 3: {
                return this.sourceId;
            }
            case 4: {
                return this.sourceName;
            }
            case 5: {
                return this.unit;
            }
            case 6: {
                return this.key;
            }
            case 7: {
                return this.intValue;
            }
            case 8: {
                return this.floatValue;
            }
            case 9: {
                return this.doubleValue;
            }
            case 10: {
                return this.stringValue;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.endTime = (Double)value$;
                break;
            }
            case 2: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 3: {
                this.sourceId = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.sourceName = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.unit = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.key = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.intValue = (Integer)value$;
                break;
            }
            case 8: {
                this.floatValue = (Float)value$;
                break;
            }
            case 9: {
                this.doubleValue = (Double)value$;
                break;
            }
            case 10: {
                this.stringValue = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double value) {
        this.endTime = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String value) {
        this.sourceId = value;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String value) {
        this.sourceName = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public void setIntValue(Integer value) {
        this.intValue = value;
    }

    public Float getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(Float value) {
        this.floatValue = value;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double value) {
        this.doubleValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HealthKitTypedData other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.endTime);
        out.writeDouble(this.timeReceived);
        out.writeString(this.sourceId);
        out.writeString(this.sourceName);
        out.writeString(this.unit);
        out.writeString(this.key);
        if (this.intValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.intValue.intValue());
        }
        if (this.floatValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.floatValue.floatValue());
        }
        if (this.doubleValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeDouble(this.doubleValue.doubleValue());
        }
        if (this.stringValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.stringValue);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.endTime = in.readDouble();
            this.timeReceived = in.readDouble();
            this.sourceId = in.readString();
            this.sourceName = in.readString();
            this.unit = in.readString();
            this.key = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.intValue = null;
            } else {
                this.intValue = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.floatValue = null;
            } else {
                this.floatValue = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.doubleValue = null;
            } else {
                this.doubleValue = in.readDouble();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stringValue = null;
            } else {
                this.stringValue = in.readString();
            }
        } else {
            block13: for (int i = 0; i < 11; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block13;
                    }
                    case 1: {
                        this.endTime = in.readDouble();
                        continue block13;
                    }
                    case 2: {
                        this.timeReceived = in.readDouble();
                        continue block13;
                    }
                    case 3: {
                        this.sourceId = in.readString();
                        continue block13;
                    }
                    case 4: {
                        this.sourceName = in.readString();
                        continue block13;
                    }
                    case 5: {
                        this.unit = in.readString();
                        continue block13;
                    }
                    case 6: {
                        this.key = in.readString();
                        continue block13;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intValue = null;
                            continue block13;
                        }
                        this.intValue = in.readInt();
                        continue block13;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.floatValue = null;
                            continue block13;
                        }
                        this.floatValue = Float.valueOf(in.readFloat());
                        continue block13;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.doubleValue = null;
                            continue block13;
                        }
                        this.doubleValue = in.readDouble();
                        continue block13;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stringValue = null;
                            continue block13;
                        }
                        this.stringValue = in.readString();
                        continue block13;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HealthKitTypedData>
    implements RecordBuilder<HealthKitTypedData> {
        private double time;
        private double endTime;
        private double timeReceived;
        private String sourceId;
        private String sourceName;
        private String unit;
        private String key;
        private Integer intValue;
        private Float floatValue;
        private Double doubleValue;
        private String stringValue;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.sourceName)) {
                this.sourceName = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sourceName);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.unit)) {
                this.unit = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.unit);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.key)) {
                this.key = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.key);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.intValue)) {
                this.intValue = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.intValue);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.floatValue)) {
                this.floatValue = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.floatValue);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.doubleValue)) {
                this.doubleValue = (Double)this.data().deepCopy(this.fields()[9].schema(), (Object)other.doubleValue);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.stringValue)) {
                this.stringValue = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.stringValue);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
        }

        private Builder(HealthKitTypedData other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.sourceName)) {
                this.sourceName = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sourceName);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.unit)) {
                this.unit = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.unit);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.key)) {
                this.key = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.key);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.intValue)) {
                this.intValue = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.intValue);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.floatValue)) {
                this.floatValue = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.floatValue);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.doubleValue)) {
                this.doubleValue = (Double)this.data().deepCopy(this.fields()[9].schema(), (Object)other.doubleValue);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.stringValue)) {
                this.stringValue = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.stringValue);
                this.fieldSetFlags()[10] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(double value) {
            this.validate(this.fields()[1], value);
            this.endTime = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEndTime() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEndTime() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[2], value);
            this.timeReceived = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public Builder setSourceId(String value) {
            this.validate(this.fields()[3], value);
            this.sourceId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSourceId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSourceId() {
            this.sourceId = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public Builder setSourceName(String value) {
            this.validate(this.fields()[4], value);
            this.sourceName = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSourceName() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSourceName() {
            this.sourceName = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getUnit() {
            return this.unit;
        }

        public Builder setUnit(String value) {
            this.validate(this.fields()[5], value);
            this.unit = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasUnit() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearUnit() {
            this.unit = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String value) {
            this.validate(this.fields()[6], value);
            this.key = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasKey() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearKey() {
            this.key = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getIntValue() {
            return this.intValue;
        }

        public Builder setIntValue(Integer value) {
            this.validate(this.fields()[7], value);
            this.intValue = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasIntValue() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearIntValue() {
            this.intValue = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getFloatValue() {
            return this.floatValue;
        }

        public Builder setFloatValue(Float value) {
            this.validate(this.fields()[8], value);
            this.floatValue = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasFloatValue() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearFloatValue() {
            this.floatValue = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Double getDoubleValue() {
            return this.doubleValue;
        }

        public Builder setDoubleValue(Double value) {
            this.validate(this.fields()[9], value);
            this.doubleValue = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasDoubleValue() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearDoubleValue() {
            this.doubleValue = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public Builder setStringValue(String value) {
            this.validate(this.fields()[10], value);
            this.stringValue = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasStringValue() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearStringValue() {
            this.stringValue = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public HealthKitTypedData build() {
            try {
                HealthKitTypedData record = new HealthKitTypedData();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.endTime = this.fieldSetFlags()[1] ? this.endTime : (Double)this.defaultValue(this.fields()[1]);
                record.timeReceived = this.fieldSetFlags()[2] ? this.timeReceived : (Double)this.defaultValue(this.fields()[2]);
                record.sourceId = this.fieldSetFlags()[3] ? this.sourceId : (String)this.defaultValue(this.fields()[3]);
                record.sourceName = this.fieldSetFlags()[4] ? this.sourceName : (String)this.defaultValue(this.fields()[4]);
                record.unit = this.fieldSetFlags()[5] ? this.unit : (String)this.defaultValue(this.fields()[5]);
                record.key = this.fieldSetFlags()[6] ? this.key : (String)this.defaultValue(this.fields()[6]);
                record.intValue = this.fieldSetFlags()[7] ? this.intValue : (Integer)this.defaultValue(this.fields()[7]);
                record.floatValue = this.fieldSetFlags()[8] ? this.floatValue : (Float)this.defaultValue(this.fields()[8]);
                record.doubleValue = this.fieldSetFlags()[9] ? this.doubleValue : (Double)this.defaultValue(this.fields()[9]);
                record.stringValue = this.fieldSetFlags()[10] ? this.stringValue : (String)this.defaultValue(this.fields()[10]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

