/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitIntradayHeartRateVariability
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8510766378307720959L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitIntradayHeartRateVariability\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Intra day heart rate variability (HRV) data from fitbit device. HRV data applies specifically to a user\u2019s \u201cmain sleep,\u201d which is the longest single period of time asleep on a given date.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"rmssd\",\"type\":\"float\",\"doc\":\"The Root Mean Square of Successive Differences (RMSSD) between heart beats. It measures short-term variability in the user\u2019s heart rate in milliseconds (ms).\"},{\"name\":\"coverage\",\"type\":\"float\",\"doc\":\"Data completeness in terms of the number of interbeat intervals (0-1).\"},{\"name\":\"highFrequency\",\"type\":\"float\",\"doc\":\"The power in interbeat interval fluctuations within the high frequency band (0.15 Hz - 0.4 Hz).\"},{\"name\":\"lowFrequency\",\"type\":\"float\",\"doc\":\"The power in interbeat interval fluctuations within the low frequency band (0.04 Hz - 0.15 Hz).\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitIntradayHeartRateVariability> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitIntradayHeartRateVariability> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float rmssd;
    private float coverage;
    private float highFrequency;
    private float lowFrequency;
    private static final DatumWriter<FitbitIntradayHeartRateVariability> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitIntradayHeartRateVariability> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitIntradayHeartRateVariability> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitIntradayHeartRateVariability> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitIntradayHeartRateVariability> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitIntradayHeartRateVariability fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitIntradayHeartRateVariability)((Object)DECODER.decode(b));
    }

    public FitbitIntradayHeartRateVariability() {
    }

    public FitbitIntradayHeartRateVariability(Double time, Double timeReceived, Float rmssd, Float coverage, Float highFrequency, Float lowFrequency) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.rmssd = rmssd.floatValue();
        this.coverage = coverage.floatValue();
        this.highFrequency = highFrequency.floatValue();
        this.lowFrequency = lowFrequency.floatValue();
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.rmssd);
            }
            case 3: {
                return Float.valueOf(this.coverage);
            }
            case 4: {
                return Float.valueOf(this.highFrequency);
            }
            case 5: {
                return Float.valueOf(this.lowFrequency);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.rmssd = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.coverage = ((Float)value$).floatValue();
                break;
            }
            case 4: {
                this.highFrequency = ((Float)value$).floatValue();
                break;
            }
            case 5: {
                this.lowFrequency = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getRmssd() {
        return this.rmssd;
    }

    public void setRmssd(float value) {
        this.rmssd = value;
    }

    public float getCoverage() {
        return this.coverage;
    }

    public void setCoverage(float value) {
        this.coverage = value;
    }

    public float getHighFrequency() {
        return this.highFrequency;
    }

    public void setHighFrequency(float value) {
        this.highFrequency = value;
    }

    public float getLowFrequency() {
        return this.lowFrequency;
    }

    public void setLowFrequency(float value) {
        this.lowFrequency = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitIntradayHeartRateVariability other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.rmssd);
        out.writeFloat(this.coverage);
        out.writeFloat(this.highFrequency);
        out.writeFloat(this.lowFrequency);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.rmssd = in.readFloat();
            this.coverage = in.readFloat();
            this.highFrequency = in.readFloat();
            this.lowFrequency = in.readFloat();
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.rmssd = in.readFloat();
                        continue block8;
                    }
                    case 3: {
                        this.coverage = in.readFloat();
                        continue block8;
                    }
                    case 4: {
                        this.highFrequency = in.readFloat();
                        continue block8;
                    }
                    case 5: {
                        this.lowFrequency = in.readFloat();
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitIntradayHeartRateVariability>
    implements RecordBuilder<FitbitIntradayHeartRateVariability> {
        private double time;
        private double timeReceived;
        private float rmssd;
        private float coverage;
        private float highFrequency;
        private float lowFrequency;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.rmssd))) {
                this.rmssd = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.rmssd))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.coverage))) {
                this.coverage = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.coverage))).floatValue();
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.highFrequency))) {
                this.highFrequency = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.highFrequency))).floatValue();
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.lowFrequency))) {
                this.lowFrequency = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.lowFrequency))).floatValue();
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(FitbitIntradayHeartRateVariability other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.rmssd))) {
                this.rmssd = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.rmssd))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.coverage))) {
                this.coverage = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.coverage))).floatValue();
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)Float.valueOf(other.highFrequency))) {
                this.highFrequency = ((Float)this.data().deepCopy(this.fields()[4].schema(), (Object)Float.valueOf(other.highFrequency))).floatValue();
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.lowFrequency))) {
                this.lowFrequency = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.lowFrequency))).floatValue();
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getRmssd() {
            return this.rmssd;
        }

        public Builder setRmssd(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.rmssd = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRmssd() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearRmssd() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public float getCoverage() {
            return this.coverage;
        }

        public Builder setCoverage(float value) {
            this.validate(this.fields()[3], Float.valueOf(value));
            this.coverage = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCoverage() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCoverage() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public float getHighFrequency() {
            return this.highFrequency;
        }

        public Builder setHighFrequency(float value) {
            this.validate(this.fields()[4], Float.valueOf(value));
            this.highFrequency = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasHighFrequency() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearHighFrequency() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public float getLowFrequency() {
            return this.lowFrequency;
        }

        public Builder setLowFrequency(float value) {
            this.validate(this.fields()[5], Float.valueOf(value));
            this.lowFrequency = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasLowFrequency() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearLowFrequency() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public FitbitIntradayHeartRateVariability build() {
            try {
                FitbitIntradayHeartRateVariability record = new FitbitIntradayHeartRateVariability();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.rmssd = this.fieldSetFlags()[2] ? this.rmssd : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.coverage = this.fieldSetFlags()[3] ? this.coverage : ((Float)this.defaultValue(this.fields()[3])).floatValue();
                record.highFrequency = this.fieldSetFlags()[4] ? this.highFrequency : ((Float)this.defaultValue(this.fields()[4])).floatValue();
                record.lowFrequency = this.fieldSetFlags()[5] ? this.lowFrequency : ((Float)this.defaultValue(this.fields()[5])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

