/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FitbitRestingHeartRate
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8777149618753443969L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitRestingHeartRate\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Heart rate time-series data over a period of time from fitbit device.\",\"fields\":[{\"name\":\"date\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"ISO 8601 formatted local date of device (yyyy-MM-dd).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"restingHeartRate\",\"type\":\"int\",\"doc\":\"Resting heart rate value (bpm) for the day. A sleep stage log is required to generate this value. When a classic sleep log is recorded, this value will be missing.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitRestingHeartRate> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitRestingHeartRate> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private String date;
    private double timeReceived;
    private int restingHeartRate;
    private static final DatumWriter<FitbitRestingHeartRate> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitRestingHeartRate> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitRestingHeartRate> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitRestingHeartRate> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitRestingHeartRate> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitRestingHeartRate fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitRestingHeartRate)((Object)DECODER.decode(b));
    }

    public FitbitRestingHeartRate() {
    }

    public FitbitRestingHeartRate(String date, Double timeReceived, Integer restingHeartRate) {
        this.date = date;
        this.timeReceived = timeReceived;
        this.restingHeartRate = restingHeartRate;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.date;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.restingHeartRate;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.restingHeartRate = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getRestingHeartRate() {
        return this.restingHeartRate;
    }

    public void setRestingHeartRate(int value) {
        this.restingHeartRate = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitRestingHeartRate other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.date);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.restingHeartRate);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.date = in.readString();
            this.timeReceived = in.readDouble();
            this.restingHeartRate = in.readInt();
        } else {
            block5: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.date = in.readString();
                        continue block5;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block5;
                    }
                    case 2: {
                        this.restingHeartRate = in.readInt();
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitRestingHeartRate>
    implements RecordBuilder<FitbitRestingHeartRate> {
        private String date;
        private double timeReceived;
        private int restingHeartRate;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.date);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(FitbitRestingHeartRate other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.date);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[2] = true;
            }
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[0], value);
            this.date = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getRestingHeartRate() {
            return this.restingHeartRate;
        }

        public Builder setRestingHeartRate(int value) {
            this.validate(this.fields()[2], value);
            this.restingHeartRate = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRestingHeartRate() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearRestingHeartRate() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public FitbitRestingHeartRate build() {
            try {
                FitbitRestingHeartRate record = new FitbitRestingHeartRate();
                record.date = this.fieldSetFlags()[0] ? this.date : (String)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.restingHeartRate = this.fieldSetFlags()[2] ? this.restingHeartRate : (Integer)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

