/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.fitbit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.fitbit.FitbitSkinTemperatureLogType;

@AvroGenerated
public class FitbitSkinTemperature
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1006325149583569412L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FitbitSkinTemperature\",\"namespace\":\"org.radarcns.connector.fitbit\",\"doc\":\"Skin temperature (tempSkin) data from fitbit device. tempSkin measures skin temperature data for a date range. It only returns a value for dates on which the Fitbit device was able to record Temperature (skin) data and the maximum date range cannot exceed 30 days. Temperature (Skin) data applies specifically to a user\u2019s \u201cmain sleep,\u201d which is the longest single period of time asleep on a given date.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that the data was received from the Fitbit API (seconds since the Unix Epoch).\"},{\"name\":\"relativeTemperature\",\"type\":\"float\",\"doc\":\"The user's average temperature during a period of sleep. It is displayed to the user as a delta from their baseline temperature in degrees Celsius.\"},{\"name\":\"logType\",\"type\":{\"type\":\"enum\",\"name\":\"FitbitSkinTemperatureLogType\",\"doc\":\"The type of skin temperature log created.\",\"symbols\":[\"DEDICATED_TEMP_SENSOR\",\"OTHER_SENSORS\",\"UNKNOWN\"]},\"doc\":\"The type of skin temperature log created.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FitbitSkinTemperature> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FitbitSkinTemperature> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float relativeTemperature;
    private FitbitSkinTemperatureLogType logType;
    private static final DatumWriter<FitbitSkinTemperature> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FitbitSkinTemperature> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FitbitSkinTemperature> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FitbitSkinTemperature> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FitbitSkinTemperature> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FitbitSkinTemperature fromByteBuffer(ByteBuffer b) throws IOException {
        return (FitbitSkinTemperature)((Object)DECODER.decode(b));
    }

    public FitbitSkinTemperature() {
    }

    public FitbitSkinTemperature(Double time, Double timeReceived, Float relativeTemperature, FitbitSkinTemperatureLogType logType) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.relativeTemperature = relativeTemperature.floatValue();
        this.logType = logType;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.relativeTemperature);
            }
            case 3: {
                return this.logType;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.relativeTemperature = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.logType = (FitbitSkinTemperatureLogType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getRelativeTemperature() {
        return this.relativeTemperature;
    }

    public void setRelativeTemperature(float value) {
        this.relativeTemperature = value;
    }

    public FitbitSkinTemperatureLogType getLogType() {
        return this.logType;
    }

    public void setLogType(FitbitSkinTemperatureLogType value) {
        this.logType = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FitbitSkinTemperature other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.relativeTemperature);
        out.writeEnum(this.logType.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.relativeTemperature = in.readFloat();
            this.logType = FitbitSkinTemperatureLogType.values()[in.readEnum()];
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.relativeTemperature = in.readFloat();
                        continue block6;
                    }
                    case 3: {
                        this.logType = FitbitSkinTemperatureLogType.values()[in.readEnum()];
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FitbitSkinTemperature>
    implements RecordBuilder<FitbitSkinTemperature> {
        private double time;
        private double timeReceived;
        private float relativeTemperature;
        private FitbitSkinTemperatureLogType logType;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.relativeTemperature))) {
                this.relativeTemperature = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.relativeTemperature))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.logType))) {
                this.logType = (FitbitSkinTemperatureLogType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.logType));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(FitbitSkinTemperature other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.relativeTemperature))) {
                this.relativeTemperature = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.relativeTemperature))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.logType))) {
                this.logType = (FitbitSkinTemperatureLogType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.logType));
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getRelativeTemperature() {
            return this.relativeTemperature;
        }

        public Builder setRelativeTemperature(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.relativeTemperature = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRelativeTemperature() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearRelativeTemperature() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public FitbitSkinTemperatureLogType getLogType() {
            return this.logType;
        }

        public Builder setLogType(FitbitSkinTemperatureLogType value) {
            this.validate(this.fields()[3], (Object)value);
            this.logType = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLogType() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLogType() {
            this.logType = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public FitbitSkinTemperature build() {
            try {
                FitbitSkinTemperature record = new FitbitSkinTemperature();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.relativeTemperature = this.fieldSetFlags()[2] ? this.relativeTemperature : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.logType = this.fieldSetFlags()[3] ? this.logType : (FitbitSkinTemperatureLogType)((Object)this.defaultValue(this.fields()[3]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

