/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class OuraDailyActivity
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5728430252423739010L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraDailyActivity\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"The Daily Activity scope includes daily activity summary values and detailed activity levels. Activity levels are expressed in metabolic equivalent of task minutes (MET mins). Oura tracks activity based on the movement.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the activity from Oura.\",\"default\":null},{\"name\":\"score\",\"type\":[\"null\",\"int\"],\"doc\":\"Activity score in range [1, 100]. Null if unknown.\",\"default\":null},{\"name\":\"activeCalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Active calories expended (in kilocalories). Null if unknown.\",\"default\":null},{\"name\":\"averageMetMinutes\",\"type\":[\"null\",\"float\"],\"doc\":\"Average metabolic equivalent (MET) in minutes. Null if unknown.\",\"default\":null},{\"name\":\"contributorMeetDailyTargets\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of meeting previous 7-day daily activity targets in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"contributorMoveEveryHour\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 24-hour inactivity alerts in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"contributorRecoveryTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 7-day recovery time in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"contributorStayActive\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 24-hour activity in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"contributorTrainingFrequency\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 7-day exercise frequency in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"contributorTrainingVolume\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 7-day exercise volume in range [1, 100] to the activity score. Null if unknown.\",\"default\":null},{\"name\":\"equivalentWalkingDistance\",\"type\":[\"null\",\"int\"],\"doc\":\"Equivalent walking distance (in meters) of energy expenditure. Null if unknown.\",\"default\":null},{\"name\":\"highActivityMetMinutes\",\"type\":[\"null\",\"int\"],\"doc\":\"High activity metabolic equivalent (MET) in minutes. Null if unknown.\",\"default\":null},{\"name\":\"highActivityTime\",\"type\":[\"null\",\"int\"],\"doc\":\"High activity metabolic equivalent (MET) in seconds. Null if unknown.\",\"default\":null},{\"name\":\"inactivityAlerts\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of inactivity alerts received. Null if unknown.\",\"default\":null},{\"name\":\"lowActivityMetMinutes\",\"type\":[\"null\",\"int\"],\"doc\":\"Low activity metabolic equivalent (MET) in minutes. Null if unknown.\",\"default\":null},{\"name\":\"lowActivityTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Low activity metabolic equivalent (MET) in seconds. Null if unknown.\",\"default\":null},{\"name\":\"mediumActivityMetMinutes\",\"type\":[\"null\",\"int\"],\"doc\":\"Medium activity metabolic equivalent (MET) in minutes. Null if unknown.\",\"default\":null},{\"name\":\"mediumActivityTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Medium activity metabolic equivalent (MET) in seconds. Null if unknown.\",\"default\":null},{\"name\":\"metersToTarget\",\"type\":[\"null\",\"int\"],\"doc\":\"Remaining meters to target. Null if unknown.\",\"default\":null},{\"name\":\"nonWearTime\",\"type\":[\"null\",\"int\"],\"doc\":\"The time (in seconds) in which the ring was not worn. Null if unknown.\",\"default\":null},{\"name\":\"restingTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Resting time (in seconds). Null if unknown.\",\"default\":null},{\"name\":\"sedentaryMetMinutes\",\"type\":[\"null\",\"int\"],\"doc\":\"Sedentary metabolic equivalent (MET) in minutes. Null if unknown.\",\"default\":null},{\"name\":\"sedentaryTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Sedentary metabolic equivalent (MET) in seconds. Null if unknown.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of steps taken. Null if unknown.\",\"default\":null},{\"name\":\"targetCalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Daily activity target (in kilocalories). Null if unknown.\",\"default\":null},{\"name\":\"targetMeters\",\"type\":[\"null\",\"int\"],\"doc\":\"Daily activity target (in meters). Null if unknown.\",\"default\":null},{\"name\":\"totalCalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Total calories expended (in kilocalories). Null if unknown.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The YYYY-MM-DD formatted local date indicating when the daily activity occurred. Null if unknown.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraDailyActivity> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraDailyActivity> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private Integer score;
    private Integer activeCalories;
    private Float averageMetMinutes;
    private Integer contributorMeetDailyTargets;
    private Integer contributorMoveEveryHour;
    private Integer contributorRecoveryTime;
    private Integer contributorStayActive;
    private Integer contributorTrainingFrequency;
    private Integer contributorTrainingVolume;
    private Integer equivalentWalkingDistance;
    private Integer highActivityMetMinutes;
    private Integer highActivityTime;
    private Integer inactivityAlerts;
    private Integer lowActivityMetMinutes;
    private Integer lowActivityTime;
    private Integer mediumActivityMetMinutes;
    private Integer mediumActivityTime;
    private Integer metersToTarget;
    private Integer nonWearTime;
    private Integer restingTime;
    private Integer sedentaryMetMinutes;
    private Integer sedentaryTime;
    private Integer steps;
    private Integer targetCalories;
    private Integer targetMeters;
    private Integer totalCalories;
    private String day;
    private static final DatumWriter<OuraDailyActivity> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraDailyActivity> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraDailyActivity> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraDailyActivity> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraDailyActivity> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraDailyActivity fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraDailyActivity)((Object)DECODER.decode(b));
    }

    public OuraDailyActivity() {
    }

    public OuraDailyActivity(Double time, Double timeReceived, String id, Integer score, Integer activeCalories, Float averageMetMinutes, Integer contributorMeetDailyTargets, Integer contributorMoveEveryHour, Integer contributorRecoveryTime, Integer contributorStayActive, Integer contributorTrainingFrequency, Integer contributorTrainingVolume, Integer equivalentWalkingDistance, Integer highActivityMetMinutes, Integer highActivityTime, Integer inactivityAlerts, Integer lowActivityMetMinutes, Integer lowActivityTime, Integer mediumActivityMetMinutes, Integer mediumActivityTime, Integer metersToTarget, Integer nonWearTime, Integer restingTime, Integer sedentaryMetMinutes, Integer sedentaryTime, Integer steps, Integer targetCalories, Integer targetMeters, Integer totalCalories, String day) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.score = score;
        this.activeCalories = activeCalories;
        this.averageMetMinutes = averageMetMinutes;
        this.contributorMeetDailyTargets = contributorMeetDailyTargets;
        this.contributorMoveEveryHour = contributorMoveEveryHour;
        this.contributorRecoveryTime = contributorRecoveryTime;
        this.contributorStayActive = contributorStayActive;
        this.contributorTrainingFrequency = contributorTrainingFrequency;
        this.contributorTrainingVolume = contributorTrainingVolume;
        this.equivalentWalkingDistance = equivalentWalkingDistance;
        this.highActivityMetMinutes = highActivityMetMinutes;
        this.highActivityTime = highActivityTime;
        this.inactivityAlerts = inactivityAlerts;
        this.lowActivityMetMinutes = lowActivityMetMinutes;
        this.lowActivityTime = lowActivityTime;
        this.mediumActivityMetMinutes = mediumActivityMetMinutes;
        this.mediumActivityTime = mediumActivityTime;
        this.metersToTarget = metersToTarget;
        this.nonWearTime = nonWearTime;
        this.restingTime = restingTime;
        this.sedentaryMetMinutes = sedentaryMetMinutes;
        this.sedentaryTime = sedentaryTime;
        this.steps = steps;
        this.targetCalories = targetCalories;
        this.targetMeters = targetMeters;
        this.totalCalories = totalCalories;
        this.day = day;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.score;
            }
            case 4: {
                return this.activeCalories;
            }
            case 5: {
                return this.averageMetMinutes;
            }
            case 6: {
                return this.contributorMeetDailyTargets;
            }
            case 7: {
                return this.contributorMoveEveryHour;
            }
            case 8: {
                return this.contributorRecoveryTime;
            }
            case 9: {
                return this.contributorStayActive;
            }
            case 10: {
                return this.contributorTrainingFrequency;
            }
            case 11: {
                return this.contributorTrainingVolume;
            }
            case 12: {
                return this.equivalentWalkingDistance;
            }
            case 13: {
                return this.highActivityMetMinutes;
            }
            case 14: {
                return this.highActivityTime;
            }
            case 15: {
                return this.inactivityAlerts;
            }
            case 16: {
                return this.lowActivityMetMinutes;
            }
            case 17: {
                return this.lowActivityTime;
            }
            case 18: {
                return this.mediumActivityMetMinutes;
            }
            case 19: {
                return this.mediumActivityTime;
            }
            case 20: {
                return this.metersToTarget;
            }
            case 21: {
                return this.nonWearTime;
            }
            case 22: {
                return this.restingTime;
            }
            case 23: {
                return this.sedentaryMetMinutes;
            }
            case 24: {
                return this.sedentaryTime;
            }
            case 25: {
                return this.steps;
            }
            case 26: {
                return this.targetCalories;
            }
            case 27: {
                return this.targetMeters;
            }
            case 28: {
                return this.totalCalories;
            }
            case 29: {
                return this.day;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.score = (Integer)value$;
                break;
            }
            case 4: {
                this.activeCalories = (Integer)value$;
                break;
            }
            case 5: {
                this.averageMetMinutes = (Float)value$;
                break;
            }
            case 6: {
                this.contributorMeetDailyTargets = (Integer)value$;
                break;
            }
            case 7: {
                this.contributorMoveEveryHour = (Integer)value$;
                break;
            }
            case 8: {
                this.contributorRecoveryTime = (Integer)value$;
                break;
            }
            case 9: {
                this.contributorStayActive = (Integer)value$;
                break;
            }
            case 10: {
                this.contributorTrainingFrequency = (Integer)value$;
                break;
            }
            case 11: {
                this.contributorTrainingVolume = (Integer)value$;
                break;
            }
            case 12: {
                this.equivalentWalkingDistance = (Integer)value$;
                break;
            }
            case 13: {
                this.highActivityMetMinutes = (Integer)value$;
                break;
            }
            case 14: {
                this.highActivityTime = (Integer)value$;
                break;
            }
            case 15: {
                this.inactivityAlerts = (Integer)value$;
                break;
            }
            case 16: {
                this.lowActivityMetMinutes = (Integer)value$;
                break;
            }
            case 17: {
                this.lowActivityTime = (Integer)value$;
                break;
            }
            case 18: {
                this.mediumActivityMetMinutes = (Integer)value$;
                break;
            }
            case 19: {
                this.mediumActivityTime = (Integer)value$;
                break;
            }
            case 20: {
                this.metersToTarget = (Integer)value$;
                break;
            }
            case 21: {
                this.nonWearTime = (Integer)value$;
                break;
            }
            case 22: {
                this.restingTime = (Integer)value$;
                break;
            }
            case 23: {
                this.sedentaryMetMinutes = (Integer)value$;
                break;
            }
            case 24: {
                this.sedentaryTime = (Integer)value$;
                break;
            }
            case 25: {
                this.steps = (Integer)value$;
                break;
            }
            case 26: {
                this.targetCalories = (Integer)value$;
                break;
            }
            case 27: {
                this.targetMeters = (Integer)value$;
                break;
            }
            case 28: {
                this.totalCalories = (Integer)value$;
                break;
            }
            case 29: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer value) {
        this.score = value;
    }

    public Integer getActiveCalories() {
        return this.activeCalories;
    }

    public void setActiveCalories(Integer value) {
        this.activeCalories = value;
    }

    public Float getAverageMetMinutes() {
        return this.averageMetMinutes;
    }

    public void setAverageMetMinutes(Float value) {
        this.averageMetMinutes = value;
    }

    public Integer getContributorMeetDailyTargets() {
        return this.contributorMeetDailyTargets;
    }

    public void setContributorMeetDailyTargets(Integer value) {
        this.contributorMeetDailyTargets = value;
    }

    public Integer getContributorMoveEveryHour() {
        return this.contributorMoveEveryHour;
    }

    public void setContributorMoveEveryHour(Integer value) {
        this.contributorMoveEveryHour = value;
    }

    public Integer getContributorRecoveryTime() {
        return this.contributorRecoveryTime;
    }

    public void setContributorRecoveryTime(Integer value) {
        this.contributorRecoveryTime = value;
    }

    public Integer getContributorStayActive() {
        return this.contributorStayActive;
    }

    public void setContributorStayActive(Integer value) {
        this.contributorStayActive = value;
    }

    public Integer getContributorTrainingFrequency() {
        return this.contributorTrainingFrequency;
    }

    public void setContributorTrainingFrequency(Integer value) {
        this.contributorTrainingFrequency = value;
    }

    public Integer getContributorTrainingVolume() {
        return this.contributorTrainingVolume;
    }

    public void setContributorTrainingVolume(Integer value) {
        this.contributorTrainingVolume = value;
    }

    public Integer getEquivalentWalkingDistance() {
        return this.equivalentWalkingDistance;
    }

    public void setEquivalentWalkingDistance(Integer value) {
        this.equivalentWalkingDistance = value;
    }

    public Integer getHighActivityMetMinutes() {
        return this.highActivityMetMinutes;
    }

    public void setHighActivityMetMinutes(Integer value) {
        this.highActivityMetMinutes = value;
    }

    public Integer getHighActivityTime() {
        return this.highActivityTime;
    }

    public void setHighActivityTime(Integer value) {
        this.highActivityTime = value;
    }

    public Integer getInactivityAlerts() {
        return this.inactivityAlerts;
    }

    public void setInactivityAlerts(Integer value) {
        this.inactivityAlerts = value;
    }

    public Integer getLowActivityMetMinutes() {
        return this.lowActivityMetMinutes;
    }

    public void setLowActivityMetMinutes(Integer value) {
        this.lowActivityMetMinutes = value;
    }

    public Integer getLowActivityTime() {
        return this.lowActivityTime;
    }

    public void setLowActivityTime(Integer value) {
        this.lowActivityTime = value;
    }

    public Integer getMediumActivityMetMinutes() {
        return this.mediumActivityMetMinutes;
    }

    public void setMediumActivityMetMinutes(Integer value) {
        this.mediumActivityMetMinutes = value;
    }

    public Integer getMediumActivityTime() {
        return this.mediumActivityTime;
    }

    public void setMediumActivityTime(Integer value) {
        this.mediumActivityTime = value;
    }

    public Integer getMetersToTarget() {
        return this.metersToTarget;
    }

    public void setMetersToTarget(Integer value) {
        this.metersToTarget = value;
    }

    public Integer getNonWearTime() {
        return this.nonWearTime;
    }

    public void setNonWearTime(Integer value) {
        this.nonWearTime = value;
    }

    public Integer getRestingTime() {
        return this.restingTime;
    }

    public void setRestingTime(Integer value) {
        this.restingTime = value;
    }

    public Integer getSedentaryMetMinutes() {
        return this.sedentaryMetMinutes;
    }

    public void setSedentaryMetMinutes(Integer value) {
        this.sedentaryMetMinutes = value;
    }

    public Integer getSedentaryTime() {
        return this.sedentaryTime;
    }

    public void setSedentaryTime(Integer value) {
        this.sedentaryTime = value;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer value) {
        this.steps = value;
    }

    public Integer getTargetCalories() {
        return this.targetCalories;
    }

    public void setTargetCalories(Integer value) {
        this.targetCalories = value;
    }

    public Integer getTargetMeters() {
        return this.targetMeters;
    }

    public void setTargetMeters(Integer value) {
        this.targetMeters = value;
    }

    public Integer getTotalCalories() {
        return this.totalCalories;
    }

    public void setTotalCalories(Integer value) {
        this.totalCalories = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraDailyActivity other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.score == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.score.intValue());
        }
        if (this.activeCalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeCalories.intValue());
        }
        if (this.averageMetMinutes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.averageMetMinutes.floatValue());
        }
        if (this.contributorMeetDailyTargets == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorMeetDailyTargets.intValue());
        }
        if (this.contributorMoveEveryHour == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorMoveEveryHour.intValue());
        }
        if (this.contributorRecoveryTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorRecoveryTime.intValue());
        }
        if (this.contributorStayActive == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorStayActive.intValue());
        }
        if (this.contributorTrainingFrequency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorTrainingFrequency.intValue());
        }
        if (this.contributorTrainingVolume == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorTrainingVolume.intValue());
        }
        if (this.equivalentWalkingDistance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.equivalentWalkingDistance.intValue());
        }
        if (this.highActivityMetMinutes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.highActivityMetMinutes.intValue());
        }
        if (this.highActivityTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.highActivityTime.intValue());
        }
        if (this.inactivityAlerts == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.inactivityAlerts.intValue());
        }
        if (this.lowActivityMetMinutes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lowActivityMetMinutes.intValue());
        }
        if (this.lowActivityTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lowActivityTime.intValue());
        }
        if (this.mediumActivityMetMinutes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.mediumActivityMetMinutes.intValue());
        }
        if (this.mediumActivityTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.mediumActivityTime.intValue());
        }
        if (this.metersToTarget == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.metersToTarget.intValue());
        }
        if (this.nonWearTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.nonWearTime.intValue());
        }
        if (this.restingTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.restingTime.intValue());
        }
        if (this.sedentaryMetMinutes == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.sedentaryMetMinutes.intValue());
        }
        if (this.sedentaryTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.sedentaryTime.intValue());
        }
        if (this.steps == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.steps.intValue());
        }
        if (this.targetCalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.targetCalories.intValue());
        }
        if (this.targetMeters == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.targetMeters.intValue());
        }
        if (this.totalCalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.totalCalories.intValue());
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.score = null;
            } else {
                this.score = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeCalories = null;
            } else {
                this.activeCalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageMetMinutes = null;
            } else {
                this.averageMetMinutes = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorMeetDailyTargets = null;
            } else {
                this.contributorMeetDailyTargets = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorMoveEveryHour = null;
            } else {
                this.contributorMoveEveryHour = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorRecoveryTime = null;
            } else {
                this.contributorRecoveryTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorStayActive = null;
            } else {
                this.contributorStayActive = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorTrainingFrequency = null;
            } else {
                this.contributorTrainingFrequency = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorTrainingVolume = null;
            } else {
                this.contributorTrainingVolume = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.equivalentWalkingDistance = null;
            } else {
                this.equivalentWalkingDistance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.highActivityMetMinutes = null;
            } else {
                this.highActivityMetMinutes = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.highActivityTime = null;
            } else {
                this.highActivityTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.inactivityAlerts = null;
            } else {
                this.inactivityAlerts = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lowActivityMetMinutes = null;
            } else {
                this.lowActivityMetMinutes = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lowActivityTime = null;
            } else {
                this.lowActivityTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.mediumActivityMetMinutes = null;
            } else {
                this.mediumActivityMetMinutes = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.mediumActivityTime = null;
            } else {
                this.mediumActivityTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.metersToTarget = null;
            } else {
                this.metersToTarget = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.nonWearTime = null;
            } else {
                this.nonWearTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.restingTime = null;
            } else {
                this.restingTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sedentaryMetMinutes = null;
            } else {
                this.sedentaryMetMinutes = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sedentaryTime = null;
            } else {
                this.sedentaryTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.steps = null;
            } else {
                this.steps = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetCalories = null;
            } else {
                this.targetCalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetMeters = null;
            } else {
                this.targetMeters = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalCalories = null;
            } else {
                this.totalCalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
        } else {
            block32: for (int i = 0; i < 30; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block32;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block32;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block32;
                        }
                        this.id = in.readString();
                        continue block32;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.score = null;
                            continue block32;
                        }
                        this.score = in.readInt();
                        continue block32;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeCalories = null;
                            continue block32;
                        }
                        this.activeCalories = in.readInt();
                        continue block32;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageMetMinutes = null;
                            continue block32;
                        }
                        this.averageMetMinutes = Float.valueOf(in.readFloat());
                        continue block32;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorMeetDailyTargets = null;
                            continue block32;
                        }
                        this.contributorMeetDailyTargets = in.readInt();
                        continue block32;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorMoveEveryHour = null;
                            continue block32;
                        }
                        this.contributorMoveEveryHour = in.readInt();
                        continue block32;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorRecoveryTime = null;
                            continue block32;
                        }
                        this.contributorRecoveryTime = in.readInt();
                        continue block32;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorStayActive = null;
                            continue block32;
                        }
                        this.contributorStayActive = in.readInt();
                        continue block32;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorTrainingFrequency = null;
                            continue block32;
                        }
                        this.contributorTrainingFrequency = in.readInt();
                        continue block32;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorTrainingVolume = null;
                            continue block32;
                        }
                        this.contributorTrainingVolume = in.readInt();
                        continue block32;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.equivalentWalkingDistance = null;
                            continue block32;
                        }
                        this.equivalentWalkingDistance = in.readInt();
                        continue block32;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.highActivityMetMinutes = null;
                            continue block32;
                        }
                        this.highActivityMetMinutes = in.readInt();
                        continue block32;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.highActivityTime = null;
                            continue block32;
                        }
                        this.highActivityTime = in.readInt();
                        continue block32;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.inactivityAlerts = null;
                            continue block32;
                        }
                        this.inactivityAlerts = in.readInt();
                        continue block32;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lowActivityMetMinutes = null;
                            continue block32;
                        }
                        this.lowActivityMetMinutes = in.readInt();
                        continue block32;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lowActivityTime = null;
                            continue block32;
                        }
                        this.lowActivityTime = in.readInt();
                        continue block32;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mediumActivityMetMinutes = null;
                            continue block32;
                        }
                        this.mediumActivityMetMinutes = in.readInt();
                        continue block32;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mediumActivityTime = null;
                            continue block32;
                        }
                        this.mediumActivityTime = in.readInt();
                        continue block32;
                    }
                    case 20: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.metersToTarget = null;
                            continue block32;
                        }
                        this.metersToTarget = in.readInt();
                        continue block32;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.nonWearTime = null;
                            continue block32;
                        }
                        this.nonWearTime = in.readInt();
                        continue block32;
                    }
                    case 22: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.restingTime = null;
                            continue block32;
                        }
                        this.restingTime = in.readInt();
                        continue block32;
                    }
                    case 23: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sedentaryMetMinutes = null;
                            continue block32;
                        }
                        this.sedentaryMetMinutes = in.readInt();
                        continue block32;
                    }
                    case 24: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sedentaryTime = null;
                            continue block32;
                        }
                        this.sedentaryTime = in.readInt();
                        continue block32;
                    }
                    case 25: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.steps = null;
                            continue block32;
                        }
                        this.steps = in.readInt();
                        continue block32;
                    }
                    case 26: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetCalories = null;
                            continue block32;
                        }
                        this.targetCalories = in.readInt();
                        continue block32;
                    }
                    case 27: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetMeters = null;
                            continue block32;
                        }
                        this.targetMeters = in.readInt();
                        continue block32;
                    }
                    case 28: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalCalories = null;
                            continue block32;
                        }
                        this.totalCalories = in.readInt();
                        continue block32;
                    }
                    case 29: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block32;
                        }
                        this.day = in.readString();
                        continue block32;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraDailyActivity>
    implements RecordBuilder<OuraDailyActivity> {
        private double time;
        private double timeReceived;
        private String id;
        private Integer score;
        private Integer activeCalories;
        private Float averageMetMinutes;
        private Integer contributorMeetDailyTargets;
        private Integer contributorMoveEveryHour;
        private Integer contributorRecoveryTime;
        private Integer contributorStayActive;
        private Integer contributorTrainingFrequency;
        private Integer contributorTrainingVolume;
        private Integer equivalentWalkingDistance;
        private Integer highActivityMetMinutes;
        private Integer highActivityTime;
        private Integer inactivityAlerts;
        private Integer lowActivityMetMinutes;
        private Integer lowActivityTime;
        private Integer mediumActivityMetMinutes;
        private Integer mediumActivityTime;
        private Integer metersToTarget;
        private Integer nonWearTime;
        private Integer restingTime;
        private Integer sedentaryMetMinutes;
        private Integer sedentaryTime;
        private Integer steps;
        private Integer targetCalories;
        private Integer targetMeters;
        private Integer totalCalories;
        private String day;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.score);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activeCalories)) {
                this.activeCalories = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activeCalories);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.averageMetMinutes)) {
                this.averageMetMinutes = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.averageMetMinutes);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorMeetDailyTargets)) {
                this.contributorMeetDailyTargets = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorMeetDailyTargets);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorMoveEveryHour)) {
                this.contributorMoveEveryHour = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorMoveEveryHour);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorRecoveryTime)) {
                this.contributorRecoveryTime = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorRecoveryTime);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorStayActive)) {
                this.contributorStayActive = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorStayActive);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.contributorTrainingFrequency)) {
                this.contributorTrainingFrequency = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.contributorTrainingFrequency);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.contributorTrainingVolume)) {
                this.contributorTrainingVolume = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.contributorTrainingVolume);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.equivalentWalkingDistance)) {
                this.equivalentWalkingDistance = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.equivalentWalkingDistance);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.highActivityMetMinutes)) {
                this.highActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.highActivityMetMinutes);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.highActivityTime)) {
                this.highActivityTime = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.highActivityTime);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.inactivityAlerts)) {
                this.inactivityAlerts = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.inactivityAlerts);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.lowActivityMetMinutes)) {
                this.lowActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.lowActivityMetMinutes);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.lowActivityTime)) {
                this.lowActivityTime = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.lowActivityTime);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.mediumActivityMetMinutes)) {
                this.mediumActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.mediumActivityMetMinutes);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.mediumActivityTime)) {
                this.mediumActivityTime = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.mediumActivityTime);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.metersToTarget)) {
                this.metersToTarget = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.metersToTarget);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.nonWearTime)) {
                this.nonWearTime = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.nonWearTime);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.restingTime)) {
                this.restingTime = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.restingTime);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.sedentaryMetMinutes)) {
                this.sedentaryMetMinutes = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.sedentaryMetMinutes);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.sedentaryTime)) {
                this.sedentaryTime = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.sedentaryTime);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.steps);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.targetCalories)) {
                this.targetCalories = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.targetCalories);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.targetMeters)) {
                this.targetMeters = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.targetMeters);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.totalCalories)) {
                this.totalCalories = (Integer)this.data().deepCopy(this.fields()[28].schema(), (Object)other.totalCalories);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[29].schema(), (Object)other.day);
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
        }

        private Builder(OuraDailyActivity other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.score);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activeCalories)) {
                this.activeCalories = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activeCalories);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.averageMetMinutes)) {
                this.averageMetMinutes = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.averageMetMinutes);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorMeetDailyTargets)) {
                this.contributorMeetDailyTargets = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorMeetDailyTargets);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorMoveEveryHour)) {
                this.contributorMoveEveryHour = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorMoveEveryHour);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorRecoveryTime)) {
                this.contributorRecoveryTime = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorRecoveryTime);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorStayActive)) {
                this.contributorStayActive = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorStayActive);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.contributorTrainingFrequency)) {
                this.contributorTrainingFrequency = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.contributorTrainingFrequency);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.contributorTrainingVolume)) {
                this.contributorTrainingVolume = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.contributorTrainingVolume);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.equivalentWalkingDistance)) {
                this.equivalentWalkingDistance = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.equivalentWalkingDistance);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.highActivityMetMinutes)) {
                this.highActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.highActivityMetMinutes);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.highActivityTime)) {
                this.highActivityTime = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.highActivityTime);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.inactivityAlerts)) {
                this.inactivityAlerts = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.inactivityAlerts);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.lowActivityMetMinutes)) {
                this.lowActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.lowActivityMetMinutes);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.lowActivityTime)) {
                this.lowActivityTime = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.lowActivityTime);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.mediumActivityMetMinutes)) {
                this.mediumActivityMetMinutes = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.mediumActivityMetMinutes);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.mediumActivityTime)) {
                this.mediumActivityTime = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.mediumActivityTime);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.metersToTarget)) {
                this.metersToTarget = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.metersToTarget);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.nonWearTime)) {
                this.nonWearTime = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.nonWearTime);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.restingTime)) {
                this.restingTime = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.restingTime);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.sedentaryMetMinutes)) {
                this.sedentaryMetMinutes = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.sedentaryMetMinutes);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.sedentaryTime)) {
                this.sedentaryTime = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.sedentaryTime);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.steps);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.targetCalories)) {
                this.targetCalories = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.targetCalories);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.targetMeters)) {
                this.targetMeters = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.targetMeters);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.totalCalories)) {
                this.totalCalories = (Integer)this.data().deepCopy(this.fields()[28].schema(), (Object)other.totalCalories);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[29].schema(), (Object)other.day);
                this.fieldSetFlags()[29] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getScore() {
            return this.score;
        }

        public Builder setScore(Integer value) {
            this.validate(this.fields()[3], value);
            this.score = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearScore() {
            this.score = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getActiveCalories() {
            return this.activeCalories;
        }

        public Builder setActiveCalories(Integer value) {
            this.validate(this.fields()[4], value);
            this.activeCalories = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasActiveCalories() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearActiveCalories() {
            this.activeCalories = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getAverageMetMinutes() {
            return this.averageMetMinutes;
        }

        public Builder setAverageMetMinutes(Float value) {
            this.validate(this.fields()[5], value);
            this.averageMetMinutes = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAverageMetMinutes() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAverageMetMinutes() {
            this.averageMetMinutes = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getContributorMeetDailyTargets() {
            return this.contributorMeetDailyTargets;
        }

        public Builder setContributorMeetDailyTargets(Integer value) {
            this.validate(this.fields()[6], value);
            this.contributorMeetDailyTargets = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasContributorMeetDailyTargets() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearContributorMeetDailyTargets() {
            this.contributorMeetDailyTargets = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getContributorMoveEveryHour() {
            return this.contributorMoveEveryHour;
        }

        public Builder setContributorMoveEveryHour(Integer value) {
            this.validate(this.fields()[7], value);
            this.contributorMoveEveryHour = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasContributorMoveEveryHour() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearContributorMoveEveryHour() {
            this.contributorMoveEveryHour = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getContributorRecoveryTime() {
            return this.contributorRecoveryTime;
        }

        public Builder setContributorRecoveryTime(Integer value) {
            this.validate(this.fields()[8], value);
            this.contributorRecoveryTime = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasContributorRecoveryTime() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearContributorRecoveryTime() {
            this.contributorRecoveryTime = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getContributorStayActive() {
            return this.contributorStayActive;
        }

        public Builder setContributorStayActive(Integer value) {
            this.validate(this.fields()[9], value);
            this.contributorStayActive = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasContributorStayActive() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearContributorStayActive() {
            this.contributorStayActive = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getContributorTrainingFrequency() {
            return this.contributorTrainingFrequency;
        }

        public Builder setContributorTrainingFrequency(Integer value) {
            this.validate(this.fields()[10], value);
            this.contributorTrainingFrequency = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasContributorTrainingFrequency() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearContributorTrainingFrequency() {
            this.contributorTrainingFrequency = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getContributorTrainingVolume() {
            return this.contributorTrainingVolume;
        }

        public Builder setContributorTrainingVolume(Integer value) {
            this.validate(this.fields()[11], value);
            this.contributorTrainingVolume = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasContributorTrainingVolume() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearContributorTrainingVolume() {
            this.contributorTrainingVolume = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getEquivalentWalkingDistance() {
            return this.equivalentWalkingDistance;
        }

        public Builder setEquivalentWalkingDistance(Integer value) {
            this.validate(this.fields()[12], value);
            this.equivalentWalkingDistance = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasEquivalentWalkingDistance() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearEquivalentWalkingDistance() {
            this.equivalentWalkingDistance = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Integer getHighActivityMetMinutes() {
            return this.highActivityMetMinutes;
        }

        public Builder setHighActivityMetMinutes(Integer value) {
            this.validate(this.fields()[13], value);
            this.highActivityMetMinutes = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasHighActivityMetMinutes() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearHighActivityMetMinutes() {
            this.highActivityMetMinutes = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Integer getHighActivityTime() {
            return this.highActivityTime;
        }

        public Builder setHighActivityTime(Integer value) {
            this.validate(this.fields()[14], value);
            this.highActivityTime = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasHighActivityTime() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearHighActivityTime() {
            this.highActivityTime = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Integer getInactivityAlerts() {
            return this.inactivityAlerts;
        }

        public Builder setInactivityAlerts(Integer value) {
            this.validate(this.fields()[15], value);
            this.inactivityAlerts = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasInactivityAlerts() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearInactivityAlerts() {
            this.inactivityAlerts = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Integer getLowActivityMetMinutes() {
            return this.lowActivityMetMinutes;
        }

        public Builder setLowActivityMetMinutes(Integer value) {
            this.validate(this.fields()[16], value);
            this.lowActivityMetMinutes = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasLowActivityMetMinutes() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearLowActivityMetMinutes() {
            this.lowActivityMetMinutes = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getLowActivityTime() {
            return this.lowActivityTime;
        }

        public Builder setLowActivityTime(Integer value) {
            this.validate(this.fields()[17], value);
            this.lowActivityTime = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasLowActivityTime() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearLowActivityTime() {
            this.lowActivityTime = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Integer getMediumActivityMetMinutes() {
            return this.mediumActivityMetMinutes;
        }

        public Builder setMediumActivityMetMinutes(Integer value) {
            this.validate(this.fields()[18], value);
            this.mediumActivityMetMinutes = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasMediumActivityMetMinutes() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearMediumActivityMetMinutes() {
            this.mediumActivityMetMinutes = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Integer getMediumActivityTime() {
            return this.mediumActivityTime;
        }

        public Builder setMediumActivityTime(Integer value) {
            this.validate(this.fields()[19], value);
            this.mediumActivityTime = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasMediumActivityTime() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearMediumActivityTime() {
            this.mediumActivityTime = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Integer getMetersToTarget() {
            return this.metersToTarget;
        }

        public Builder setMetersToTarget(Integer value) {
            this.validate(this.fields()[20], value);
            this.metersToTarget = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasMetersToTarget() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearMetersToTarget() {
            this.metersToTarget = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Integer getNonWearTime() {
            return this.nonWearTime;
        }

        public Builder setNonWearTime(Integer value) {
            this.validate(this.fields()[21], value);
            this.nonWearTime = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasNonWearTime() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearNonWearTime() {
            this.nonWearTime = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Integer getRestingTime() {
            return this.restingTime;
        }

        public Builder setRestingTime(Integer value) {
            this.validate(this.fields()[22], value);
            this.restingTime = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasRestingTime() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearRestingTime() {
            this.restingTime = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Integer getSedentaryMetMinutes() {
            return this.sedentaryMetMinutes;
        }

        public Builder setSedentaryMetMinutes(Integer value) {
            this.validate(this.fields()[23], value);
            this.sedentaryMetMinutes = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasSedentaryMetMinutes() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearSedentaryMetMinutes() {
            this.sedentaryMetMinutes = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Integer getSedentaryTime() {
            return this.sedentaryTime;
        }

        public Builder setSedentaryTime(Integer value) {
            this.validate(this.fields()[24], value);
            this.sedentaryTime = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasSedentaryTime() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearSedentaryTime() {
            this.sedentaryTime = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Integer getSteps() {
            return this.steps;
        }

        public Builder setSteps(Integer value) {
            this.validate(this.fields()[25], value);
            this.steps = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasSteps() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearSteps() {
            this.steps = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public Integer getTargetCalories() {
            return this.targetCalories;
        }

        public Builder setTargetCalories(Integer value) {
            this.validate(this.fields()[26], value);
            this.targetCalories = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasTargetCalories() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearTargetCalories() {
            this.targetCalories = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Integer getTargetMeters() {
            return this.targetMeters;
        }

        public Builder setTargetMeters(Integer value) {
            this.validate(this.fields()[27], value);
            this.targetMeters = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasTargetMeters() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearTargetMeters() {
            this.targetMeters = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public Integer getTotalCalories() {
            return this.totalCalories;
        }

        public Builder setTotalCalories(Integer value) {
            this.validate(this.fields()[28], value);
            this.totalCalories = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasTotalCalories() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearTotalCalories() {
            this.totalCalories = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[29], value);
            this.day = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public OuraDailyActivity build() {
            try {
                OuraDailyActivity record = new OuraDailyActivity();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.score = this.fieldSetFlags()[3] ? this.score : (Integer)this.defaultValue(this.fields()[3]);
                record.activeCalories = this.fieldSetFlags()[4] ? this.activeCalories : (Integer)this.defaultValue(this.fields()[4]);
                record.averageMetMinutes = this.fieldSetFlags()[5] ? this.averageMetMinutes : (Float)this.defaultValue(this.fields()[5]);
                record.contributorMeetDailyTargets = this.fieldSetFlags()[6] ? this.contributorMeetDailyTargets : (Integer)this.defaultValue(this.fields()[6]);
                record.contributorMoveEveryHour = this.fieldSetFlags()[7] ? this.contributorMoveEveryHour : (Integer)this.defaultValue(this.fields()[7]);
                record.contributorRecoveryTime = this.fieldSetFlags()[8] ? this.contributorRecoveryTime : (Integer)this.defaultValue(this.fields()[8]);
                record.contributorStayActive = this.fieldSetFlags()[9] ? this.contributorStayActive : (Integer)this.defaultValue(this.fields()[9]);
                record.contributorTrainingFrequency = this.fieldSetFlags()[10] ? this.contributorTrainingFrequency : (Integer)this.defaultValue(this.fields()[10]);
                record.contributorTrainingVolume = this.fieldSetFlags()[11] ? this.contributorTrainingVolume : (Integer)this.defaultValue(this.fields()[11]);
                record.equivalentWalkingDistance = this.fieldSetFlags()[12] ? this.equivalentWalkingDistance : (Integer)this.defaultValue(this.fields()[12]);
                record.highActivityMetMinutes = this.fieldSetFlags()[13] ? this.highActivityMetMinutes : (Integer)this.defaultValue(this.fields()[13]);
                record.highActivityTime = this.fieldSetFlags()[14] ? this.highActivityTime : (Integer)this.defaultValue(this.fields()[14]);
                record.inactivityAlerts = this.fieldSetFlags()[15] ? this.inactivityAlerts : (Integer)this.defaultValue(this.fields()[15]);
                record.lowActivityMetMinutes = this.fieldSetFlags()[16] ? this.lowActivityMetMinutes : (Integer)this.defaultValue(this.fields()[16]);
                record.lowActivityTime = this.fieldSetFlags()[17] ? this.lowActivityTime : (Integer)this.defaultValue(this.fields()[17]);
                record.mediumActivityMetMinutes = this.fieldSetFlags()[18] ? this.mediumActivityMetMinutes : (Integer)this.defaultValue(this.fields()[18]);
                record.mediumActivityTime = this.fieldSetFlags()[19] ? this.mediumActivityTime : (Integer)this.defaultValue(this.fields()[19]);
                record.metersToTarget = this.fieldSetFlags()[20] ? this.metersToTarget : (Integer)this.defaultValue(this.fields()[20]);
                record.nonWearTime = this.fieldSetFlags()[21] ? this.nonWearTime : (Integer)this.defaultValue(this.fields()[21]);
                record.restingTime = this.fieldSetFlags()[22] ? this.restingTime : (Integer)this.defaultValue(this.fields()[22]);
                record.sedentaryMetMinutes = this.fieldSetFlags()[23] ? this.sedentaryMetMinutes : (Integer)this.defaultValue(this.fields()[23]);
                record.sedentaryTime = this.fieldSetFlags()[24] ? this.sedentaryTime : (Integer)this.defaultValue(this.fields()[24]);
                record.steps = this.fieldSetFlags()[25] ? this.steps : (Integer)this.defaultValue(this.fields()[25]);
                record.targetCalories = this.fieldSetFlags()[26] ? this.targetCalories : (Integer)this.defaultValue(this.fields()[26]);
                record.targetMeters = this.fieldSetFlags()[27] ? this.targetMeters : (Integer)this.defaultValue(this.fields()[27]);
                record.totalCalories = this.fieldSetFlags()[28] ? this.totalCalories : (Integer)this.defaultValue(this.fields()[28]);
                record.day = this.fieldSetFlags()[29] ? this.day : (String)this.defaultValue(this.fields()[29]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

