/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class OuraDailyReadiness
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3759072811165371778L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraDailyReadiness\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"This includes the daily readiness summary values. Readiness tells how ready you are for the day.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time the daily readiness record belongs to in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the readiness data from Oura.\",\"default\":null},{\"name\":\"contributorActivityBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of cumulative activity balance in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorBodyTemperature\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of body temperature in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorHrvBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of heart rate variability balance in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorPreviousDayActivity\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous day's activity in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorPreviousNight\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous night's sleep in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorRecoveryIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of previous 7-day exercise volume in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorRestingHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of resting heart rate in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"contributorSleepBalance\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of sleep balance in range [1, 100] to the readiness score. Null if unknown.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Day that the daily readiness belongs to. Null if unknown.\",\"default\":null},{\"name\":\"score\",\"type\":[\"null\",\"int\"],\"doc\":\"Daily readiness score in range [1, 100]. Null if unknown.\",\"default\":null},{\"name\":\"temperatureDeviation\",\"type\":[\"null\",\"float\"],\"doc\":\"Temperature deviation in degrees Celsius. Null if unknown.\",\"default\":null},{\"name\":\"temperatureTrendDeviation\",\"type\":[\"null\",\"float\"],\"doc\":\"Temperature trend deviation in degrees Celsius. Null if unknown.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraDailyReadiness> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraDailyReadiness> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private Integer contributorActivityBalance;
    private Integer contributorBodyTemperature;
    private Integer contributorHrvBalance;
    private Integer contributorPreviousDayActivity;
    private Integer contributorPreviousNight;
    private Integer contributorRecoveryIndex;
    private Integer contributorRestingHeartRate;
    private Integer contributorSleepBalance;
    private String day;
    private Integer score;
    private Float temperatureDeviation;
    private Float temperatureTrendDeviation;
    private static final DatumWriter<OuraDailyReadiness> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraDailyReadiness> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraDailyReadiness> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraDailyReadiness> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraDailyReadiness> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraDailyReadiness fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraDailyReadiness)((Object)DECODER.decode(b));
    }

    public OuraDailyReadiness() {
    }

    public OuraDailyReadiness(Double time, Double timeReceived, String id, Integer contributorActivityBalance, Integer contributorBodyTemperature, Integer contributorHrvBalance, Integer contributorPreviousDayActivity, Integer contributorPreviousNight, Integer contributorRecoveryIndex, Integer contributorRestingHeartRate, Integer contributorSleepBalance, String day, Integer score, Float temperatureDeviation, Float temperatureTrendDeviation) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.contributorActivityBalance = contributorActivityBalance;
        this.contributorBodyTemperature = contributorBodyTemperature;
        this.contributorHrvBalance = contributorHrvBalance;
        this.contributorPreviousDayActivity = contributorPreviousDayActivity;
        this.contributorPreviousNight = contributorPreviousNight;
        this.contributorRecoveryIndex = contributorRecoveryIndex;
        this.contributorRestingHeartRate = contributorRestingHeartRate;
        this.contributorSleepBalance = contributorSleepBalance;
        this.day = day;
        this.score = score;
        this.temperatureDeviation = temperatureDeviation;
        this.temperatureTrendDeviation = temperatureTrendDeviation;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.contributorActivityBalance;
            }
            case 4: {
                return this.contributorBodyTemperature;
            }
            case 5: {
                return this.contributorHrvBalance;
            }
            case 6: {
                return this.contributorPreviousDayActivity;
            }
            case 7: {
                return this.contributorPreviousNight;
            }
            case 8: {
                return this.contributorRecoveryIndex;
            }
            case 9: {
                return this.contributorRestingHeartRate;
            }
            case 10: {
                return this.contributorSleepBalance;
            }
            case 11: {
                return this.day;
            }
            case 12: {
                return this.score;
            }
            case 13: {
                return this.temperatureDeviation;
            }
            case 14: {
                return this.temperatureTrendDeviation;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.contributorActivityBalance = (Integer)value$;
                break;
            }
            case 4: {
                this.contributorBodyTemperature = (Integer)value$;
                break;
            }
            case 5: {
                this.contributorHrvBalance = (Integer)value$;
                break;
            }
            case 6: {
                this.contributorPreviousDayActivity = (Integer)value$;
                break;
            }
            case 7: {
                this.contributorPreviousNight = (Integer)value$;
                break;
            }
            case 8: {
                this.contributorRecoveryIndex = (Integer)value$;
                break;
            }
            case 9: {
                this.contributorRestingHeartRate = (Integer)value$;
                break;
            }
            case 10: {
                this.contributorSleepBalance = (Integer)value$;
                break;
            }
            case 11: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            case 12: {
                this.score = (Integer)value$;
                break;
            }
            case 13: {
                this.temperatureDeviation = (Float)value$;
                break;
            }
            case 14: {
                this.temperatureTrendDeviation = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Integer getContributorActivityBalance() {
        return this.contributorActivityBalance;
    }

    public void setContributorActivityBalance(Integer value) {
        this.contributorActivityBalance = value;
    }

    public Integer getContributorBodyTemperature() {
        return this.contributorBodyTemperature;
    }

    public void setContributorBodyTemperature(Integer value) {
        this.contributorBodyTemperature = value;
    }

    public Integer getContributorHrvBalance() {
        return this.contributorHrvBalance;
    }

    public void setContributorHrvBalance(Integer value) {
        this.contributorHrvBalance = value;
    }

    public Integer getContributorPreviousDayActivity() {
        return this.contributorPreviousDayActivity;
    }

    public void setContributorPreviousDayActivity(Integer value) {
        this.contributorPreviousDayActivity = value;
    }

    public Integer getContributorPreviousNight() {
        return this.contributorPreviousNight;
    }

    public void setContributorPreviousNight(Integer value) {
        this.contributorPreviousNight = value;
    }

    public Integer getContributorRecoveryIndex() {
        return this.contributorRecoveryIndex;
    }

    public void setContributorRecoveryIndex(Integer value) {
        this.contributorRecoveryIndex = value;
    }

    public Integer getContributorRestingHeartRate() {
        return this.contributorRestingHeartRate;
    }

    public void setContributorRestingHeartRate(Integer value) {
        this.contributorRestingHeartRate = value;
    }

    public Integer getContributorSleepBalance() {
        return this.contributorSleepBalance;
    }

    public void setContributorSleepBalance(Integer value) {
        this.contributorSleepBalance = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer value) {
        this.score = value;
    }

    public Float getTemperatureDeviation() {
        return this.temperatureDeviation;
    }

    public void setTemperatureDeviation(Float value) {
        this.temperatureDeviation = value;
    }

    public Float getTemperatureTrendDeviation() {
        return this.temperatureTrendDeviation;
    }

    public void setTemperatureTrendDeviation(Float value) {
        this.temperatureTrendDeviation = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraDailyReadiness other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.contributorActivityBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorActivityBalance.intValue());
        }
        if (this.contributorBodyTemperature == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorBodyTemperature.intValue());
        }
        if (this.contributorHrvBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorHrvBalance.intValue());
        }
        if (this.contributorPreviousDayActivity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorPreviousDayActivity.intValue());
        }
        if (this.contributorPreviousNight == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorPreviousNight.intValue());
        }
        if (this.contributorRecoveryIndex == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorRecoveryIndex.intValue());
        }
        if (this.contributorRestingHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorRestingHeartRate.intValue());
        }
        if (this.contributorSleepBalance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorSleepBalance.intValue());
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
        if (this.score == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.score.intValue());
        }
        if (this.temperatureDeviation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.temperatureDeviation.floatValue());
        }
        if (this.temperatureTrendDeviation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.temperatureTrendDeviation.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorActivityBalance = null;
            } else {
                this.contributorActivityBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorBodyTemperature = null;
            } else {
                this.contributorBodyTemperature = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorHrvBalance = null;
            } else {
                this.contributorHrvBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorPreviousDayActivity = null;
            } else {
                this.contributorPreviousDayActivity = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorPreviousNight = null;
            } else {
                this.contributorPreviousNight = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorRecoveryIndex = null;
            } else {
                this.contributorRecoveryIndex = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorRestingHeartRate = null;
            } else {
                this.contributorRestingHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorSleepBalance = null;
            } else {
                this.contributorSleepBalance = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.score = null;
            } else {
                this.score = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.temperatureDeviation = null;
            } else {
                this.temperatureDeviation = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.temperatureTrendDeviation = null;
            } else {
                this.temperatureTrendDeviation = Float.valueOf(in.readFloat());
            }
        } else {
            block17: for (int i = 0; i < 15; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block17;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block17;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block17;
                        }
                        this.id = in.readString();
                        continue block17;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorActivityBalance = null;
                            continue block17;
                        }
                        this.contributorActivityBalance = in.readInt();
                        continue block17;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorBodyTemperature = null;
                            continue block17;
                        }
                        this.contributorBodyTemperature = in.readInt();
                        continue block17;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorHrvBalance = null;
                            continue block17;
                        }
                        this.contributorHrvBalance = in.readInt();
                        continue block17;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorPreviousDayActivity = null;
                            continue block17;
                        }
                        this.contributorPreviousDayActivity = in.readInt();
                        continue block17;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorPreviousNight = null;
                            continue block17;
                        }
                        this.contributorPreviousNight = in.readInt();
                        continue block17;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorRecoveryIndex = null;
                            continue block17;
                        }
                        this.contributorRecoveryIndex = in.readInt();
                        continue block17;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorRestingHeartRate = null;
                            continue block17;
                        }
                        this.contributorRestingHeartRate = in.readInt();
                        continue block17;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorSleepBalance = null;
                            continue block17;
                        }
                        this.contributorSleepBalance = in.readInt();
                        continue block17;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block17;
                        }
                        this.day = in.readString();
                        continue block17;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.score = null;
                            continue block17;
                        }
                        this.score = in.readInt();
                        continue block17;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.temperatureDeviation = null;
                            continue block17;
                        }
                        this.temperatureDeviation = Float.valueOf(in.readFloat());
                        continue block17;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.temperatureTrendDeviation = null;
                            continue block17;
                        }
                        this.temperatureTrendDeviation = Float.valueOf(in.readFloat());
                        continue block17;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraDailyReadiness>
    implements RecordBuilder<OuraDailyReadiness> {
        private double time;
        private double timeReceived;
        private String id;
        private Integer contributorActivityBalance;
        private Integer contributorBodyTemperature;
        private Integer contributorHrvBalance;
        private Integer contributorPreviousDayActivity;
        private Integer contributorPreviousNight;
        private Integer contributorRecoveryIndex;
        private Integer contributorRestingHeartRate;
        private Integer contributorSleepBalance;
        private String day;
        private Integer score;
        private Float temperatureDeviation;
        private Float temperatureTrendDeviation;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.contributorActivityBalance)) {
                this.contributorActivityBalance = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.contributorActivityBalance);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.contributorBodyTemperature)) {
                this.contributorBodyTemperature = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.contributorBodyTemperature);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.contributorHrvBalance)) {
                this.contributorHrvBalance = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.contributorHrvBalance);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorPreviousDayActivity)) {
                this.contributorPreviousDayActivity = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorPreviousDayActivity);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorPreviousNight)) {
                this.contributorPreviousNight = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorPreviousNight);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorRecoveryIndex)) {
                this.contributorRecoveryIndex = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorRecoveryIndex);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorRestingHeartRate)) {
                this.contributorRestingHeartRate = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorRestingHeartRate);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.contributorSleepBalance)) {
                this.contributorSleepBalance = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.contributorSleepBalance);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.day);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.score);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.temperatureDeviation)) {
                this.temperatureDeviation = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.temperatureDeviation);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.temperatureTrendDeviation)) {
                this.temperatureTrendDeviation = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.temperatureTrendDeviation);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
        }

        private Builder(OuraDailyReadiness other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.contributorActivityBalance)) {
                this.contributorActivityBalance = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.contributorActivityBalance);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.contributorBodyTemperature)) {
                this.contributorBodyTemperature = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.contributorBodyTemperature);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.contributorHrvBalance)) {
                this.contributorHrvBalance = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.contributorHrvBalance);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorPreviousDayActivity)) {
                this.contributorPreviousDayActivity = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorPreviousDayActivity);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorPreviousNight)) {
                this.contributorPreviousNight = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorPreviousNight);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorRecoveryIndex)) {
                this.contributorRecoveryIndex = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorRecoveryIndex);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorRestingHeartRate)) {
                this.contributorRestingHeartRate = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorRestingHeartRate);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.contributorSleepBalance)) {
                this.contributorSleepBalance = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.contributorSleepBalance);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.day);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.score);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.temperatureDeviation)) {
                this.temperatureDeviation = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.temperatureDeviation);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.temperatureTrendDeviation)) {
                this.temperatureTrendDeviation = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.temperatureTrendDeviation);
                this.fieldSetFlags()[14] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getContributorActivityBalance() {
            return this.contributorActivityBalance;
        }

        public Builder setContributorActivityBalance(Integer value) {
            this.validate(this.fields()[3], value);
            this.contributorActivityBalance = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasContributorActivityBalance() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearContributorActivityBalance() {
            this.contributorActivityBalance = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getContributorBodyTemperature() {
            return this.contributorBodyTemperature;
        }

        public Builder setContributorBodyTemperature(Integer value) {
            this.validate(this.fields()[4], value);
            this.contributorBodyTemperature = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasContributorBodyTemperature() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearContributorBodyTemperature() {
            this.contributorBodyTemperature = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getContributorHrvBalance() {
            return this.contributorHrvBalance;
        }

        public Builder setContributorHrvBalance(Integer value) {
            this.validate(this.fields()[5], value);
            this.contributorHrvBalance = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasContributorHrvBalance() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearContributorHrvBalance() {
            this.contributorHrvBalance = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getContributorPreviousDayActivity() {
            return this.contributorPreviousDayActivity;
        }

        public Builder setContributorPreviousDayActivity(Integer value) {
            this.validate(this.fields()[6], value);
            this.contributorPreviousDayActivity = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasContributorPreviousDayActivity() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearContributorPreviousDayActivity() {
            this.contributorPreviousDayActivity = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getContributorPreviousNight() {
            return this.contributorPreviousNight;
        }

        public Builder setContributorPreviousNight(Integer value) {
            this.validate(this.fields()[7], value);
            this.contributorPreviousNight = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasContributorPreviousNight() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearContributorPreviousNight() {
            this.contributorPreviousNight = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getContributorRecoveryIndex() {
            return this.contributorRecoveryIndex;
        }

        public Builder setContributorRecoveryIndex(Integer value) {
            this.validate(this.fields()[8], value);
            this.contributorRecoveryIndex = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasContributorRecoveryIndex() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearContributorRecoveryIndex() {
            this.contributorRecoveryIndex = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getContributorRestingHeartRate() {
            return this.contributorRestingHeartRate;
        }

        public Builder setContributorRestingHeartRate(Integer value) {
            this.validate(this.fields()[9], value);
            this.contributorRestingHeartRate = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasContributorRestingHeartRate() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearContributorRestingHeartRate() {
            this.contributorRestingHeartRate = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getContributorSleepBalance() {
            return this.contributorSleepBalance;
        }

        public Builder setContributorSleepBalance(Integer value) {
            this.validate(this.fields()[10], value);
            this.contributorSleepBalance = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasContributorSleepBalance() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearContributorSleepBalance() {
            this.contributorSleepBalance = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[11], value);
            this.day = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getScore() {
            return this.score;
        }

        public Builder setScore(Integer value) {
            this.validate(this.fields()[12], value);
            this.score = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearScore() {
            this.score = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Float getTemperatureDeviation() {
            return this.temperatureDeviation;
        }

        public Builder setTemperatureDeviation(Float value) {
            this.validate(this.fields()[13], value);
            this.temperatureDeviation = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasTemperatureDeviation() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearTemperatureDeviation() {
            this.temperatureDeviation = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Float getTemperatureTrendDeviation() {
            return this.temperatureTrendDeviation;
        }

        public Builder setTemperatureTrendDeviation(Float value) {
            this.validate(this.fields()[14], value);
            this.temperatureTrendDeviation = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasTemperatureTrendDeviation() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearTemperatureTrendDeviation() {
            this.temperatureTrendDeviation = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public OuraDailyReadiness build() {
            try {
                OuraDailyReadiness record = new OuraDailyReadiness();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.contributorActivityBalance = this.fieldSetFlags()[3] ? this.contributorActivityBalance : (Integer)this.defaultValue(this.fields()[3]);
                record.contributorBodyTemperature = this.fieldSetFlags()[4] ? this.contributorBodyTemperature : (Integer)this.defaultValue(this.fields()[4]);
                record.contributorHrvBalance = this.fieldSetFlags()[5] ? this.contributorHrvBalance : (Integer)this.defaultValue(this.fields()[5]);
                record.contributorPreviousDayActivity = this.fieldSetFlags()[6] ? this.contributorPreviousDayActivity : (Integer)this.defaultValue(this.fields()[6]);
                record.contributorPreviousNight = this.fieldSetFlags()[7] ? this.contributorPreviousNight : (Integer)this.defaultValue(this.fields()[7]);
                record.contributorRecoveryIndex = this.fieldSetFlags()[8] ? this.contributorRecoveryIndex : (Integer)this.defaultValue(this.fields()[8]);
                record.contributorRestingHeartRate = this.fieldSetFlags()[9] ? this.contributorRestingHeartRate : (Integer)this.defaultValue(this.fields()[9]);
                record.contributorSleepBalance = this.fieldSetFlags()[10] ? this.contributorSleepBalance : (Integer)this.defaultValue(this.fields()[10]);
                record.day = this.fieldSetFlags()[11] ? this.day : (String)this.defaultValue(this.fields()[11]);
                record.score = this.fieldSetFlags()[12] ? this.score : (Integer)this.defaultValue(this.fields()[12]);
                record.temperatureDeviation = this.fieldSetFlags()[13] ? this.temperatureDeviation : (Float)this.defaultValue(this.fields()[13]);
                record.temperatureTrendDeviation = this.fieldSetFlags()[14] ? this.temperatureTrendDeviation : (Float)this.defaultValue(this.fields()[14]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

