/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class OuraDailySleep
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5012237256954992704L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraDailySleep\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"This includes the daily sleep summary values. Sleep period is a nearly continuous, longish period of time spent lying down in bed.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sleep in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the sleep data from Oura.\",\"default\":null},{\"name\":\"contributorDeepSleep\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of deep sleep in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorEfficiency\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of sleep efficiency in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorLatency\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of sleep latency in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorRemSleep\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of REM sleep in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorRestfulness\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of sleep restfulness in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorTiming\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of sleep timing in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"contributorTotalSleep\",\"type\":[\"null\",\"int\"],\"doc\":\"Contribution of total sleep in range [1, 100] to the sleep score. Null if unknown.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Day that the daily sleep belongs to. Null if unknown.\",\"default\":null},{\"name\":\"score\",\"type\":[\"null\",\"int\"],\"doc\":\"Daily sleep score in range [1, 100]. Null if unknown.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraDailySleep> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraDailySleep> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String id;
    private Integer contributorDeepSleep;
    private Integer contributorEfficiency;
    private Integer contributorLatency;
    private Integer contributorRemSleep;
    private Integer contributorRestfulness;
    private Integer contributorTiming;
    private Integer contributorTotalSleep;
    private String day;
    private Integer score;
    private static final DatumWriter<OuraDailySleep> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraDailySleep> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraDailySleep> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraDailySleep> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraDailySleep> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraDailySleep fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraDailySleep)((Object)DECODER.decode(b));
    }

    public OuraDailySleep() {
    }

    public OuraDailySleep(Double time, Double timeReceived, String id, Integer contributorDeepSleep, Integer contributorEfficiency, Integer contributorLatency, Integer contributorRemSleep, Integer contributorRestfulness, Integer contributorTiming, Integer contributorTotalSleep, String day, Integer score) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.contributorDeepSleep = contributorDeepSleep;
        this.contributorEfficiency = contributorEfficiency;
        this.contributorLatency = contributorLatency;
        this.contributorRemSleep = contributorRemSleep;
        this.contributorRestfulness = contributorRestfulness;
        this.contributorTiming = contributorTiming;
        this.contributorTotalSleep = contributorTotalSleep;
        this.day = day;
        this.score = score;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.contributorDeepSleep;
            }
            case 4: {
                return this.contributorEfficiency;
            }
            case 5: {
                return this.contributorLatency;
            }
            case 6: {
                return this.contributorRemSleep;
            }
            case 7: {
                return this.contributorRestfulness;
            }
            case 8: {
                return this.contributorTiming;
            }
            case 9: {
                return this.contributorTotalSleep;
            }
            case 10: {
                return this.day;
            }
            case 11: {
                return this.score;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.contributorDeepSleep = (Integer)value$;
                break;
            }
            case 4: {
                this.contributorEfficiency = (Integer)value$;
                break;
            }
            case 5: {
                this.contributorLatency = (Integer)value$;
                break;
            }
            case 6: {
                this.contributorRemSleep = (Integer)value$;
                break;
            }
            case 7: {
                this.contributorRestfulness = (Integer)value$;
                break;
            }
            case 8: {
                this.contributorTiming = (Integer)value$;
                break;
            }
            case 9: {
                this.contributorTotalSleep = (Integer)value$;
                break;
            }
            case 10: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            case 11: {
                this.score = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Integer getContributorDeepSleep() {
        return this.contributorDeepSleep;
    }

    public void setContributorDeepSleep(Integer value) {
        this.contributorDeepSleep = value;
    }

    public Integer getContributorEfficiency() {
        return this.contributorEfficiency;
    }

    public void setContributorEfficiency(Integer value) {
        this.contributorEfficiency = value;
    }

    public Integer getContributorLatency() {
        return this.contributorLatency;
    }

    public void setContributorLatency(Integer value) {
        this.contributorLatency = value;
    }

    public Integer getContributorRemSleep() {
        return this.contributorRemSleep;
    }

    public void setContributorRemSleep(Integer value) {
        this.contributorRemSleep = value;
    }

    public Integer getContributorRestfulness() {
        return this.contributorRestfulness;
    }

    public void setContributorRestfulness(Integer value) {
        this.contributorRestfulness = value;
    }

    public Integer getContributorTiming() {
        return this.contributorTiming;
    }

    public void setContributorTiming(Integer value) {
        this.contributorTiming = value;
    }

    public Integer getContributorTotalSleep() {
        return this.contributorTotalSleep;
    }

    public void setContributorTotalSleep(Integer value) {
        this.contributorTotalSleep = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer value) {
        this.score = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraDailySleep other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.contributorDeepSleep == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorDeepSleep.intValue());
        }
        if (this.contributorEfficiency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorEfficiency.intValue());
        }
        if (this.contributorLatency == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorLatency.intValue());
        }
        if (this.contributorRemSleep == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorRemSleep.intValue());
        }
        if (this.contributorRestfulness == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorRestfulness.intValue());
        }
        if (this.contributorTiming == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorTiming.intValue());
        }
        if (this.contributorTotalSleep == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.contributorTotalSleep.intValue());
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
        if (this.score == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.score.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorDeepSleep = null;
            } else {
                this.contributorDeepSleep = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorEfficiency = null;
            } else {
                this.contributorEfficiency = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorLatency = null;
            } else {
                this.contributorLatency = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorRemSleep = null;
            } else {
                this.contributorRemSleep = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorRestfulness = null;
            } else {
                this.contributorRestfulness = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorTiming = null;
            } else {
                this.contributorTiming = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.contributorTotalSleep = null;
            } else {
                this.contributorTotalSleep = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.score = null;
            } else {
                this.score = in.readInt();
            }
        } else {
            block14: for (int i = 0; i < 12; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block14;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block14;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block14;
                        }
                        this.id = in.readString();
                        continue block14;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorDeepSleep = null;
                            continue block14;
                        }
                        this.contributorDeepSleep = in.readInt();
                        continue block14;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorEfficiency = null;
                            continue block14;
                        }
                        this.contributorEfficiency = in.readInt();
                        continue block14;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorLatency = null;
                            continue block14;
                        }
                        this.contributorLatency = in.readInt();
                        continue block14;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorRemSleep = null;
                            continue block14;
                        }
                        this.contributorRemSleep = in.readInt();
                        continue block14;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorRestfulness = null;
                            continue block14;
                        }
                        this.contributorRestfulness = in.readInt();
                        continue block14;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorTiming = null;
                            continue block14;
                        }
                        this.contributorTiming = in.readInt();
                        continue block14;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.contributorTotalSleep = null;
                            continue block14;
                        }
                        this.contributorTotalSleep = in.readInt();
                        continue block14;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block14;
                        }
                        this.day = in.readString();
                        continue block14;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.score = null;
                            continue block14;
                        }
                        this.score = in.readInt();
                        continue block14;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraDailySleep>
    implements RecordBuilder<OuraDailySleep> {
        private double time;
        private double timeReceived;
        private String id;
        private Integer contributorDeepSleep;
        private Integer contributorEfficiency;
        private Integer contributorLatency;
        private Integer contributorRemSleep;
        private Integer contributorRestfulness;
        private Integer contributorTiming;
        private Integer contributorTotalSleep;
        private String day;
        private Integer score;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.contributorDeepSleep)) {
                this.contributorDeepSleep = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.contributorDeepSleep);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.contributorEfficiency)) {
                this.contributorEfficiency = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.contributorEfficiency);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.contributorLatency)) {
                this.contributorLatency = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.contributorLatency);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorRemSleep)) {
                this.contributorRemSleep = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorRemSleep);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorRestfulness)) {
                this.contributorRestfulness = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorRestfulness);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorTiming)) {
                this.contributorTiming = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorTiming);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorTotalSleep)) {
                this.contributorTotalSleep = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorTotalSleep);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.day);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.score);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
        }

        private Builder(OuraDailySleep other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.contributorDeepSleep)) {
                this.contributorDeepSleep = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.contributorDeepSleep);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.contributorEfficiency)) {
                this.contributorEfficiency = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.contributorEfficiency);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.contributorLatency)) {
                this.contributorLatency = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.contributorLatency);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.contributorRemSleep)) {
                this.contributorRemSleep = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.contributorRemSleep);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.contributorRestfulness)) {
                this.contributorRestfulness = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.contributorRestfulness);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.contributorTiming)) {
                this.contributorTiming = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.contributorTiming);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.contributorTotalSleep)) {
                this.contributorTotalSleep = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.contributorTotalSleep);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.day);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.score)) {
                this.score = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.score);
                this.fieldSetFlags()[11] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getContributorDeepSleep() {
            return this.contributorDeepSleep;
        }

        public Builder setContributorDeepSleep(Integer value) {
            this.validate(this.fields()[3], value);
            this.contributorDeepSleep = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasContributorDeepSleep() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearContributorDeepSleep() {
            this.contributorDeepSleep = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getContributorEfficiency() {
            return this.contributorEfficiency;
        }

        public Builder setContributorEfficiency(Integer value) {
            this.validate(this.fields()[4], value);
            this.contributorEfficiency = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasContributorEfficiency() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearContributorEfficiency() {
            this.contributorEfficiency = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getContributorLatency() {
            return this.contributorLatency;
        }

        public Builder setContributorLatency(Integer value) {
            this.validate(this.fields()[5], value);
            this.contributorLatency = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasContributorLatency() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearContributorLatency() {
            this.contributorLatency = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getContributorRemSleep() {
            return this.contributorRemSleep;
        }

        public Builder setContributorRemSleep(Integer value) {
            this.validate(this.fields()[6], value);
            this.contributorRemSleep = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasContributorRemSleep() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearContributorRemSleep() {
            this.contributorRemSleep = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getContributorRestfulness() {
            return this.contributorRestfulness;
        }

        public Builder setContributorRestfulness(Integer value) {
            this.validate(this.fields()[7], value);
            this.contributorRestfulness = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasContributorRestfulness() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearContributorRestfulness() {
            this.contributorRestfulness = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getContributorTiming() {
            return this.contributorTiming;
        }

        public Builder setContributorTiming(Integer value) {
            this.validate(this.fields()[8], value);
            this.contributorTiming = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasContributorTiming() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearContributorTiming() {
            this.contributorTiming = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getContributorTotalSleep() {
            return this.contributorTotalSleep;
        }

        public Builder setContributorTotalSleep(Integer value) {
            this.validate(this.fields()[9], value);
            this.contributorTotalSleep = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasContributorTotalSleep() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearContributorTotalSleep() {
            this.contributorTotalSleep = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[10], value);
            this.day = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getScore() {
            return this.score;
        }

        public Builder setScore(Integer value) {
            this.validate(this.fields()[11], value);
            this.score = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearScore() {
            this.score = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public OuraDailySleep build() {
            try {
                OuraDailySleep record = new OuraDailySleep();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (String)this.defaultValue(this.fields()[2]);
                record.contributorDeepSleep = this.fieldSetFlags()[3] ? this.contributorDeepSleep : (Integer)this.defaultValue(this.fields()[3]);
                record.contributorEfficiency = this.fieldSetFlags()[4] ? this.contributorEfficiency : (Integer)this.defaultValue(this.fields()[4]);
                record.contributorLatency = this.fieldSetFlags()[5] ? this.contributorLatency : (Integer)this.defaultValue(this.fields()[5]);
                record.contributorRemSleep = this.fieldSetFlags()[6] ? this.contributorRemSleep : (Integer)this.defaultValue(this.fields()[6]);
                record.contributorRestfulness = this.fieldSetFlags()[7] ? this.contributorRestfulness : (Integer)this.defaultValue(this.fields()[7]);
                record.contributorTiming = this.fieldSetFlags()[8] ? this.contributorTiming : (Integer)this.defaultValue(this.fields()[8]);
                record.contributorTotalSleep = this.fieldSetFlags()[9] ? this.contributorTotalSleep : (Integer)this.defaultValue(this.fields()[9]);
                record.day = this.fieldSetFlags()[10] ? this.day : (String)this.defaultValue(this.fields()[10]);
                record.score = this.fieldSetFlags()[11] ? this.score : (Integer)this.defaultValue(this.fields()[11]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

