/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraMomentMood;
import org.radarcns.connector.oura.OuraMomentType;

@AvroGenerated
public class OuraSession
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5562103811079077116L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraSession\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"The Sessions data scope provides information on how users engage with guided and unguided sessions in the Oura app, including the user\u2019s biometric trends during the sessions.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the session in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"End time of the session in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the session from Oura.\",\"default\":null},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"OuraMomentType\",\"doc\":\"Possible Oura Moment types.\",\"symbols\":[\"BREATHING\",\"MEDITATION\",\"NAP\",\"RELAXATION\",\"REST\",\"BODY_STATUS\",\"UNKNOWN\"]},\"doc\":\"Oura Moment type. UNKNOWN when this data is not provided by Oura.\",\"default\":\"UNKNOWN\"},{\"name\":\"mood\",\"type\":{\"type\":\"enum\",\"name\":\"OuraMomentMood\",\"doc\":\"Possible Oura Moment moods.\",\"symbols\":[\"BAD\",\"WORSE\",\"SAME\",\"GOOD\",\"GREAT\",\"UNKNOWN\"]},\"doc\":\"Oura Moment mood. UNKNOWN when this data is not provided by Oura.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraSession> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraSession> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double endTime;
    private double timeReceived;
    private String id;
    private OuraMomentType type;
    private OuraMomentMood mood;
    private static final DatumWriter<OuraSession> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraSession> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraSession> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraSession> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraSession> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraSession fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraSession)((Object)DECODER.decode(b));
    }

    public OuraSession() {
    }

    public OuraSession(Double time, Double endTime, Double timeReceived, String id, OuraMomentType type, OuraMomentMood mood) {
        this.time = time;
        this.endTime = endTime;
        this.timeReceived = timeReceived;
        this.id = id;
        this.type = type;
        this.mood = mood;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.endTime;
            }
            case 2: {
                return this.timeReceived;
            }
            case 3: {
                return this.id;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.mood;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.endTime = (Double)value$;
                break;
            }
            case 2: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 3: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.type = (OuraMomentType)((Object)value$);
                break;
            }
            case 5: {
                this.mood = (OuraMomentMood)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double value) {
        this.endTime = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public OuraMomentType getType() {
        return this.type;
    }

    public void setType(OuraMomentType value) {
        this.type = value;
    }

    public OuraMomentMood getMood() {
        return this.mood;
    }

    public void setMood(OuraMomentMood value) {
        this.mood = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraSession other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.endTime);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        out.writeEnum(this.type.ordinal());
        out.writeEnum(this.mood.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.endTime = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            this.type = OuraMomentType.values()[in.readEnum()];
            this.mood = OuraMomentMood.values()[in.readEnum()];
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.endTime = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block8;
                        }
                        this.id = in.readString();
                        continue block8;
                    }
                    case 4: {
                        this.type = OuraMomentType.values()[in.readEnum()];
                        continue block8;
                    }
                    case 5: {
                        this.mood = OuraMomentMood.values()[in.readEnum()];
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraSession>
    implements RecordBuilder<OuraSession> {
        private double time;
        private double endTime;
        private double timeReceived;
        private String id;
        private OuraMomentType type;
        private OuraMomentMood mood;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.id);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type))) {
                this.type = (OuraMomentType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.mood))) {
                this.mood = (OuraMomentMood)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mood));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(OuraSession other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.id);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type))) {
                this.type = (OuraMomentType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.mood))) {
                this.mood = (OuraMomentMood)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.mood));
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(double value) {
            this.validate(this.fields()[1], value);
            this.endTime = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEndTime() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEndTime() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[2], value);
            this.timeReceived = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[3], value);
            this.id = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public OuraMomentType getType() {
            return this.type;
        }

        public Builder setType(OuraMomentType value) {
            this.validate(this.fields()[4], (Object)value);
            this.type = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public OuraMomentMood getMood() {
            return this.mood;
        }

        public Builder setMood(OuraMomentMood value) {
            this.validate(this.fields()[5], (Object)value);
            this.mood = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMood() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMood() {
            this.mood = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public OuraSession build() {
            try {
                OuraSession record = new OuraSession();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.endTime = this.fieldSetFlags()[1] ? this.endTime : (Double)this.defaultValue(this.fields()[1]);
                record.timeReceived = this.fieldSetFlags()[2] ? this.timeReceived : (Double)this.defaultValue(this.fields()[2]);
                record.id = this.fieldSetFlags()[3] ? this.id : (String)this.defaultValue(this.fields()[3]);
                record.type = this.fieldSetFlags()[4] ? this.type : (OuraMomentType)((Object)this.defaultValue(this.fields()[4]));
                record.mood = this.fieldSetFlags()[5] ? this.mood : (OuraMomentMood)((Object)this.defaultValue(this.fields()[5]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

