/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.oura;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.oura.OuraWorkoutIntensity;
import org.radarcns.connector.oura.OuraWorkoutSource;

@AvroGenerated
public class OuraWorkout
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3523377773323301979L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OuraWorkout\",\"namespace\":\"org.radarcns.connector.oura\",\"doc\":\"The Workout data scope includes information about user workouts. This is a diverse, growing list of workouts that help inform how the user is training and exercising.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the workout in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"End time of the workout in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Unique identifier of the workout from Oura.\",\"default\":null},{\"name\":\"activity\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Type of the workout activity.\",\"default\":null},{\"name\":\"calories\",\"type\":[\"null\",\"float\"],\"doc\":\"Energy burned in kilocalories during the workout. Null if unknown.\",\"default\":null},{\"name\":\"day\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Day when the workout occurred. Null if unknown.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled in meters during the workout. Null if unknown.\",\"default\":null},{\"name\":\"intensity\",\"type\":{\"type\":\"enum\",\"name\":\"OuraWorkoutIntensity\",\"doc\":\"Workout intensity as computed by Oura.\",\"symbols\":[\"EASY\",\"MODERATE\",\"HARD\",\"UNKNOWN\"]},\"doc\":\"Workout intensity as computed by Oura. UNKNOWN when this data is not provided by Oura.\",\"default\":\"UNKNOWN\"},{\"name\":\"label\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"User-defined label for the workout. Null if unknown.\",\"default\":null},{\"name\":\"source\",\"type\":{\"type\":\"enum\",\"name\":\"OuraWorkoutSource\",\"doc\":\"Workout source type as computed by Oura.\",\"symbols\":[\"MANUAL\",\"AUTODETECTED\",\"CONFIRMED\",\"WORKOUT_HEART_RATE\",\"UNKNOWN\"]},\"doc\":\"Workout source type as computed by Oura. UNKNOWN when this data is not provided by Oura.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OuraWorkout> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OuraWorkout> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double endTime;
    private double timeReceived;
    private String id;
    private String activity;
    private Float calories;
    private String day;
    private Float distance;
    private OuraWorkoutIntensity intensity;
    private String label;
    private OuraWorkoutSource source;
    private static final DatumWriter<OuraWorkout> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OuraWorkout> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OuraWorkout> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OuraWorkout> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OuraWorkout> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OuraWorkout fromByteBuffer(ByteBuffer b) throws IOException {
        return (OuraWorkout)((Object)DECODER.decode(b));
    }

    public OuraWorkout() {
    }

    public OuraWorkout(Double time, Double endTime, Double timeReceived, String id, String activity, Float calories, String day, Float distance, OuraWorkoutIntensity intensity, String label, OuraWorkoutSource source) {
        this.time = time;
        this.endTime = endTime;
        this.timeReceived = timeReceived;
        this.id = id;
        this.activity = activity;
        this.calories = calories;
        this.day = day;
        this.distance = distance;
        this.intensity = intensity;
        this.label = label;
        this.source = source;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.endTime;
            }
            case 2: {
                return this.timeReceived;
            }
            case 3: {
                return this.id;
            }
            case 4: {
                return this.activity;
            }
            case 5: {
                return this.calories;
            }
            case 6: {
                return this.day;
            }
            case 7: {
                return this.distance;
            }
            case 8: {
                return this.intensity;
            }
            case 9: {
                return this.label;
            }
            case 10: {
                return this.source;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.endTime = (Double)value$;
                break;
            }
            case 2: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 3: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.activity = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.calories = (Float)value$;
                break;
            }
            case 6: {
                this.day = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.distance = (Float)value$;
                break;
            }
            case 8: {
                this.intensity = (OuraWorkoutIntensity)((Object)value$);
                break;
            }
            case 9: {
                this.label = value$ != null ? value$.toString() : null;
                break;
            }
            case 10: {
                this.source = (OuraWorkoutSource)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double value) {
        this.endTime = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String value) {
        this.activity = value;
    }

    public Float getCalories() {
        return this.calories;
    }

    public void setCalories(Float value) {
        this.calories = value;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String value) {
        this.day = value;
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(Float value) {
        this.distance = value;
    }

    public OuraWorkoutIntensity getIntensity() {
        return this.intensity;
    }

    public void setIntensity(OuraWorkoutIntensity value) {
        this.intensity = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public OuraWorkoutSource getSource() {
        return this.source;
    }

    public void setSource(OuraWorkoutSource value) {
        this.source = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OuraWorkout other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.endTime);
        out.writeDouble(this.timeReceived);
        if (this.id == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.id);
        }
        if (this.activity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activity);
        }
        if (this.calories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.calories.floatValue());
        }
        if (this.day == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.day);
        }
        if (this.distance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distance.floatValue());
        }
        out.writeEnum(this.intensity.ordinal());
        if (this.label == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.label);
        }
        out.writeEnum(this.source.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.endTime = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.id = null;
            } else {
                this.id = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activity = null;
            } else {
                this.activity = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.calories = null;
            } else {
                this.calories = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.day = null;
            } else {
                this.day = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distance = null;
            } else {
                this.distance = Float.valueOf(in.readFloat());
            }
            this.intensity = OuraWorkoutIntensity.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.label = null;
            } else {
                this.label = in.readString();
            }
            this.source = OuraWorkoutSource.values()[in.readEnum()];
        } else {
            block13: for (int i = 0; i < 11; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block13;
                    }
                    case 1: {
                        this.endTime = in.readDouble();
                        continue block13;
                    }
                    case 2: {
                        this.timeReceived = in.readDouble();
                        continue block13;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.id = null;
                            continue block13;
                        }
                        this.id = in.readString();
                        continue block13;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activity = null;
                            continue block13;
                        }
                        this.activity = in.readString();
                        continue block13;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.calories = null;
                            continue block13;
                        }
                        this.calories = Float.valueOf(in.readFloat());
                        continue block13;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.day = null;
                            continue block13;
                        }
                        this.day = in.readString();
                        continue block13;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distance = null;
                            continue block13;
                        }
                        this.distance = Float.valueOf(in.readFloat());
                        continue block13;
                    }
                    case 8: {
                        this.intensity = OuraWorkoutIntensity.values()[in.readEnum()];
                        continue block13;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.label = null;
                            continue block13;
                        }
                        this.label = in.readString();
                        continue block13;
                    }
                    case 10: {
                        this.source = OuraWorkoutSource.values()[in.readEnum()];
                        continue block13;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OuraWorkout>
    implements RecordBuilder<OuraWorkout> {
        private double time;
        private double endTime;
        private double timeReceived;
        private String id;
        private String activity;
        private Float calories;
        private String day;
        private Float distance;
        private OuraWorkoutIntensity intensity;
        private String label;
        private OuraWorkoutSource source;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.id);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activity)) {
                this.activity = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activity);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.calories)) {
                this.calories = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.calories);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.day);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.distance);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.intensity))) {
                this.intensity = (OuraWorkoutIntensity)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.intensity));
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.label);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.source))) {
                this.source = (OuraWorkoutSource)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.source));
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
        }

        private Builder(OuraWorkout other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.endTime);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.id);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activity)) {
                this.activity = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activity);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.calories)) {
                this.calories = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.calories);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.day)) {
                this.day = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.day);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.distance);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.intensity))) {
                this.intensity = (OuraWorkoutIntensity)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.intensity));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.label)) {
                this.label = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.label);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.source))) {
                this.source = (OuraWorkoutSource)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.source));
                this.fieldSetFlags()[10] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(double value) {
            this.validate(this.fields()[1], value);
            this.endTime = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEndTime() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEndTime() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[2], value);
            this.timeReceived = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[3], value);
            this.id = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getActivity() {
            return this.activity;
        }

        public Builder setActivity(String value) {
            this.validate(this.fields()[4], value);
            this.activity = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasActivity() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearActivity() {
            this.activity = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getCalories() {
            return this.calories;
        }

        public Builder setCalories(Float value) {
            this.validate(this.fields()[5], value);
            this.calories = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasCalories() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearCalories() {
            this.calories = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getDay() {
            return this.day;
        }

        public Builder setDay(String value) {
            this.validate(this.fields()[6], value);
            this.day = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasDay() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearDay() {
            this.day = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getDistance() {
            return this.distance;
        }

        public Builder setDistance(Float value) {
            this.validate(this.fields()[7], value);
            this.distance = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public OuraWorkoutIntensity getIntensity() {
            return this.intensity;
        }

        public Builder setIntensity(OuraWorkoutIntensity value) {
            this.validate(this.fields()[8], (Object)value);
            this.intensity = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasIntensity() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearIntensity() {
            this.intensity = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getLabel() {
            return this.label;
        }

        public Builder setLabel(String value) {
            this.validate(this.fields()[9], value);
            this.label = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasLabel() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearLabel() {
            this.label = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public OuraWorkoutSource getSource() {
            return this.source;
        }

        public Builder setSource(OuraWorkoutSource value) {
            this.validate(this.fields()[10], (Object)value);
            this.source = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public OuraWorkout build() {
            try {
                OuraWorkout record = new OuraWorkout();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.endTime = this.fieldSetFlags()[1] ? this.endTime : (Double)this.defaultValue(this.fields()[1]);
                record.timeReceived = this.fieldSetFlags()[2] ? this.timeReceived : (Double)this.defaultValue(this.fields()[2]);
                record.id = this.fieldSetFlags()[3] ? this.id : (String)this.defaultValue(this.fields()[3]);
                record.activity = this.fieldSetFlags()[4] ? this.activity : (String)this.defaultValue(this.fields()[4]);
                record.calories = this.fieldSetFlags()[5] ? this.calories : (Float)this.defaultValue(this.fields()[5]);
                record.day = this.fieldSetFlags()[6] ? this.day : (String)this.defaultValue(this.fields()[6]);
                record.distance = this.fieldSetFlags()[7] ? this.distance : (Float)this.defaultValue(this.fields()[7]);
                record.intensity = this.fieldSetFlags()[8] ? this.intensity : (OuraWorkoutIntensity)((Object)this.defaultValue(this.fields()[8]));
                record.label = this.fieldSetFlags()[9] ? this.label : (String)this.defaultValue(this.fields()[9]);
                record.source = this.fieldSetFlags()[10] ? this.source : (OuraWorkoutSource)((Object)this.defaultValue(this.fields()[10]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

