/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.connector.upload.altoida;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.connector.upload.altoida.AltoidaTappingTestAggregate;
import org.radarcns.connector.upload.altoida.AltoidaTrial;
import org.radarcns.connector.upload.altoida.AltoidaWalkingTestAggregate;

@AvroGenerated
public class AltoidaSummaryMetrics
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2757773972349599181L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"AltoidaSummaryMetrics\",\"namespace\":\"org.radarcns.connector.upload.altoida\",\"doc\":\"Metrics from a set of tests.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Timestamp in unix time acquired locally from the device.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Timestamp in unix time received from Altoida API.\"},{\"name\":\"audioHighReactionTimes\",\"type\":\"float\",\"doc\":\"Distribution of reaction times to high tone(s).\"},{\"name\":\"audioHighAccuracy\",\"type\":\"float\",\"doc\":\"Distribution of deviation from speaker button center (cm).\"},{\"name\":\"audioLowReactions\",\"type\":[\"null\",\"int\"],\"doc\":\"Distributions of number of reactions to low tones.\",\"default\":null},{\"name\":\"audioIgnoredHighTonePercentage\",\"type\":\"float\",\"doc\":\"Distribution of ratio of high tones ignored.\"},{\"name\":\"audioPrematureToneButtonPresses\",\"type\":\"int\",\"doc\":\"Distribution of number of premature tone button presses.\"},{\"name\":\"randomScreenPressesDuringPlacement\",\"type\":\"int\",\"doc\":\"Distribution of number of random screen presses during the placement phase.\"},{\"name\":\"randomScreenPressesDuringSearch\",\"type\":\"int\",\"doc\":\"Distribution of number of random screen presses during placement.\"},{\"name\":\"tooMuchMovementCount\",\"type\":\"int\",\"doc\":\"Distribution of number of times placement was impossible due to too much movement.\"},{\"name\":\"findBetterPlaceCount\",\"type\":\"float\",\"doc\":\"Number of times the user had to find a better place.\"},{\"name\":\"introReadTimes\",\"type\":\"float\",\"doc\":\"Mean time the user required to read an intro page (s).\"},{\"name\":\"introReadTime1\",\"type\":\"float\",\"doc\":\"Time the user required to read the first intro page (s).\"},{\"name\":\"introReadTime2\",\"type\":\"float\",\"doc\":\"Time the user required to read the second intro page (s).\"},{\"name\":\"placeDelays\",\"type\":\"float\",\"doc\":\"Mean delay from possible placement to actual placement (s).\"},{\"name\":\"spotAlreadyTakenCount\",\"type\":\"int\",\"doc\":\"Number of times the user tried to use the same spot twice.\"},{\"name\":\"trials\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AltoidaTrial\",\"doc\":\"Trial statistics.\",\"fields\":[{\"name\":\"placeDuration\",\"type\":\"float\",\"doc\":\"Time the user required to place the object (s).\"},{\"name\":\"findDuration\",\"type\":\"float\",\"doc\":\"Time the user required to find the object (s).\"},{\"name\":\"stepAngularChange\",\"type\":[\"null\",\"float\"],\"doc\":\"Mean angle the user turned during one step when finding the object (s).\",\"default\":null},{\"name\":\"totalAngularChange\",\"type\":\"float\",\"doc\":\"Accumulated angular change when finding the object (radians).\"},{\"name\":\"pathComplexity\",\"type\":[\"null\",\"float\"],\"doc\":\"Path complexity when finding the object (m).\",\"default\":null}]}},\"doc\":\"Per-trials details and analyses.\"},{\"name\":\"trialMeans\",\"type\":\"AltoidaTrial\",\"doc\":\"Mean values of each of the trials.\"},{\"name\":\"findFailCount\",\"type\":\"float\",\"doc\":\"Number of times the user failed to find an object.\"},{\"name\":\"findSkipDurations\",\"type\":\"float\",\"doc\":\"Mean time the user tried before skipping an object in seconds.\"},{\"name\":\"skipButtonCount\",\"type\":\"float\",\"doc\":\"Number of times the user pressed the skip button.\"},{\"name\":\"countdownFail\",\"type\":\"float\",\"doc\":\"Number of countdown fails.\"},{\"name\":\"stepCountRatio\",\"type\":\"float\",\"doc\":\"Distribution of the ratio between the steps needed for finding the objects over the steps needed for placing them.\"},{\"name\":\"stepDelayP\",\"type\":\"float\",\"doc\":\"Mean delay between steps when placing objects (s).\"},{\"name\":\"stepDelayF\",\"type\":\"float\",\"doc\":\"Mean delay between steps when finding objects (s).\"},{\"name\":\"stepVarianceP\",\"type\":\"float\",\"doc\":\"Variance of delays between steps when placing objects.\"},{\"name\":\"stepVarianceF\",\"type\":\"float\",\"doc\":\"Variance of delays between steps when finding objects.\"},{\"name\":\"notWalkingTimeP\",\"type\":\"float\",\"doc\":\"Time the user did not walk during placing objects (s).\"},{\"name\":\"notWalkingTimeF\",\"type\":\"float\",\"doc\":\"Time the user did not walk during finding objects (s).\"},{\"name\":\"shockCount\",\"type\":\"float\",\"doc\":\"Number of shocks that were recorded during the test.\"},{\"name\":\"accelerationVarianceX\",\"type\":\"float\",\"doc\":\"Variance of acceleration data of x axis.\"},{\"name\":\"accelerationVarianceY\",\"type\":\"float\",\"doc\":\"Variance of acceleration data of y axis.\"},{\"name\":\"accelerationVarianceZ\",\"type\":\"float\",\"doc\":\"Variance of acceleration data of z axis.\"},{\"name\":\"strongHand\",\"type\":\"float\",\"doc\":\"Dominant hand of user.\"},{\"name\":\"normalisationCircle\",\"type\":{\"type\":\"record\",\"name\":\"AltoidaWalkingTestAggregate\",\"doc\":\"Aggregate data of a walking test.\",\"fields\":[{\"name\":\"mean\",\"type\":\"float\",\"doc\":\"Mean test value.\"},{\"name\":\"variance\",\"type\":\"float\",\"doc\":\"Variance of test values.\"},{\"name\":\"timeRatioWithin\",\"type\":\"float\",\"doc\":\"Ratio of time spent within the specified area.\"},{\"name\":\"distRatioWithin\",\"type\":\"float\",\"doc\":\"Ratio of distance spent within the specified area.\"},{\"name\":\"distWithin\",\"type\":\"float\",\"doc\":\"Distance spent within the specified area (cm).\"},{\"name\":\"distTotal\",\"type\":\"float\",\"doc\":\"Total distance moved in test (cm).\"},{\"name\":\"angleSum\",\"type\":[\"null\",\"float\"],\"doc\":\"Sum of angular movement (radians). Null if not applicable.\",\"default\":null},{\"name\":\"directionalChanges\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of times the movement changed direction. Null if not applicable.\",\"default\":null},{\"name\":\"verticalProgress\",\"type\":[\"null\",\"float\"],\"doc\":\"Vertical ratio of the serpentine that was completed. Null if not applicable.\",\"default\":null},{\"name\":\"speed\",\"type\":\"float\",\"doc\":\"Average speed of movement (cm/s).\"},{\"name\":\"speedAccuracyRatio\",\"type\":\"float\",\"doc\":\"Speed accuracy ratio (s).\"},{\"name\":\"duration\",\"type\":\"float\",\"doc\":\"Mean duration of a test (s).\"},{\"name\":\"fullDuration\",\"type\":\"float\",\"doc\":\"Total amount of time performing tests (s).\"}]},\"doc\":\"Deviation from optimal path in circle normalisation test (cm).\"},{\"name\":\"normalisationSquare\",\"type\":\"AltoidaWalkingTestAggregate\",\"doc\":\"Deviation from optimal path in square normalisation test (cm).\"},{\"name\":\"normalisationSerpentine\",\"type\":\"AltoidaWalkingTestAggregate\",\"doc\":\"Deviation from optimal path in serpentine normalisation test (cm).\"},{\"name\":\"normalisationSpeedCircle\",\"type\":\"AltoidaWalkingTestAggregate\",\"doc\":\"Deviation from optimal path in speed circle normalisation test (cm).\"},{\"name\":\"normalisationRandomTapping\",\"type\":{\"type\":\"record\",\"name\":\"AltoidaTappingTestAggregate\",\"doc\":\"Aggregate for a test on tapping the screen.\",\"fields\":[{\"name\":\"mean\",\"type\":\"float\",\"doc\":\"Mean test value.\"},{\"name\":\"variance\",\"type\":\"float\",\"doc\":\"Variance of test values.\"},{\"name\":\"count\",\"type\":\"int\",\"doc\":\"Number of tests performed.\"},{\"name\":\"reactionTime\",\"type\":\"float\",\"doc\":\"Mean time to react by the user (s).\"},{\"name\":\"rate\",\"type\":\"float\",\"doc\":\"Number of tests performed per second.\"},{\"name\":\"duration\",\"type\":\"float\",\"doc\":\"Mean duration of a test (s).\"},{\"name\":\"fullDuration\",\"type\":\"float\",\"doc\":\"Total amount of time performing tests (s).\"}]},\"doc\":\"Deviation from center points in random tapping normalisation test (cm).\"},{\"name\":\"normalisationTapping\",\"type\":\"AltoidaTappingTestAggregate\",\"doc\":\"Deviation from center points in tapping normalisation test (cm).\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<AltoidaSummaryMetrics> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<AltoidaSummaryMetrics> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float audioHighReactionTimes;
    private float audioHighAccuracy;
    private Integer audioLowReactions;
    private float audioIgnoredHighTonePercentage;
    private int audioPrematureToneButtonPresses;
    private int randomScreenPressesDuringPlacement;
    private int randomScreenPressesDuringSearch;
    private int tooMuchMovementCount;
    private float findBetterPlaceCount;
    private float introReadTimes;
    private float introReadTime1;
    private float introReadTime2;
    private float placeDelays;
    private int spotAlreadyTakenCount;
    private List<AltoidaTrial> trials;
    private AltoidaTrial trialMeans;
    private float findFailCount;
    private float findSkipDurations;
    private float skipButtonCount;
    private float countdownFail;
    private float stepCountRatio;
    private float stepDelayP;
    private float stepDelayF;
    private float stepVarianceP;
    private float stepVarianceF;
    private float notWalkingTimeP;
    private float notWalkingTimeF;
    private float shockCount;
    private float accelerationVarianceX;
    private float accelerationVarianceY;
    private float accelerationVarianceZ;
    private float strongHand;
    private AltoidaWalkingTestAggregate normalisationCircle;
    private AltoidaWalkingTestAggregate normalisationSquare;
    private AltoidaWalkingTestAggregate normalisationSerpentine;
    private AltoidaWalkingTestAggregate normalisationSpeedCircle;
    private AltoidaTappingTestAggregate normalisationRandomTapping;
    private AltoidaTappingTestAggregate normalisationTapping;
    private static final DatumWriter<AltoidaSummaryMetrics> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<AltoidaSummaryMetrics> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<AltoidaSummaryMetrics> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<AltoidaSummaryMetrics> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<AltoidaSummaryMetrics> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static AltoidaSummaryMetrics fromByteBuffer(ByteBuffer b) throws IOException {
        return (AltoidaSummaryMetrics)((Object)DECODER.decode(b));
    }

    public AltoidaSummaryMetrics() {
    }

    public AltoidaSummaryMetrics(Double time, Double timeReceived, Float audioHighReactionTimes, Float audioHighAccuracy, Integer audioLowReactions, Float audioIgnoredHighTonePercentage, Integer audioPrematureToneButtonPresses, Integer randomScreenPressesDuringPlacement, Integer randomScreenPressesDuringSearch, Integer tooMuchMovementCount, Float findBetterPlaceCount, Float introReadTimes, Float introReadTime1, Float introReadTime2, Float placeDelays, Integer spotAlreadyTakenCount, List<AltoidaTrial> trials, AltoidaTrial trialMeans, Float findFailCount, Float findSkipDurations, Float skipButtonCount, Float countdownFail, Float stepCountRatio, Float stepDelayP, Float stepDelayF, Float stepVarianceP, Float stepVarianceF, Float notWalkingTimeP, Float notWalkingTimeF, Float shockCount, Float accelerationVarianceX, Float accelerationVarianceY, Float accelerationVarianceZ, Float strongHand, AltoidaWalkingTestAggregate normalisationCircle, AltoidaWalkingTestAggregate normalisationSquare, AltoidaWalkingTestAggregate normalisationSerpentine, AltoidaWalkingTestAggregate normalisationSpeedCircle, AltoidaTappingTestAggregate normalisationRandomTapping, AltoidaTappingTestAggregate normalisationTapping) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.audioHighReactionTimes = audioHighReactionTimes.floatValue();
        this.audioHighAccuracy = audioHighAccuracy.floatValue();
        this.audioLowReactions = audioLowReactions;
        this.audioIgnoredHighTonePercentage = audioIgnoredHighTonePercentage.floatValue();
        this.audioPrematureToneButtonPresses = audioPrematureToneButtonPresses;
        this.randomScreenPressesDuringPlacement = randomScreenPressesDuringPlacement;
        this.randomScreenPressesDuringSearch = randomScreenPressesDuringSearch;
        this.tooMuchMovementCount = tooMuchMovementCount;
        this.findBetterPlaceCount = findBetterPlaceCount.floatValue();
        this.introReadTimes = introReadTimes.floatValue();
        this.introReadTime1 = introReadTime1.floatValue();
        this.introReadTime2 = introReadTime2.floatValue();
        this.placeDelays = placeDelays.floatValue();
        this.spotAlreadyTakenCount = spotAlreadyTakenCount;
        this.trials = trials;
        this.trialMeans = trialMeans;
        this.findFailCount = findFailCount.floatValue();
        this.findSkipDurations = findSkipDurations.floatValue();
        this.skipButtonCount = skipButtonCount.floatValue();
        this.countdownFail = countdownFail.floatValue();
        this.stepCountRatio = stepCountRatio.floatValue();
        this.stepDelayP = stepDelayP.floatValue();
        this.stepDelayF = stepDelayF.floatValue();
        this.stepVarianceP = stepVarianceP.floatValue();
        this.stepVarianceF = stepVarianceF.floatValue();
        this.notWalkingTimeP = notWalkingTimeP.floatValue();
        this.notWalkingTimeF = notWalkingTimeF.floatValue();
        this.shockCount = shockCount.floatValue();
        this.accelerationVarianceX = accelerationVarianceX.floatValue();
        this.accelerationVarianceY = accelerationVarianceY.floatValue();
        this.accelerationVarianceZ = accelerationVarianceZ.floatValue();
        this.strongHand = strongHand.floatValue();
        this.normalisationCircle = normalisationCircle;
        this.normalisationSquare = normalisationSquare;
        this.normalisationSerpentine = normalisationSerpentine;
        this.normalisationSpeedCircle = normalisationSpeedCircle;
        this.normalisationRandomTapping = normalisationRandomTapping;
        this.normalisationTapping = normalisationTapping;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.audioHighReactionTimes);
            }
            case 3: {
                return Float.valueOf(this.audioHighAccuracy);
            }
            case 4: {
                return this.audioLowReactions;
            }
            case 5: {
                return Float.valueOf(this.audioIgnoredHighTonePercentage);
            }
            case 6: {
                return this.audioPrematureToneButtonPresses;
            }
            case 7: {
                return this.randomScreenPressesDuringPlacement;
            }
            case 8: {
                return this.randomScreenPressesDuringSearch;
            }
            case 9: {
                return this.tooMuchMovementCount;
            }
            case 10: {
                return Float.valueOf(this.findBetterPlaceCount);
            }
            case 11: {
                return Float.valueOf(this.introReadTimes);
            }
            case 12: {
                return Float.valueOf(this.introReadTime1);
            }
            case 13: {
                return Float.valueOf(this.introReadTime2);
            }
            case 14: {
                return Float.valueOf(this.placeDelays);
            }
            case 15: {
                return this.spotAlreadyTakenCount;
            }
            case 16: {
                return this.trials;
            }
            case 17: {
                return this.trialMeans;
            }
            case 18: {
                return Float.valueOf(this.findFailCount);
            }
            case 19: {
                return Float.valueOf(this.findSkipDurations);
            }
            case 20: {
                return Float.valueOf(this.skipButtonCount);
            }
            case 21: {
                return Float.valueOf(this.countdownFail);
            }
            case 22: {
                return Float.valueOf(this.stepCountRatio);
            }
            case 23: {
                return Float.valueOf(this.stepDelayP);
            }
            case 24: {
                return Float.valueOf(this.stepDelayF);
            }
            case 25: {
                return Float.valueOf(this.stepVarianceP);
            }
            case 26: {
                return Float.valueOf(this.stepVarianceF);
            }
            case 27: {
                return Float.valueOf(this.notWalkingTimeP);
            }
            case 28: {
                return Float.valueOf(this.notWalkingTimeF);
            }
            case 29: {
                return Float.valueOf(this.shockCount);
            }
            case 30: {
                return Float.valueOf(this.accelerationVarianceX);
            }
            case 31: {
                return Float.valueOf(this.accelerationVarianceY);
            }
            case 32: {
                return Float.valueOf(this.accelerationVarianceZ);
            }
            case 33: {
                return Float.valueOf(this.strongHand);
            }
            case 34: {
                return this.normalisationCircle;
            }
            case 35: {
                return this.normalisationSquare;
            }
            case 36: {
                return this.normalisationSerpentine;
            }
            case 37: {
                return this.normalisationSpeedCircle;
            }
            case 38: {
                return this.normalisationRandomTapping;
            }
            case 39: {
                return this.normalisationTapping;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.audioHighReactionTimes = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.audioHighAccuracy = ((Float)value$).floatValue();
                break;
            }
            case 4: {
                this.audioLowReactions = (Integer)value$;
                break;
            }
            case 5: {
                this.audioIgnoredHighTonePercentage = ((Float)value$).floatValue();
                break;
            }
            case 6: {
                this.audioPrematureToneButtonPresses = (Integer)value$;
                break;
            }
            case 7: {
                this.randomScreenPressesDuringPlacement = (Integer)value$;
                break;
            }
            case 8: {
                this.randomScreenPressesDuringSearch = (Integer)value$;
                break;
            }
            case 9: {
                this.tooMuchMovementCount = (Integer)value$;
                break;
            }
            case 10: {
                this.findBetterPlaceCount = ((Float)value$).floatValue();
                break;
            }
            case 11: {
                this.introReadTimes = ((Float)value$).floatValue();
                break;
            }
            case 12: {
                this.introReadTime1 = ((Float)value$).floatValue();
                break;
            }
            case 13: {
                this.introReadTime2 = ((Float)value$).floatValue();
                break;
            }
            case 14: {
                this.placeDelays = ((Float)value$).floatValue();
                break;
            }
            case 15: {
                this.spotAlreadyTakenCount = (Integer)value$;
                break;
            }
            case 16: {
                this.trials = (List)value$;
                break;
            }
            case 17: {
                this.trialMeans = (AltoidaTrial)((Object)value$);
                break;
            }
            case 18: {
                this.findFailCount = ((Float)value$).floatValue();
                break;
            }
            case 19: {
                this.findSkipDurations = ((Float)value$).floatValue();
                break;
            }
            case 20: {
                this.skipButtonCount = ((Float)value$).floatValue();
                break;
            }
            case 21: {
                this.countdownFail = ((Float)value$).floatValue();
                break;
            }
            case 22: {
                this.stepCountRatio = ((Float)value$).floatValue();
                break;
            }
            case 23: {
                this.stepDelayP = ((Float)value$).floatValue();
                break;
            }
            case 24: {
                this.stepDelayF = ((Float)value$).floatValue();
                break;
            }
            case 25: {
                this.stepVarianceP = ((Float)value$).floatValue();
                break;
            }
            case 26: {
                this.stepVarianceF = ((Float)value$).floatValue();
                break;
            }
            case 27: {
                this.notWalkingTimeP = ((Float)value$).floatValue();
                break;
            }
            case 28: {
                this.notWalkingTimeF = ((Float)value$).floatValue();
                break;
            }
            case 29: {
                this.shockCount = ((Float)value$).floatValue();
                break;
            }
            case 30: {
                this.accelerationVarianceX = ((Float)value$).floatValue();
                break;
            }
            case 31: {
                this.accelerationVarianceY = ((Float)value$).floatValue();
                break;
            }
            case 32: {
                this.accelerationVarianceZ = ((Float)value$).floatValue();
                break;
            }
            case 33: {
                this.strongHand = ((Float)value$).floatValue();
                break;
            }
            case 34: {
                this.normalisationCircle = (AltoidaWalkingTestAggregate)((Object)value$);
                break;
            }
            case 35: {
                this.normalisationSquare = (AltoidaWalkingTestAggregate)((Object)value$);
                break;
            }
            case 36: {
                this.normalisationSerpentine = (AltoidaWalkingTestAggregate)((Object)value$);
                break;
            }
            case 37: {
                this.normalisationSpeedCircle = (AltoidaWalkingTestAggregate)((Object)value$);
                break;
            }
            case 38: {
                this.normalisationRandomTapping = (AltoidaTappingTestAggregate)((Object)value$);
                break;
            }
            case 39: {
                this.normalisationTapping = (AltoidaTappingTestAggregate)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getAudioHighReactionTimes() {
        return this.audioHighReactionTimes;
    }

    public void setAudioHighReactionTimes(float value) {
        this.audioHighReactionTimes = value;
    }

    public float getAudioHighAccuracy() {
        return this.audioHighAccuracy;
    }

    public void setAudioHighAccuracy(float value) {
        this.audioHighAccuracy = value;
    }

    public Integer getAudioLowReactions() {
        return this.audioLowReactions;
    }

    public void setAudioLowReactions(Integer value) {
        this.audioLowReactions = value;
    }

    public float getAudioIgnoredHighTonePercentage() {
        return this.audioIgnoredHighTonePercentage;
    }

    public void setAudioIgnoredHighTonePercentage(float value) {
        this.audioIgnoredHighTonePercentage = value;
    }

    public int getAudioPrematureToneButtonPresses() {
        return this.audioPrematureToneButtonPresses;
    }

    public void setAudioPrematureToneButtonPresses(int value) {
        this.audioPrematureToneButtonPresses = value;
    }

    public int getRandomScreenPressesDuringPlacement() {
        return this.randomScreenPressesDuringPlacement;
    }

    public void setRandomScreenPressesDuringPlacement(int value) {
        this.randomScreenPressesDuringPlacement = value;
    }

    public int getRandomScreenPressesDuringSearch() {
        return this.randomScreenPressesDuringSearch;
    }

    public void setRandomScreenPressesDuringSearch(int value) {
        this.randomScreenPressesDuringSearch = value;
    }

    public int getTooMuchMovementCount() {
        return this.tooMuchMovementCount;
    }

    public void setTooMuchMovementCount(int value) {
        this.tooMuchMovementCount = value;
    }

    public float getFindBetterPlaceCount() {
        return this.findBetterPlaceCount;
    }

    public void setFindBetterPlaceCount(float value) {
        this.findBetterPlaceCount = value;
    }

    public float getIntroReadTimes() {
        return this.introReadTimes;
    }

    public void setIntroReadTimes(float value) {
        this.introReadTimes = value;
    }

    public float getIntroReadTime1() {
        return this.introReadTime1;
    }

    public void setIntroReadTime1(float value) {
        this.introReadTime1 = value;
    }

    public float getIntroReadTime2() {
        return this.introReadTime2;
    }

    public void setIntroReadTime2(float value) {
        this.introReadTime2 = value;
    }

    public float getPlaceDelays() {
        return this.placeDelays;
    }

    public void setPlaceDelays(float value) {
        this.placeDelays = value;
    }

    public int getSpotAlreadyTakenCount() {
        return this.spotAlreadyTakenCount;
    }

    public void setSpotAlreadyTakenCount(int value) {
        this.spotAlreadyTakenCount = value;
    }

    public List<AltoidaTrial> getTrials() {
        return this.trials;
    }

    public void setTrials(List<AltoidaTrial> value) {
        this.trials = value;
    }

    public AltoidaTrial getTrialMeans() {
        return this.trialMeans;
    }

    public void setTrialMeans(AltoidaTrial value) {
        this.trialMeans = value;
    }

    public float getFindFailCount() {
        return this.findFailCount;
    }

    public void setFindFailCount(float value) {
        this.findFailCount = value;
    }

    public float getFindSkipDurations() {
        return this.findSkipDurations;
    }

    public void setFindSkipDurations(float value) {
        this.findSkipDurations = value;
    }

    public float getSkipButtonCount() {
        return this.skipButtonCount;
    }

    public void setSkipButtonCount(float value) {
        this.skipButtonCount = value;
    }

    public float getCountdownFail() {
        return this.countdownFail;
    }

    public void setCountdownFail(float value) {
        this.countdownFail = value;
    }

    public float getStepCountRatio() {
        return this.stepCountRatio;
    }

    public void setStepCountRatio(float value) {
        this.stepCountRatio = value;
    }

    public float getStepDelayP() {
        return this.stepDelayP;
    }

    public void setStepDelayP(float value) {
        this.stepDelayP = value;
    }

    public float getStepDelayF() {
        return this.stepDelayF;
    }

    public void setStepDelayF(float value) {
        this.stepDelayF = value;
    }

    public float getStepVarianceP() {
        return this.stepVarianceP;
    }

    public void setStepVarianceP(float value) {
        this.stepVarianceP = value;
    }

    public float getStepVarianceF() {
        return this.stepVarianceF;
    }

    public void setStepVarianceF(float value) {
        this.stepVarianceF = value;
    }

    public float getNotWalkingTimeP() {
        return this.notWalkingTimeP;
    }

    public void setNotWalkingTimeP(float value) {
        this.notWalkingTimeP = value;
    }

    public float getNotWalkingTimeF() {
        return this.notWalkingTimeF;
    }

    public void setNotWalkingTimeF(float value) {
        this.notWalkingTimeF = value;
    }

    public float getShockCount() {
        return this.shockCount;
    }

    public void setShockCount(float value) {
        this.shockCount = value;
    }

    public float getAccelerationVarianceX() {
        return this.accelerationVarianceX;
    }

    public void setAccelerationVarianceX(float value) {
        this.accelerationVarianceX = value;
    }

    public float getAccelerationVarianceY() {
        return this.accelerationVarianceY;
    }

    public void setAccelerationVarianceY(float value) {
        this.accelerationVarianceY = value;
    }

    public float getAccelerationVarianceZ() {
        return this.accelerationVarianceZ;
    }

    public void setAccelerationVarianceZ(float value) {
        this.accelerationVarianceZ = value;
    }

    public float getStrongHand() {
        return this.strongHand;
    }

    public void setStrongHand(float value) {
        this.strongHand = value;
    }

    public AltoidaWalkingTestAggregate getNormalisationCircle() {
        return this.normalisationCircle;
    }

    public void setNormalisationCircle(AltoidaWalkingTestAggregate value) {
        this.normalisationCircle = value;
    }

    public AltoidaWalkingTestAggregate getNormalisationSquare() {
        return this.normalisationSquare;
    }

    public void setNormalisationSquare(AltoidaWalkingTestAggregate value) {
        this.normalisationSquare = value;
    }

    public AltoidaWalkingTestAggregate getNormalisationSerpentine() {
        return this.normalisationSerpentine;
    }

    public void setNormalisationSerpentine(AltoidaWalkingTestAggregate value) {
        this.normalisationSerpentine = value;
    }

    public AltoidaWalkingTestAggregate getNormalisationSpeedCircle() {
        return this.normalisationSpeedCircle;
    }

    public void setNormalisationSpeedCircle(AltoidaWalkingTestAggregate value) {
        this.normalisationSpeedCircle = value;
    }

    public AltoidaTappingTestAggregate getNormalisationRandomTapping() {
        return this.normalisationRandomTapping;
    }

    public void setNormalisationRandomTapping(AltoidaTappingTestAggregate value) {
        this.normalisationRandomTapping = value;
    }

    public AltoidaTappingTestAggregate getNormalisationTapping() {
        return this.normalisationTapping;
    }

    public void setNormalisationTapping(AltoidaTappingTestAggregate value) {
        this.normalisationTapping = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(AltoidaSummaryMetrics other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.audioHighReactionTimes);
        out.writeFloat(this.audioHighAccuracy);
        if (this.audioLowReactions == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.audioLowReactions.intValue());
        }
        out.writeFloat(this.audioIgnoredHighTonePercentage);
        out.writeInt(this.audioPrematureToneButtonPresses);
        out.writeInt(this.randomScreenPressesDuringPlacement);
        out.writeInt(this.randomScreenPressesDuringSearch);
        out.writeInt(this.tooMuchMovementCount);
        out.writeFloat(this.findBetterPlaceCount);
        out.writeFloat(this.introReadTimes);
        out.writeFloat(this.introReadTime1);
        out.writeFloat(this.introReadTime2);
        out.writeFloat(this.placeDelays);
        out.writeInt(this.spotAlreadyTakenCount);
        long size0 = this.trials.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (AltoidaTrial e0 : this.trials) {
            ++actualSize0;
            out.startItem();
            e0.customEncode(out);
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
        this.trialMeans.customEncode(out);
        out.writeFloat(this.findFailCount);
        out.writeFloat(this.findSkipDurations);
        out.writeFloat(this.skipButtonCount);
        out.writeFloat(this.countdownFail);
        out.writeFloat(this.stepCountRatio);
        out.writeFloat(this.stepDelayP);
        out.writeFloat(this.stepDelayF);
        out.writeFloat(this.stepVarianceP);
        out.writeFloat(this.stepVarianceF);
        out.writeFloat(this.notWalkingTimeP);
        out.writeFloat(this.notWalkingTimeF);
        out.writeFloat(this.shockCount);
        out.writeFloat(this.accelerationVarianceX);
        out.writeFloat(this.accelerationVarianceY);
        out.writeFloat(this.accelerationVarianceZ);
        out.writeFloat(this.strongHand);
        this.normalisationCircle.customEncode(out);
        this.normalisationSquare.customEncode(out);
        this.normalisationSerpentine.customEncode(out);
        this.normalisationSpeedCircle.customEncode(out);
        this.normalisationRandomTapping.customEncode(out);
        this.normalisationTapping.customEncode(out);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga0;
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.audioHighReactionTimes = in.readFloat();
            this.audioHighAccuracy = in.readFloat();
            if (in.readIndex() != 1) {
                in.readNull();
                this.audioLowReactions = null;
            } else {
                this.audioLowReactions = in.readInt();
            }
            this.audioIgnoredHighTonePercentage = in.readFloat();
            this.audioPrematureToneButtonPresses = in.readInt();
            this.randomScreenPressesDuringPlacement = in.readInt();
            this.randomScreenPressesDuringSearch = in.readInt();
            this.tooMuchMovementCount = in.readInt();
            this.findBetterPlaceCount = in.readFloat();
            this.introReadTimes = in.readFloat();
            this.introReadTime1 = in.readFloat();
            this.introReadTime2 = in.readFloat();
            this.placeDelays = in.readFloat();
            this.spotAlreadyTakenCount = in.readInt();
            long size0 = in.readArrayStart();
            GenericData.Array a0 = this.trials;
            if (a0 == null) {
                this.trials = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("trials").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    AltoidaTrial e0;
                    AltoidaTrial altoidaTrial = e0 = ga0 != null ? (AltoidaTrial)((Object)ga0.peek()) : null;
                    if (e0 == null) {
                        e0 = new AltoidaTrial();
                    }
                    e0.customDecode(in);
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
            if (this.trialMeans == null) {
                this.trialMeans = new AltoidaTrial();
            }
            this.trialMeans.customDecode(in);
            this.findFailCount = in.readFloat();
            this.findSkipDurations = in.readFloat();
            this.skipButtonCount = in.readFloat();
            this.countdownFail = in.readFloat();
            this.stepCountRatio = in.readFloat();
            this.stepDelayP = in.readFloat();
            this.stepDelayF = in.readFloat();
            this.stepVarianceP = in.readFloat();
            this.stepVarianceF = in.readFloat();
            this.notWalkingTimeP = in.readFloat();
            this.notWalkingTimeF = in.readFloat();
            this.shockCount = in.readFloat();
            this.accelerationVarianceX = in.readFloat();
            this.accelerationVarianceY = in.readFloat();
            this.accelerationVarianceZ = in.readFloat();
            this.strongHand = in.readFloat();
            if (this.normalisationCircle == null) {
                this.normalisationCircle = new AltoidaWalkingTestAggregate();
            }
            this.normalisationCircle.customDecode(in);
            if (this.normalisationSquare == null) {
                this.normalisationSquare = new AltoidaWalkingTestAggregate();
            }
            this.normalisationSquare.customDecode(in);
            if (this.normalisationSerpentine == null) {
                this.normalisationSerpentine = new AltoidaWalkingTestAggregate();
            }
            this.normalisationSerpentine.customDecode(in);
            if (this.normalisationSpeedCircle == null) {
                this.normalisationSpeedCircle = new AltoidaWalkingTestAggregate();
            }
            this.normalisationSpeedCircle.customDecode(in);
            if (this.normalisationRandomTapping == null) {
                this.normalisationRandomTapping = new AltoidaTappingTestAggregate();
            }
            this.normalisationRandomTapping.customDecode(in);
            if (this.normalisationTapping == null) {
                this.normalisationTapping = new AltoidaTappingTestAggregate();
            }
            this.normalisationTapping.customDecode(in);
        } else {
            block44: for (int i = 0; i < 40; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block44;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block44;
                    }
                    case 2: {
                        this.audioHighReactionTimes = in.readFloat();
                        continue block44;
                    }
                    case 3: {
                        this.audioHighAccuracy = in.readFloat();
                        continue block44;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.audioLowReactions = null;
                            continue block44;
                        }
                        this.audioLowReactions = in.readInt();
                        continue block44;
                    }
                    case 5: {
                        this.audioIgnoredHighTonePercentage = in.readFloat();
                        continue block44;
                    }
                    case 6: {
                        this.audioPrematureToneButtonPresses = in.readInt();
                        continue block44;
                    }
                    case 7: {
                        this.randomScreenPressesDuringPlacement = in.readInt();
                        continue block44;
                    }
                    case 8: {
                        this.randomScreenPressesDuringSearch = in.readInt();
                        continue block44;
                    }
                    case 9: {
                        this.tooMuchMovementCount = in.readInt();
                        continue block44;
                    }
                    case 10: {
                        this.findBetterPlaceCount = in.readFloat();
                        continue block44;
                    }
                    case 11: {
                        this.introReadTimes = in.readFloat();
                        continue block44;
                    }
                    case 12: {
                        this.introReadTime1 = in.readFloat();
                        continue block44;
                    }
                    case 13: {
                        this.introReadTime2 = in.readFloat();
                        continue block44;
                    }
                    case 14: {
                        this.placeDelays = in.readFloat();
                        continue block44;
                    }
                    case 15: {
                        this.spotAlreadyTakenCount = in.readInt();
                        continue block44;
                    }
                    case 16: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.trials;
                        if (a0 == null) {
                            this.trials = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("trials").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                AltoidaTrial e0;
                                AltoidaTrial altoidaTrial = e0 = ga0 != null ? (AltoidaTrial)((Object)ga0.peek()) : null;
                                if (e0 == null) {
                                    e0 = new AltoidaTrial();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block44;
                    }
                    case 17: {
                        if (this.trialMeans == null) {
                            this.trialMeans = new AltoidaTrial();
                        }
                        this.trialMeans.customDecode(in);
                        continue block44;
                    }
                    case 18: {
                        this.findFailCount = in.readFloat();
                        continue block44;
                    }
                    case 19: {
                        this.findSkipDurations = in.readFloat();
                        continue block44;
                    }
                    case 20: {
                        this.skipButtonCount = in.readFloat();
                        continue block44;
                    }
                    case 21: {
                        this.countdownFail = in.readFloat();
                        continue block44;
                    }
                    case 22: {
                        this.stepCountRatio = in.readFloat();
                        continue block44;
                    }
                    case 23: {
                        this.stepDelayP = in.readFloat();
                        continue block44;
                    }
                    case 24: {
                        this.stepDelayF = in.readFloat();
                        continue block44;
                    }
                    case 25: {
                        this.stepVarianceP = in.readFloat();
                        continue block44;
                    }
                    case 26: {
                        this.stepVarianceF = in.readFloat();
                        continue block44;
                    }
                    case 27: {
                        this.notWalkingTimeP = in.readFloat();
                        continue block44;
                    }
                    case 28: {
                        this.notWalkingTimeF = in.readFloat();
                        continue block44;
                    }
                    case 29: {
                        this.shockCount = in.readFloat();
                        continue block44;
                    }
                    case 30: {
                        this.accelerationVarianceX = in.readFloat();
                        continue block44;
                    }
                    case 31: {
                        this.accelerationVarianceY = in.readFloat();
                        continue block44;
                    }
                    case 32: {
                        this.accelerationVarianceZ = in.readFloat();
                        continue block44;
                    }
                    case 33: {
                        this.strongHand = in.readFloat();
                        continue block44;
                    }
                    case 34: {
                        if (this.normalisationCircle == null) {
                            this.normalisationCircle = new AltoidaWalkingTestAggregate();
                        }
                        this.normalisationCircle.customDecode(in);
                        continue block44;
                    }
                    case 35: {
                        if (this.normalisationSquare == null) {
                            this.normalisationSquare = new AltoidaWalkingTestAggregate();
                        }
                        this.normalisationSquare.customDecode(in);
                        continue block44;
                    }
                    case 36: {
                        if (this.normalisationSerpentine == null) {
                            this.normalisationSerpentine = new AltoidaWalkingTestAggregate();
                        }
                        this.normalisationSerpentine.customDecode(in);
                        continue block44;
                    }
                    case 37: {
                        if (this.normalisationSpeedCircle == null) {
                            this.normalisationSpeedCircle = new AltoidaWalkingTestAggregate();
                        }
                        this.normalisationSpeedCircle.customDecode(in);
                        continue block44;
                    }
                    case 38: {
                        if (this.normalisationRandomTapping == null) {
                            this.normalisationRandomTapping = new AltoidaTappingTestAggregate();
                        }
                        this.normalisationRandomTapping.customDecode(in);
                        continue block44;
                    }
                    case 39: {
                        if (this.normalisationTapping == null) {
                            this.normalisationTapping = new AltoidaTappingTestAggregate();
                        }
                        this.normalisationTapping.customDecode(in);
                        continue block44;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<AltoidaSummaryMetrics>
    implements RecordBuilder<AltoidaSummaryMetrics> {
        private double time;
        private double timeReceived;
        private float audioHighReactionTimes;
        private float audioHighAccuracy;
        private Integer audioLowReactions;
        private float audioIgnoredHighTonePercentage;
        private int audioPrematureToneButtonPresses;
        private int randomScreenPressesDuringPlacement;
        private int randomScreenPressesDuringSearch;
        private int tooMuchMovementCount;
        private float findBetterPlaceCount;
        private float introReadTimes;
        private float introReadTime1;
        private float introReadTime2;
        private float placeDelays;
        private int spotAlreadyTakenCount;
        private List<AltoidaTrial> trials;
        private AltoidaTrial trialMeans;
        private AltoidaTrial.Builder trialMeansBuilder;
        private float findFailCount;
        private float findSkipDurations;
        private float skipButtonCount;
        private float countdownFail;
        private float stepCountRatio;
        private float stepDelayP;
        private float stepDelayF;
        private float stepVarianceP;
        private float stepVarianceF;
        private float notWalkingTimeP;
        private float notWalkingTimeF;
        private float shockCount;
        private float accelerationVarianceX;
        private float accelerationVarianceY;
        private float accelerationVarianceZ;
        private float strongHand;
        private AltoidaWalkingTestAggregate normalisationCircle;
        private AltoidaWalkingTestAggregate.Builder normalisationCircleBuilder;
        private AltoidaWalkingTestAggregate normalisationSquare;
        private AltoidaWalkingTestAggregate.Builder normalisationSquareBuilder;
        private AltoidaWalkingTestAggregate normalisationSerpentine;
        private AltoidaWalkingTestAggregate.Builder normalisationSerpentineBuilder;
        private AltoidaWalkingTestAggregate normalisationSpeedCircle;
        private AltoidaWalkingTestAggregate.Builder normalisationSpeedCircleBuilder;
        private AltoidaTappingTestAggregate normalisationRandomTapping;
        private AltoidaTappingTestAggregate.Builder normalisationRandomTappingBuilder;
        private AltoidaTappingTestAggregate normalisationTapping;
        private AltoidaTappingTestAggregate.Builder normalisationTappingBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.audioHighReactionTimes))) {
                this.audioHighReactionTimes = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.audioHighReactionTimes))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.audioHighAccuracy))) {
                this.audioHighAccuracy = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.audioHighAccuracy))).floatValue();
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.audioLowReactions)) {
                this.audioLowReactions = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.audioLowReactions);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.audioIgnoredHighTonePercentage))) {
                this.audioIgnoredHighTonePercentage = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.audioIgnoredHighTonePercentage))).floatValue();
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.audioPrematureToneButtonPresses)) {
                this.audioPrematureToneButtonPresses = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.audioPrematureToneButtonPresses);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.randomScreenPressesDuringPlacement)) {
                this.randomScreenPressesDuringPlacement = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.randomScreenPressesDuringPlacement);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.randomScreenPressesDuringSearch)) {
                this.randomScreenPressesDuringSearch = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.randomScreenPressesDuringSearch);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.tooMuchMovementCount)) {
                this.tooMuchMovementCount = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.tooMuchMovementCount);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)Float.valueOf(other.findBetterPlaceCount))) {
                this.findBetterPlaceCount = ((Float)this.data().deepCopy(this.fields()[10].schema(), (Object)Float.valueOf(other.findBetterPlaceCount))).floatValue();
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)Float.valueOf(other.introReadTimes))) {
                this.introReadTimes = ((Float)this.data().deepCopy(this.fields()[11].schema(), (Object)Float.valueOf(other.introReadTimes))).floatValue();
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)Float.valueOf(other.introReadTime1))) {
                this.introReadTime1 = ((Float)this.data().deepCopy(this.fields()[12].schema(), (Object)Float.valueOf(other.introReadTime1))).floatValue();
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)Float.valueOf(other.introReadTime2))) {
                this.introReadTime2 = ((Float)this.data().deepCopy(this.fields()[13].schema(), (Object)Float.valueOf(other.introReadTime2))).floatValue();
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)Float.valueOf(other.placeDelays))) {
                this.placeDelays = ((Float)this.data().deepCopy(this.fields()[14].schema(), (Object)Float.valueOf(other.placeDelays))).floatValue();
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.spotAlreadyTakenCount)) {
                this.spotAlreadyTakenCount = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.spotAlreadyTakenCount);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.trials)) {
                this.trials = (List)this.data().deepCopy(this.fields()[16].schema(), other.trials);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.trialMeans))) {
                this.trialMeans = (AltoidaTrial)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.trialMeans));
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (other.hasTrialMeansBuilder()) {
                this.trialMeansBuilder = AltoidaTrial.newBuilder(other.getTrialMeansBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)Float.valueOf(other.findFailCount))) {
                this.findFailCount = ((Float)this.data().deepCopy(this.fields()[18].schema(), (Object)Float.valueOf(other.findFailCount))).floatValue();
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)Float.valueOf(other.findSkipDurations))) {
                this.findSkipDurations = ((Float)this.data().deepCopy(this.fields()[19].schema(), (Object)Float.valueOf(other.findSkipDurations))).floatValue();
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)Float.valueOf(other.skipButtonCount))) {
                this.skipButtonCount = ((Float)this.data().deepCopy(this.fields()[20].schema(), (Object)Float.valueOf(other.skipButtonCount))).floatValue();
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)Float.valueOf(other.countdownFail))) {
                this.countdownFail = ((Float)this.data().deepCopy(this.fields()[21].schema(), (Object)Float.valueOf(other.countdownFail))).floatValue();
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)Float.valueOf(other.stepCountRatio))) {
                this.stepCountRatio = ((Float)this.data().deepCopy(this.fields()[22].schema(), (Object)Float.valueOf(other.stepCountRatio))).floatValue();
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)Float.valueOf(other.stepDelayP))) {
                this.stepDelayP = ((Float)this.data().deepCopy(this.fields()[23].schema(), (Object)Float.valueOf(other.stepDelayP))).floatValue();
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)Float.valueOf(other.stepDelayF))) {
                this.stepDelayF = ((Float)this.data().deepCopy(this.fields()[24].schema(), (Object)Float.valueOf(other.stepDelayF))).floatValue();
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)Float.valueOf(other.stepVarianceP))) {
                this.stepVarianceP = ((Float)this.data().deepCopy(this.fields()[25].schema(), (Object)Float.valueOf(other.stepVarianceP))).floatValue();
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)Float.valueOf(other.stepVarianceF))) {
                this.stepVarianceF = ((Float)this.data().deepCopy(this.fields()[26].schema(), (Object)Float.valueOf(other.stepVarianceF))).floatValue();
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)Float.valueOf(other.notWalkingTimeP))) {
                this.notWalkingTimeP = ((Float)this.data().deepCopy(this.fields()[27].schema(), (Object)Float.valueOf(other.notWalkingTimeP))).floatValue();
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)Float.valueOf(other.notWalkingTimeF))) {
                this.notWalkingTimeF = ((Float)this.data().deepCopy(this.fields()[28].schema(), (Object)Float.valueOf(other.notWalkingTimeF))).floatValue();
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)Float.valueOf(other.shockCount))) {
                this.shockCount = ((Float)this.data().deepCopy(this.fields()[29].schema(), (Object)Float.valueOf(other.shockCount))).floatValue();
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)Float.valueOf(other.accelerationVarianceX))) {
                this.accelerationVarianceX = ((Float)this.data().deepCopy(this.fields()[30].schema(), (Object)Float.valueOf(other.accelerationVarianceX))).floatValue();
                this.fieldSetFlags()[30] = other.fieldSetFlags()[30];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)Float.valueOf(other.accelerationVarianceY))) {
                this.accelerationVarianceY = ((Float)this.data().deepCopy(this.fields()[31].schema(), (Object)Float.valueOf(other.accelerationVarianceY))).floatValue();
                this.fieldSetFlags()[31] = other.fieldSetFlags()[31];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)Float.valueOf(other.accelerationVarianceZ))) {
                this.accelerationVarianceZ = ((Float)this.data().deepCopy(this.fields()[32].schema(), (Object)Float.valueOf(other.accelerationVarianceZ))).floatValue();
                this.fieldSetFlags()[32] = other.fieldSetFlags()[32];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)Float.valueOf(other.strongHand))) {
                this.strongHand = ((Float)this.data().deepCopy(this.fields()[33].schema(), (Object)Float.valueOf(other.strongHand))).floatValue();
                this.fieldSetFlags()[33] = other.fieldSetFlags()[33];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)((Object)other.normalisationCircle))) {
                this.normalisationCircle = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[34].schema(), (Object)other.normalisationCircle));
                this.fieldSetFlags()[34] = other.fieldSetFlags()[34];
            }
            if (other.hasNormalisationCircleBuilder()) {
                this.normalisationCircleBuilder = AltoidaWalkingTestAggregate.newBuilder(other.getNormalisationCircleBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.normalisationSquare))) {
                this.normalisationSquare = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.normalisationSquare));
                this.fieldSetFlags()[35] = other.fieldSetFlags()[35];
            }
            if (other.hasNormalisationSquareBuilder()) {
                this.normalisationSquareBuilder = AltoidaWalkingTestAggregate.newBuilder(other.getNormalisationSquareBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)((Object)other.normalisationSerpentine))) {
                this.normalisationSerpentine = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[36].schema(), (Object)other.normalisationSerpentine));
                this.fieldSetFlags()[36] = other.fieldSetFlags()[36];
            }
            if (other.hasNormalisationSerpentineBuilder()) {
                this.normalisationSerpentineBuilder = AltoidaWalkingTestAggregate.newBuilder(other.getNormalisationSerpentineBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[37], (Object)((Object)other.normalisationSpeedCircle))) {
                this.normalisationSpeedCircle = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[37].schema(), (Object)other.normalisationSpeedCircle));
                this.fieldSetFlags()[37] = other.fieldSetFlags()[37];
            }
            if (other.hasNormalisationSpeedCircleBuilder()) {
                this.normalisationSpeedCircleBuilder = AltoidaWalkingTestAggregate.newBuilder(other.getNormalisationSpeedCircleBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[38], (Object)((Object)other.normalisationRandomTapping))) {
                this.normalisationRandomTapping = (AltoidaTappingTestAggregate)((Object)this.data().deepCopy(this.fields()[38].schema(), (Object)other.normalisationRandomTapping));
                this.fieldSetFlags()[38] = other.fieldSetFlags()[38];
            }
            if (other.hasNormalisationRandomTappingBuilder()) {
                this.normalisationRandomTappingBuilder = AltoidaTappingTestAggregate.newBuilder(other.getNormalisationRandomTappingBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[39], (Object)((Object)other.normalisationTapping))) {
                this.normalisationTapping = (AltoidaTappingTestAggregate)((Object)this.data().deepCopy(this.fields()[39].schema(), (Object)other.normalisationTapping));
                this.fieldSetFlags()[39] = other.fieldSetFlags()[39];
            }
            if (other.hasNormalisationTappingBuilder()) {
                this.normalisationTappingBuilder = AltoidaTappingTestAggregate.newBuilder(other.getNormalisationTappingBuilder());
            }
        }

        private Builder(AltoidaSummaryMetrics other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.audioHighReactionTimes))) {
                this.audioHighReactionTimes = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.audioHighReactionTimes))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.audioHighAccuracy))) {
                this.audioHighAccuracy = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.audioHighAccuracy))).floatValue();
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.audioLowReactions)) {
                this.audioLowReactions = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.audioLowReactions);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)Float.valueOf(other.audioIgnoredHighTonePercentage))) {
                this.audioIgnoredHighTonePercentage = ((Float)this.data().deepCopy(this.fields()[5].schema(), (Object)Float.valueOf(other.audioIgnoredHighTonePercentage))).floatValue();
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.audioPrematureToneButtonPresses)) {
                this.audioPrematureToneButtonPresses = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.audioPrematureToneButtonPresses);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.randomScreenPressesDuringPlacement)) {
                this.randomScreenPressesDuringPlacement = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.randomScreenPressesDuringPlacement);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.randomScreenPressesDuringSearch)) {
                this.randomScreenPressesDuringSearch = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.randomScreenPressesDuringSearch);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.tooMuchMovementCount)) {
                this.tooMuchMovementCount = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.tooMuchMovementCount);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)Float.valueOf(other.findBetterPlaceCount))) {
                this.findBetterPlaceCount = ((Float)this.data().deepCopy(this.fields()[10].schema(), (Object)Float.valueOf(other.findBetterPlaceCount))).floatValue();
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)Float.valueOf(other.introReadTimes))) {
                this.introReadTimes = ((Float)this.data().deepCopy(this.fields()[11].schema(), (Object)Float.valueOf(other.introReadTimes))).floatValue();
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)Float.valueOf(other.introReadTime1))) {
                this.introReadTime1 = ((Float)this.data().deepCopy(this.fields()[12].schema(), (Object)Float.valueOf(other.introReadTime1))).floatValue();
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)Float.valueOf(other.introReadTime2))) {
                this.introReadTime2 = ((Float)this.data().deepCopy(this.fields()[13].schema(), (Object)Float.valueOf(other.introReadTime2))).floatValue();
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)Float.valueOf(other.placeDelays))) {
                this.placeDelays = ((Float)this.data().deepCopy(this.fields()[14].schema(), (Object)Float.valueOf(other.placeDelays))).floatValue();
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.spotAlreadyTakenCount)) {
                this.spotAlreadyTakenCount = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.spotAlreadyTakenCount);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.trials)) {
                this.trials = (List)this.data().deepCopy(this.fields()[16].schema(), other.trials);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.trialMeans))) {
                this.trialMeans = (AltoidaTrial)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.trialMeans));
                this.fieldSetFlags()[17] = true;
            }
            this.trialMeansBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)Float.valueOf(other.findFailCount))) {
                this.findFailCount = ((Float)this.data().deepCopy(this.fields()[18].schema(), (Object)Float.valueOf(other.findFailCount))).floatValue();
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)Float.valueOf(other.findSkipDurations))) {
                this.findSkipDurations = ((Float)this.data().deepCopy(this.fields()[19].schema(), (Object)Float.valueOf(other.findSkipDurations))).floatValue();
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)Float.valueOf(other.skipButtonCount))) {
                this.skipButtonCount = ((Float)this.data().deepCopy(this.fields()[20].schema(), (Object)Float.valueOf(other.skipButtonCount))).floatValue();
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)Float.valueOf(other.countdownFail))) {
                this.countdownFail = ((Float)this.data().deepCopy(this.fields()[21].schema(), (Object)Float.valueOf(other.countdownFail))).floatValue();
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)Float.valueOf(other.stepCountRatio))) {
                this.stepCountRatio = ((Float)this.data().deepCopy(this.fields()[22].schema(), (Object)Float.valueOf(other.stepCountRatio))).floatValue();
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)Float.valueOf(other.stepDelayP))) {
                this.stepDelayP = ((Float)this.data().deepCopy(this.fields()[23].schema(), (Object)Float.valueOf(other.stepDelayP))).floatValue();
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)Float.valueOf(other.stepDelayF))) {
                this.stepDelayF = ((Float)this.data().deepCopy(this.fields()[24].schema(), (Object)Float.valueOf(other.stepDelayF))).floatValue();
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)Float.valueOf(other.stepVarianceP))) {
                this.stepVarianceP = ((Float)this.data().deepCopy(this.fields()[25].schema(), (Object)Float.valueOf(other.stepVarianceP))).floatValue();
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)Float.valueOf(other.stepVarianceF))) {
                this.stepVarianceF = ((Float)this.data().deepCopy(this.fields()[26].schema(), (Object)Float.valueOf(other.stepVarianceF))).floatValue();
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)Float.valueOf(other.notWalkingTimeP))) {
                this.notWalkingTimeP = ((Float)this.data().deepCopy(this.fields()[27].schema(), (Object)Float.valueOf(other.notWalkingTimeP))).floatValue();
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)Float.valueOf(other.notWalkingTimeF))) {
                this.notWalkingTimeF = ((Float)this.data().deepCopy(this.fields()[28].schema(), (Object)Float.valueOf(other.notWalkingTimeF))).floatValue();
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)Float.valueOf(other.shockCount))) {
                this.shockCount = ((Float)this.data().deepCopy(this.fields()[29].schema(), (Object)Float.valueOf(other.shockCount))).floatValue();
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)Float.valueOf(other.accelerationVarianceX))) {
                this.accelerationVarianceX = ((Float)this.data().deepCopy(this.fields()[30].schema(), (Object)Float.valueOf(other.accelerationVarianceX))).floatValue();
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)Float.valueOf(other.accelerationVarianceY))) {
                this.accelerationVarianceY = ((Float)this.data().deepCopy(this.fields()[31].schema(), (Object)Float.valueOf(other.accelerationVarianceY))).floatValue();
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)Float.valueOf(other.accelerationVarianceZ))) {
                this.accelerationVarianceZ = ((Float)this.data().deepCopy(this.fields()[32].schema(), (Object)Float.valueOf(other.accelerationVarianceZ))).floatValue();
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)Float.valueOf(other.strongHand))) {
                this.strongHand = ((Float)this.data().deepCopy(this.fields()[33].schema(), (Object)Float.valueOf(other.strongHand))).floatValue();
                this.fieldSetFlags()[33] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)((Object)other.normalisationCircle))) {
                this.normalisationCircle = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[34].schema(), (Object)other.normalisationCircle));
                this.fieldSetFlags()[34] = true;
            }
            this.normalisationCircleBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)((Object)other.normalisationSquare))) {
                this.normalisationSquare = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[35].schema(), (Object)other.normalisationSquare));
                this.fieldSetFlags()[35] = true;
            }
            this.normalisationSquareBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)((Object)other.normalisationSerpentine))) {
                this.normalisationSerpentine = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[36].schema(), (Object)other.normalisationSerpentine));
                this.fieldSetFlags()[36] = true;
            }
            this.normalisationSerpentineBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[37], (Object)((Object)other.normalisationSpeedCircle))) {
                this.normalisationSpeedCircle = (AltoidaWalkingTestAggregate)((Object)this.data().deepCopy(this.fields()[37].schema(), (Object)other.normalisationSpeedCircle));
                this.fieldSetFlags()[37] = true;
            }
            this.normalisationSpeedCircleBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[38], (Object)((Object)other.normalisationRandomTapping))) {
                this.normalisationRandomTapping = (AltoidaTappingTestAggregate)((Object)this.data().deepCopy(this.fields()[38].schema(), (Object)other.normalisationRandomTapping));
                this.fieldSetFlags()[38] = true;
            }
            this.normalisationRandomTappingBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[39], (Object)((Object)other.normalisationTapping))) {
                this.normalisationTapping = (AltoidaTappingTestAggregate)((Object)this.data().deepCopy(this.fields()[39].schema(), (Object)other.normalisationTapping));
                this.fieldSetFlags()[39] = true;
            }
            this.normalisationTappingBuilder = null;
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getAudioHighReactionTimes() {
            return this.audioHighReactionTimes;
        }

        public Builder setAudioHighReactionTimes(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.audioHighReactionTimes = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasAudioHighReactionTimes() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearAudioHighReactionTimes() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public float getAudioHighAccuracy() {
            return this.audioHighAccuracy;
        }

        public Builder setAudioHighAccuracy(float value) {
            this.validate(this.fields()[3], Float.valueOf(value));
            this.audioHighAccuracy = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAudioHighAccuracy() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearAudioHighAccuracy() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getAudioLowReactions() {
            return this.audioLowReactions;
        }

        public Builder setAudioLowReactions(Integer value) {
            this.validate(this.fields()[4], value);
            this.audioLowReactions = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAudioLowReactions() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAudioLowReactions() {
            this.audioLowReactions = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public float getAudioIgnoredHighTonePercentage() {
            return this.audioIgnoredHighTonePercentage;
        }

        public Builder setAudioIgnoredHighTonePercentage(float value) {
            this.validate(this.fields()[5], Float.valueOf(value));
            this.audioIgnoredHighTonePercentage = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasAudioIgnoredHighTonePercentage() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearAudioIgnoredHighTonePercentage() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public int getAudioPrematureToneButtonPresses() {
            return this.audioPrematureToneButtonPresses;
        }

        public Builder setAudioPrematureToneButtonPresses(int value) {
            this.validate(this.fields()[6], value);
            this.audioPrematureToneButtonPresses = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAudioPrematureToneButtonPresses() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAudioPrematureToneButtonPresses() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public int getRandomScreenPressesDuringPlacement() {
            return this.randomScreenPressesDuringPlacement;
        }

        public Builder setRandomScreenPressesDuringPlacement(int value) {
            this.validate(this.fields()[7], value);
            this.randomScreenPressesDuringPlacement = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasRandomScreenPressesDuringPlacement() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearRandomScreenPressesDuringPlacement() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public int getRandomScreenPressesDuringSearch() {
            return this.randomScreenPressesDuringSearch;
        }

        public Builder setRandomScreenPressesDuringSearch(int value) {
            this.validate(this.fields()[8], value);
            this.randomScreenPressesDuringSearch = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasRandomScreenPressesDuringSearch() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearRandomScreenPressesDuringSearch() {
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public int getTooMuchMovementCount() {
            return this.tooMuchMovementCount;
        }

        public Builder setTooMuchMovementCount(int value) {
            this.validate(this.fields()[9], value);
            this.tooMuchMovementCount = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasTooMuchMovementCount() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearTooMuchMovementCount() {
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public float getFindBetterPlaceCount() {
            return this.findBetterPlaceCount;
        }

        public Builder setFindBetterPlaceCount(float value) {
            this.validate(this.fields()[10], Float.valueOf(value));
            this.findBetterPlaceCount = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasFindBetterPlaceCount() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearFindBetterPlaceCount() {
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public float getIntroReadTimes() {
            return this.introReadTimes;
        }

        public Builder setIntroReadTimes(float value) {
            this.validate(this.fields()[11], Float.valueOf(value));
            this.introReadTimes = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasIntroReadTimes() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearIntroReadTimes() {
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public float getIntroReadTime1() {
            return this.introReadTime1;
        }

        public Builder setIntroReadTime1(float value) {
            this.validate(this.fields()[12], Float.valueOf(value));
            this.introReadTime1 = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasIntroReadTime1() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearIntroReadTime1() {
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public float getIntroReadTime2() {
            return this.introReadTime2;
        }

        public Builder setIntroReadTime2(float value) {
            this.validate(this.fields()[13], Float.valueOf(value));
            this.introReadTime2 = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasIntroReadTime2() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearIntroReadTime2() {
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public float getPlaceDelays() {
            return this.placeDelays;
        }

        public Builder setPlaceDelays(float value) {
            this.validate(this.fields()[14], Float.valueOf(value));
            this.placeDelays = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasPlaceDelays() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearPlaceDelays() {
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public int getSpotAlreadyTakenCount() {
            return this.spotAlreadyTakenCount;
        }

        public Builder setSpotAlreadyTakenCount(int value) {
            this.validate(this.fields()[15], value);
            this.spotAlreadyTakenCount = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasSpotAlreadyTakenCount() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearSpotAlreadyTakenCount() {
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public List<AltoidaTrial> getTrials() {
            return this.trials;
        }

        public Builder setTrials(List<AltoidaTrial> value) {
            this.validate(this.fields()[16], value);
            this.trials = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasTrials() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearTrials() {
            this.trials = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public AltoidaTrial getTrialMeans() {
            return this.trialMeans;
        }

        public Builder setTrialMeans(AltoidaTrial value) {
            this.validate(this.fields()[17], (Object)value);
            this.trialMeansBuilder = null;
            this.trialMeans = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasTrialMeans() {
            return this.fieldSetFlags()[17];
        }

        public AltoidaTrial.Builder getTrialMeansBuilder() {
            if (this.trialMeansBuilder == null) {
                if (this.hasTrialMeans()) {
                    this.setTrialMeansBuilder(AltoidaTrial.newBuilder(this.trialMeans));
                } else {
                    this.setTrialMeansBuilder(AltoidaTrial.newBuilder());
                }
            }
            return this.trialMeansBuilder;
        }

        public Builder setTrialMeansBuilder(AltoidaTrial.Builder value) {
            this.clearTrialMeans();
            this.trialMeansBuilder = value;
            return this;
        }

        public boolean hasTrialMeansBuilder() {
            return this.trialMeansBuilder != null;
        }

        public Builder clearTrialMeans() {
            this.trialMeans = null;
            this.trialMeansBuilder = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public float getFindFailCount() {
            return this.findFailCount;
        }

        public Builder setFindFailCount(float value) {
            this.validate(this.fields()[18], Float.valueOf(value));
            this.findFailCount = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasFindFailCount() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearFindFailCount() {
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public float getFindSkipDurations() {
            return this.findSkipDurations;
        }

        public Builder setFindSkipDurations(float value) {
            this.validate(this.fields()[19], Float.valueOf(value));
            this.findSkipDurations = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasFindSkipDurations() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearFindSkipDurations() {
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public float getSkipButtonCount() {
            return this.skipButtonCount;
        }

        public Builder setSkipButtonCount(float value) {
            this.validate(this.fields()[20], Float.valueOf(value));
            this.skipButtonCount = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasSkipButtonCount() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearSkipButtonCount() {
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public float getCountdownFail() {
            return this.countdownFail;
        }

        public Builder setCountdownFail(float value) {
            this.validate(this.fields()[21], Float.valueOf(value));
            this.countdownFail = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasCountdownFail() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearCountdownFail() {
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public float getStepCountRatio() {
            return this.stepCountRatio;
        }

        public Builder setStepCountRatio(float value) {
            this.validate(this.fields()[22], Float.valueOf(value));
            this.stepCountRatio = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasStepCountRatio() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearStepCountRatio() {
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public float getStepDelayP() {
            return this.stepDelayP;
        }

        public Builder setStepDelayP(float value) {
            this.validate(this.fields()[23], Float.valueOf(value));
            this.stepDelayP = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasStepDelayP() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearStepDelayP() {
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public float getStepDelayF() {
            return this.stepDelayF;
        }

        public Builder setStepDelayF(float value) {
            this.validate(this.fields()[24], Float.valueOf(value));
            this.stepDelayF = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasStepDelayF() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearStepDelayF() {
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public float getStepVarianceP() {
            return this.stepVarianceP;
        }

        public Builder setStepVarianceP(float value) {
            this.validate(this.fields()[25], Float.valueOf(value));
            this.stepVarianceP = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasStepVarianceP() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearStepVarianceP() {
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public float getStepVarianceF() {
            return this.stepVarianceF;
        }

        public Builder setStepVarianceF(float value) {
            this.validate(this.fields()[26], Float.valueOf(value));
            this.stepVarianceF = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasStepVarianceF() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearStepVarianceF() {
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public float getNotWalkingTimeP() {
            return this.notWalkingTimeP;
        }

        public Builder setNotWalkingTimeP(float value) {
            this.validate(this.fields()[27], Float.valueOf(value));
            this.notWalkingTimeP = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasNotWalkingTimeP() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearNotWalkingTimeP() {
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public float getNotWalkingTimeF() {
            return this.notWalkingTimeF;
        }

        public Builder setNotWalkingTimeF(float value) {
            this.validate(this.fields()[28], Float.valueOf(value));
            this.notWalkingTimeF = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasNotWalkingTimeF() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearNotWalkingTimeF() {
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public float getShockCount() {
            return this.shockCount;
        }

        public Builder setShockCount(float value) {
            this.validate(this.fields()[29], Float.valueOf(value));
            this.shockCount = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasShockCount() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearShockCount() {
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public float getAccelerationVarianceX() {
            return this.accelerationVarianceX;
        }

        public Builder setAccelerationVarianceX(float value) {
            this.validate(this.fields()[30], Float.valueOf(value));
            this.accelerationVarianceX = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasAccelerationVarianceX() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearAccelerationVarianceX() {
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public float getAccelerationVarianceY() {
            return this.accelerationVarianceY;
        }

        public Builder setAccelerationVarianceY(float value) {
            this.validate(this.fields()[31], Float.valueOf(value));
            this.accelerationVarianceY = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasAccelerationVarianceY() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearAccelerationVarianceY() {
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public float getAccelerationVarianceZ() {
            return this.accelerationVarianceZ;
        }

        public Builder setAccelerationVarianceZ(float value) {
            this.validate(this.fields()[32], Float.valueOf(value));
            this.accelerationVarianceZ = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasAccelerationVarianceZ() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearAccelerationVarianceZ() {
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public float getStrongHand() {
            return this.strongHand;
        }

        public Builder setStrongHand(float value) {
            this.validate(this.fields()[33], Float.valueOf(value));
            this.strongHand = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasStrongHand() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearStrongHand() {
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public AltoidaWalkingTestAggregate getNormalisationCircle() {
            return this.normalisationCircle;
        }

        public Builder setNormalisationCircle(AltoidaWalkingTestAggregate value) {
            this.validate(this.fields()[34], (Object)value);
            this.normalisationCircleBuilder = null;
            this.normalisationCircle = value;
            this.fieldSetFlags()[34] = true;
            return this;
        }

        public boolean hasNormalisationCircle() {
            return this.fieldSetFlags()[34];
        }

        public AltoidaWalkingTestAggregate.Builder getNormalisationCircleBuilder() {
            if (this.normalisationCircleBuilder == null) {
                if (this.hasNormalisationCircle()) {
                    this.setNormalisationCircleBuilder(AltoidaWalkingTestAggregate.newBuilder(this.normalisationCircle));
                } else {
                    this.setNormalisationCircleBuilder(AltoidaWalkingTestAggregate.newBuilder());
                }
            }
            return this.normalisationCircleBuilder;
        }

        public Builder setNormalisationCircleBuilder(AltoidaWalkingTestAggregate.Builder value) {
            this.clearNormalisationCircle();
            this.normalisationCircleBuilder = value;
            return this;
        }

        public boolean hasNormalisationCircleBuilder() {
            return this.normalisationCircleBuilder != null;
        }

        public Builder clearNormalisationCircle() {
            this.normalisationCircle = null;
            this.normalisationCircleBuilder = null;
            this.fieldSetFlags()[34] = false;
            return this;
        }

        public AltoidaWalkingTestAggregate getNormalisationSquare() {
            return this.normalisationSquare;
        }

        public Builder setNormalisationSquare(AltoidaWalkingTestAggregate value) {
            this.validate(this.fields()[35], (Object)value);
            this.normalisationSquareBuilder = null;
            this.normalisationSquare = value;
            this.fieldSetFlags()[35] = true;
            return this;
        }

        public boolean hasNormalisationSquare() {
            return this.fieldSetFlags()[35];
        }

        public AltoidaWalkingTestAggregate.Builder getNormalisationSquareBuilder() {
            if (this.normalisationSquareBuilder == null) {
                if (this.hasNormalisationSquare()) {
                    this.setNormalisationSquareBuilder(AltoidaWalkingTestAggregate.newBuilder(this.normalisationSquare));
                } else {
                    this.setNormalisationSquareBuilder(AltoidaWalkingTestAggregate.newBuilder());
                }
            }
            return this.normalisationSquareBuilder;
        }

        public Builder setNormalisationSquareBuilder(AltoidaWalkingTestAggregate.Builder value) {
            this.clearNormalisationSquare();
            this.normalisationSquareBuilder = value;
            return this;
        }

        public boolean hasNormalisationSquareBuilder() {
            return this.normalisationSquareBuilder != null;
        }

        public Builder clearNormalisationSquare() {
            this.normalisationSquare = null;
            this.normalisationSquareBuilder = null;
            this.fieldSetFlags()[35] = false;
            return this;
        }

        public AltoidaWalkingTestAggregate getNormalisationSerpentine() {
            return this.normalisationSerpentine;
        }

        public Builder setNormalisationSerpentine(AltoidaWalkingTestAggregate value) {
            this.validate(this.fields()[36], (Object)value);
            this.normalisationSerpentineBuilder = null;
            this.normalisationSerpentine = value;
            this.fieldSetFlags()[36] = true;
            return this;
        }

        public boolean hasNormalisationSerpentine() {
            return this.fieldSetFlags()[36];
        }

        public AltoidaWalkingTestAggregate.Builder getNormalisationSerpentineBuilder() {
            if (this.normalisationSerpentineBuilder == null) {
                if (this.hasNormalisationSerpentine()) {
                    this.setNormalisationSerpentineBuilder(AltoidaWalkingTestAggregate.newBuilder(this.normalisationSerpentine));
                } else {
                    this.setNormalisationSerpentineBuilder(AltoidaWalkingTestAggregate.newBuilder());
                }
            }
            return this.normalisationSerpentineBuilder;
        }

        public Builder setNormalisationSerpentineBuilder(AltoidaWalkingTestAggregate.Builder value) {
            this.clearNormalisationSerpentine();
            this.normalisationSerpentineBuilder = value;
            return this;
        }

        public boolean hasNormalisationSerpentineBuilder() {
            return this.normalisationSerpentineBuilder != null;
        }

        public Builder clearNormalisationSerpentine() {
            this.normalisationSerpentine = null;
            this.normalisationSerpentineBuilder = null;
            this.fieldSetFlags()[36] = false;
            return this;
        }

        public AltoidaWalkingTestAggregate getNormalisationSpeedCircle() {
            return this.normalisationSpeedCircle;
        }

        public Builder setNormalisationSpeedCircle(AltoidaWalkingTestAggregate value) {
            this.validate(this.fields()[37], (Object)value);
            this.normalisationSpeedCircleBuilder = null;
            this.normalisationSpeedCircle = value;
            this.fieldSetFlags()[37] = true;
            return this;
        }

        public boolean hasNormalisationSpeedCircle() {
            return this.fieldSetFlags()[37];
        }

        public AltoidaWalkingTestAggregate.Builder getNormalisationSpeedCircleBuilder() {
            if (this.normalisationSpeedCircleBuilder == null) {
                if (this.hasNormalisationSpeedCircle()) {
                    this.setNormalisationSpeedCircleBuilder(AltoidaWalkingTestAggregate.newBuilder(this.normalisationSpeedCircle));
                } else {
                    this.setNormalisationSpeedCircleBuilder(AltoidaWalkingTestAggregate.newBuilder());
                }
            }
            return this.normalisationSpeedCircleBuilder;
        }

        public Builder setNormalisationSpeedCircleBuilder(AltoidaWalkingTestAggregate.Builder value) {
            this.clearNormalisationSpeedCircle();
            this.normalisationSpeedCircleBuilder = value;
            return this;
        }

        public boolean hasNormalisationSpeedCircleBuilder() {
            return this.normalisationSpeedCircleBuilder != null;
        }

        public Builder clearNormalisationSpeedCircle() {
            this.normalisationSpeedCircle = null;
            this.normalisationSpeedCircleBuilder = null;
            this.fieldSetFlags()[37] = false;
            return this;
        }

        public AltoidaTappingTestAggregate getNormalisationRandomTapping() {
            return this.normalisationRandomTapping;
        }

        public Builder setNormalisationRandomTapping(AltoidaTappingTestAggregate value) {
            this.validate(this.fields()[38], (Object)value);
            this.normalisationRandomTappingBuilder = null;
            this.normalisationRandomTapping = value;
            this.fieldSetFlags()[38] = true;
            return this;
        }

        public boolean hasNormalisationRandomTapping() {
            return this.fieldSetFlags()[38];
        }

        public AltoidaTappingTestAggregate.Builder getNormalisationRandomTappingBuilder() {
            if (this.normalisationRandomTappingBuilder == null) {
                if (this.hasNormalisationRandomTapping()) {
                    this.setNormalisationRandomTappingBuilder(AltoidaTappingTestAggregate.newBuilder(this.normalisationRandomTapping));
                } else {
                    this.setNormalisationRandomTappingBuilder(AltoidaTappingTestAggregate.newBuilder());
                }
            }
            return this.normalisationRandomTappingBuilder;
        }

        public Builder setNormalisationRandomTappingBuilder(AltoidaTappingTestAggregate.Builder value) {
            this.clearNormalisationRandomTapping();
            this.normalisationRandomTappingBuilder = value;
            return this;
        }

        public boolean hasNormalisationRandomTappingBuilder() {
            return this.normalisationRandomTappingBuilder != null;
        }

        public Builder clearNormalisationRandomTapping() {
            this.normalisationRandomTapping = null;
            this.normalisationRandomTappingBuilder = null;
            this.fieldSetFlags()[38] = false;
            return this;
        }

        public AltoidaTappingTestAggregate getNormalisationTapping() {
            return this.normalisationTapping;
        }

        public Builder setNormalisationTapping(AltoidaTappingTestAggregate value) {
            this.validate(this.fields()[39], (Object)value);
            this.normalisationTappingBuilder = null;
            this.normalisationTapping = value;
            this.fieldSetFlags()[39] = true;
            return this;
        }

        public boolean hasNormalisationTapping() {
            return this.fieldSetFlags()[39];
        }

        public AltoidaTappingTestAggregate.Builder getNormalisationTappingBuilder() {
            if (this.normalisationTappingBuilder == null) {
                if (this.hasNormalisationTapping()) {
                    this.setNormalisationTappingBuilder(AltoidaTappingTestAggregate.newBuilder(this.normalisationTapping));
                } else {
                    this.setNormalisationTappingBuilder(AltoidaTappingTestAggregate.newBuilder());
                }
            }
            return this.normalisationTappingBuilder;
        }

        public Builder setNormalisationTappingBuilder(AltoidaTappingTestAggregate.Builder value) {
            this.clearNormalisationTapping();
            this.normalisationTappingBuilder = value;
            return this;
        }

        public boolean hasNormalisationTappingBuilder() {
            return this.normalisationTappingBuilder != null;
        }

        public Builder clearNormalisationTapping() {
            this.normalisationTapping = null;
            this.normalisationTappingBuilder = null;
            this.fieldSetFlags()[39] = false;
            return this;
        }

        public AltoidaSummaryMetrics build() {
            try {
                AltoidaSummaryMetrics record = new AltoidaSummaryMetrics();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.audioHighReactionTimes = this.fieldSetFlags()[2] ? this.audioHighReactionTimes : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.audioHighAccuracy = this.fieldSetFlags()[3] ? this.audioHighAccuracy : ((Float)this.defaultValue(this.fields()[3])).floatValue();
                record.audioLowReactions = this.fieldSetFlags()[4] ? this.audioLowReactions : (Integer)this.defaultValue(this.fields()[4]);
                record.audioIgnoredHighTonePercentage = this.fieldSetFlags()[5] ? this.audioIgnoredHighTonePercentage : ((Float)this.defaultValue(this.fields()[5])).floatValue();
                record.audioPrematureToneButtonPresses = this.fieldSetFlags()[6] ? this.audioPrematureToneButtonPresses : (Integer)this.defaultValue(this.fields()[6]);
                record.randomScreenPressesDuringPlacement = this.fieldSetFlags()[7] ? this.randomScreenPressesDuringPlacement : (Integer)this.defaultValue(this.fields()[7]);
                record.randomScreenPressesDuringSearch = this.fieldSetFlags()[8] ? this.randomScreenPressesDuringSearch : (Integer)this.defaultValue(this.fields()[8]);
                record.tooMuchMovementCount = this.fieldSetFlags()[9] ? this.tooMuchMovementCount : (Integer)this.defaultValue(this.fields()[9]);
                record.findBetterPlaceCount = this.fieldSetFlags()[10] ? this.findBetterPlaceCount : ((Float)this.defaultValue(this.fields()[10])).floatValue();
                record.introReadTimes = this.fieldSetFlags()[11] ? this.introReadTimes : ((Float)this.defaultValue(this.fields()[11])).floatValue();
                record.introReadTime1 = this.fieldSetFlags()[12] ? this.introReadTime1 : ((Float)this.defaultValue(this.fields()[12])).floatValue();
                record.introReadTime2 = this.fieldSetFlags()[13] ? this.introReadTime2 : ((Float)this.defaultValue(this.fields()[13])).floatValue();
                record.placeDelays = this.fieldSetFlags()[14] ? this.placeDelays : ((Float)this.defaultValue(this.fields()[14])).floatValue();
                record.spotAlreadyTakenCount = this.fieldSetFlags()[15] ? this.spotAlreadyTakenCount : (Integer)this.defaultValue(this.fields()[15]);
                List<AltoidaTrial> list = record.trials = this.fieldSetFlags()[16] ? this.trials : (List<AltoidaTrial>)this.defaultValue(this.fields()[16]);
                if (this.trialMeansBuilder != null) {
                    try {
                        record.trialMeans = this.trialMeansBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("trialMeans"));
                        throw e;
                    }
                } else {
                    record.trialMeans = this.fieldSetFlags()[17] ? this.trialMeans : (AltoidaTrial)((Object)this.defaultValue(this.fields()[17]));
                }
                record.findFailCount = this.fieldSetFlags()[18] ? this.findFailCount : ((Float)this.defaultValue(this.fields()[18])).floatValue();
                record.findSkipDurations = this.fieldSetFlags()[19] ? this.findSkipDurations : ((Float)this.defaultValue(this.fields()[19])).floatValue();
                record.skipButtonCount = this.fieldSetFlags()[20] ? this.skipButtonCount : ((Float)this.defaultValue(this.fields()[20])).floatValue();
                record.countdownFail = this.fieldSetFlags()[21] ? this.countdownFail : ((Float)this.defaultValue(this.fields()[21])).floatValue();
                record.stepCountRatio = this.fieldSetFlags()[22] ? this.stepCountRatio : ((Float)this.defaultValue(this.fields()[22])).floatValue();
                record.stepDelayP = this.fieldSetFlags()[23] ? this.stepDelayP : ((Float)this.defaultValue(this.fields()[23])).floatValue();
                record.stepDelayF = this.fieldSetFlags()[24] ? this.stepDelayF : ((Float)this.defaultValue(this.fields()[24])).floatValue();
                record.stepVarianceP = this.fieldSetFlags()[25] ? this.stepVarianceP : ((Float)this.defaultValue(this.fields()[25])).floatValue();
                record.stepVarianceF = this.fieldSetFlags()[26] ? this.stepVarianceF : ((Float)this.defaultValue(this.fields()[26])).floatValue();
                record.notWalkingTimeP = this.fieldSetFlags()[27] ? this.notWalkingTimeP : ((Float)this.defaultValue(this.fields()[27])).floatValue();
                record.notWalkingTimeF = this.fieldSetFlags()[28] ? this.notWalkingTimeF : ((Float)this.defaultValue(this.fields()[28])).floatValue();
                record.shockCount = this.fieldSetFlags()[29] ? this.shockCount : ((Float)this.defaultValue(this.fields()[29])).floatValue();
                record.accelerationVarianceX = this.fieldSetFlags()[30] ? this.accelerationVarianceX : ((Float)this.defaultValue(this.fields()[30])).floatValue();
                record.accelerationVarianceY = this.fieldSetFlags()[31] ? this.accelerationVarianceY : ((Float)this.defaultValue(this.fields()[31])).floatValue();
                record.accelerationVarianceZ = this.fieldSetFlags()[32] ? this.accelerationVarianceZ : ((Float)this.defaultValue(this.fields()[32])).floatValue();
                float f = record.strongHand = this.fieldSetFlags()[33] ? this.strongHand : ((Float)this.defaultValue(this.fields()[33])).floatValue();
                if (this.normalisationCircleBuilder != null) {
                    try {
                        record.normalisationCircle = this.normalisationCircleBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationCircle"));
                        throw e;
                    }
                } else {
                    AltoidaWalkingTestAggregate altoidaWalkingTestAggregate = record.normalisationCircle = this.fieldSetFlags()[34] ? this.normalisationCircle : (AltoidaWalkingTestAggregate)((Object)this.defaultValue(this.fields()[34]));
                }
                if (this.normalisationSquareBuilder != null) {
                    try {
                        record.normalisationSquare = this.normalisationSquareBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationSquare"));
                        throw e;
                    }
                } else {
                    AltoidaWalkingTestAggregate altoidaWalkingTestAggregate = record.normalisationSquare = this.fieldSetFlags()[35] ? this.normalisationSquare : (AltoidaWalkingTestAggregate)((Object)this.defaultValue(this.fields()[35]));
                }
                if (this.normalisationSerpentineBuilder != null) {
                    try {
                        record.normalisationSerpentine = this.normalisationSerpentineBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationSerpentine"));
                        throw e;
                    }
                } else {
                    AltoidaWalkingTestAggregate altoidaWalkingTestAggregate = record.normalisationSerpentine = this.fieldSetFlags()[36] ? this.normalisationSerpentine : (AltoidaWalkingTestAggregate)((Object)this.defaultValue(this.fields()[36]));
                }
                if (this.normalisationSpeedCircleBuilder != null) {
                    try {
                        record.normalisationSpeedCircle = this.normalisationSpeedCircleBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationSpeedCircle"));
                        throw e;
                    }
                } else {
                    AltoidaWalkingTestAggregate altoidaWalkingTestAggregate = record.normalisationSpeedCircle = this.fieldSetFlags()[37] ? this.normalisationSpeedCircle : (AltoidaWalkingTestAggregate)((Object)this.defaultValue(this.fields()[37]));
                }
                if (this.normalisationRandomTappingBuilder != null) {
                    try {
                        record.normalisationRandomTapping = this.normalisationRandomTappingBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationRandomTapping"));
                        throw e;
                    }
                } else {
                    AltoidaTappingTestAggregate altoidaTappingTestAggregate = record.normalisationRandomTapping = this.fieldSetFlags()[38] ? this.normalisationRandomTapping : (AltoidaTappingTestAggregate)((Object)this.defaultValue(this.fields()[38]));
                }
                if (this.normalisationTappingBuilder != null) {
                    try {
                        record.normalisationTapping = this.normalisationTappingBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("normalisationTapping"));
                        throw e;
                    }
                } else {
                    record.normalisationTapping = this.fieldSetFlags()[39] ? this.normalisationTapping : (AltoidaTappingTestAggregate)((Object)this.defaultValue(this.fields()[39]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

