/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.kafka;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class RecordSet
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1407370459899870462L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"RecordSet\",\"namespace\":\"org.radarcns.kafka\",\"doc\":\"Abbreviated record set, meant for binary data transfers of larger sets of data. It can contain just a source ID and the record values. The record keys are deduced from authentication parameters. This method of data transfer requires that the data actually adheres to the schemas identified by the schema version.\",\"fields\":[{\"name\":\"keySchemaVersion\",\"type\":\"int\",\"doc\":\"Key schema version for the given topic.\"},{\"name\":\"valueSchemaVersion\",\"type\":\"int\",\"doc\":\"Value schema version for the given topic.\"},{\"name\":\"projectId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Project ID of the sent data. If null, it is attempted to be deduced from the credentials.\",\"default\":null},{\"name\":\"userId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"User ID of the sent data. If null, it is attempted to be deduced from the credentials.\",\"default\":null},{\"name\":\"sourceId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Source ID of the sent data.\"},{\"name\":\"data\",\"type\":{\"type\":\"array\",\"items\":\"bytes\"},\"doc\":\"Collected data. This should just contain the value records.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<RecordSet> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<RecordSet> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private int keySchemaVersion;
    private int valueSchemaVersion;
    private String projectId;
    private String userId;
    private String sourceId;
    private List<ByteBuffer> data;
    private static final DatumWriter<RecordSet> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<RecordSet> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<RecordSet> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<RecordSet> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<RecordSet> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static RecordSet fromByteBuffer(ByteBuffer b) throws IOException {
        return (RecordSet)((Object)DECODER.decode(b));
    }

    public RecordSet() {
    }

    public RecordSet(Integer keySchemaVersion, Integer valueSchemaVersion, String projectId, String userId, String sourceId, List<ByteBuffer> data) {
        this.keySchemaVersion = keySchemaVersion;
        this.valueSchemaVersion = valueSchemaVersion;
        this.projectId = projectId;
        this.userId = userId;
        this.sourceId = sourceId;
        this.data = data;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.keySchemaVersion;
            }
            case 1: {
                return this.valueSchemaVersion;
            }
            case 2: {
                return this.projectId;
            }
            case 3: {
                return this.userId;
            }
            case 4: {
                return this.sourceId;
            }
            case 5: {
                return this.data;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.keySchemaVersion = (Integer)value$;
                break;
            }
            case 1: {
                this.valueSchemaVersion = (Integer)value$;
                break;
            }
            case 2: {
                this.projectId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.userId = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.sourceId = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.data = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public int getKeySchemaVersion() {
        return this.keySchemaVersion;
    }

    public void setKeySchemaVersion(int value) {
        this.keySchemaVersion = value;
    }

    public int getValueSchemaVersion() {
        return this.valueSchemaVersion;
    }

    public void setValueSchemaVersion(int value) {
        this.valueSchemaVersion = value;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String value) {
        this.projectId = value;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String value) {
        this.userId = value;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String value) {
        this.sourceId = value;
    }

    public List<ByteBuffer> getData() {
        return this.data;
    }

    public void setData(List<ByteBuffer> value) {
        this.data = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(RecordSet other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeInt(this.keySchemaVersion);
        out.writeInt(this.valueSchemaVersion);
        if (this.projectId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.projectId);
        }
        if (this.userId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.userId);
        }
        out.writeString(this.sourceId);
        long size0 = this.data.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (ByteBuffer e0 : this.data) {
            ++actualSize0;
            out.startItem();
            out.writeBytes(e0);
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga0;
            this.keySchemaVersion = in.readInt();
            this.valueSchemaVersion = in.readInt();
            if (in.readIndex() != 1) {
                in.readNull();
                this.projectId = null;
            } else {
                this.projectId = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.userId = null;
            } else {
                this.userId = in.readString();
            }
            this.sourceId = in.readString();
            long size0 = in.readArrayStart();
            GenericData.Array a0 = this.data;
            if (a0 == null) {
                this.data = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("data").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    ByteBuffer e0 = ga0 != null ? (ByteBuffer)ga0.peek() : null;
                    e0 = in.readBytes(e0);
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
        } else {
            block10: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.keySchemaVersion = in.readInt();
                        continue block10;
                    }
                    case 1: {
                        this.valueSchemaVersion = in.readInt();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.projectId = null;
                            continue block10;
                        }
                        this.projectId = in.readString();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.userId = null;
                            continue block10;
                        }
                        this.userId = in.readString();
                        continue block10;
                    }
                    case 4: {
                        this.sourceId = in.readString();
                        continue block10;
                    }
                    case 5: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.data;
                        if (a0 == null) {
                            this.data = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("data").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                ByteBuffer e0 = ga0 != null ? (ByteBuffer)ga0.peek() : null;
                                e0 = in.readBytes(e0);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<RecordSet>
    implements RecordBuilder<RecordSet> {
        private int keySchemaVersion;
        private int valueSchemaVersion;
        private String projectId;
        private String userId;
        private String sourceId;
        private List<ByteBuffer> data;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.keySchemaVersion)) {
                this.keySchemaVersion = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.keySchemaVersion);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.valueSchemaVersion)) {
                this.valueSchemaVersion = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueSchemaVersion);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.projectId)) {
                this.projectId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.projectId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.userId)) {
                this.userId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.userId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.data)) {
                this.data = (List)this.data().deepCopy(this.fields()[5].schema(), other.data);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(RecordSet other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.keySchemaVersion)) {
                this.keySchemaVersion = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.keySchemaVersion);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.valueSchemaVersion)) {
                this.valueSchemaVersion = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.valueSchemaVersion);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.projectId)) {
                this.projectId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.projectId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.userId)) {
                this.userId = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.userId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.sourceId)) {
                this.sourceId = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sourceId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.data)) {
                this.data = (List)this.data().deepCopy(this.fields()[5].schema(), other.data);
                this.fieldSetFlags()[5] = true;
            }
        }

        public int getKeySchemaVersion() {
            return this.keySchemaVersion;
        }

        public Builder setKeySchemaVersion(int value) {
            this.validate(this.fields()[0], value);
            this.keySchemaVersion = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasKeySchemaVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearKeySchemaVersion() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public int getValueSchemaVersion() {
            return this.valueSchemaVersion;
        }

        public Builder setValueSchemaVersion(int value) {
            this.validate(this.fields()[1], value);
            this.valueSchemaVersion = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasValueSchemaVersion() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearValueSchemaVersion() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setProjectId(String value) {
            this.validate(this.fields()[2], value);
            this.projectId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasProjectId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearProjectId() {
            this.projectId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getUserId() {
            return this.userId;
        }

        public Builder setUserId(String value) {
            this.validate(this.fields()[3], value);
            this.userId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearUserId() {
            this.userId = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public Builder setSourceId(String value) {
            this.validate(this.fields()[4], value);
            this.sourceId = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSourceId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSourceId() {
            this.sourceId = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<ByteBuffer> getData() {
            return this.data;
        }

        public Builder setData(List<ByteBuffer> value) {
            this.validate(this.fields()[5], value);
            this.data = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasData() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearData() {
            this.data = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public RecordSet build() {
            try {
                RecordSet record = new RecordSet();
                record.keySchemaVersion = this.fieldSetFlags()[0] ? this.keySchemaVersion : (Integer)this.defaultValue(this.fields()[0]);
                record.valueSchemaVersion = this.fieldSetFlags()[1] ? this.valueSchemaVersion : (Integer)this.defaultValue(this.fields()[1]);
                record.projectId = this.fieldSetFlags()[2] ? this.projectId : (String)this.defaultValue(this.fields()[2]);
                record.userId = this.fieldSetFlags()[3] ? this.userId : (String)this.defaultValue(this.fields()[3]);
                record.sourceId = this.fieldSetFlags()[4] ? this.sourceId : (String)this.defaultValue(this.fields()[4]);
                record.data = this.fieldSetFlags()[5] ? this.data : (List)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

